goog.provide('Cl.CL');

goog.require('Cl');
goog.require('Cl.HashSet');
goog.require('Cl.HashTable');
goog.require('Cl.LinearExpression');
goog.require('Cl.Variable');

goog.scope(function() {
  var HashSet = Cl.HashSet;
  var HashTable = Cl.HashTable;
  var LinearExpression = Cl.LinearExpression;
  var Variable = Cl.Variable;
;
;
;
;
;
/**
 * @constructor
 */
Cl.CL = function() {};

Cl.CL.GEQ = 1;
Cl.CL.LEQ = 2;
Cl.CL.Assert = function(bool) {
  if (!bool) {
    throw "Nope.";
  }
};
Cl.CL.hashToString = function(h) {
  var answer;
  answer = "";
  h.each(function(k, v) {
    answer += k + " => ";
    return answer += v instanceof HashTable ? Cl.CL.hashToString(v) : v instanceof HashSet ? Cl.CL.setToString(v) : v + "\n";
  });
  return answer;
};
Cl.CL.setToString = function(s) {
  var answer, first;
  answer = s.size() + " {";
  first = true;
  s.each(function(e) {
    if (!first) {
      answer += ", ";
    } else {
      first = false;
    }
    return answer += e;
  });
  answer += "}\n";
  return answer;
};
Cl.CL.Times = function(e1, e2) {
  if (e1 instanceof LinearExpression && e2 instanceof LinearExpression) {
    return e1.times(e2);
  } else if (e1 instanceof LinearExpression && e2 instanceof Variable) {
    return e1.times(new LinearExpression(e2));
  } else if (e1 instanceof Variable && e2 instanceof LinearExpression) {
    return (new LinearExpression(e1)).times(e2);
  } else if (e1 instanceof LinearExpression && typeof e2 === "number") {
    return e1.times(new LinearExpression(e2));
  } else if (typeof e1 === "number" && e2 instanceof LinearExpression) {
    return (new LinearExpression(e1)).times(e2);
  } else if (typeof e1 === "number" && e2 instanceof Variable) {
    return new LinearExpression(e2, e1);
  } else if (e1 instanceof Variable && typeof e2 === "number") {
    return new LinearExpression(e1, e2);
  } else if (e1 instanceof Variable && e2 instanceof LinearExpression) {
    return new LinearExpression(e2, n);
  }
};
Cl.CL.Linify = function(x) {
  if (x instanceof LinearExpression) {
    return x;
  } else {
    return new LinearExpression(x);
  }
};
Cl.CL.Plus = function() {
  if (arguments.length === 0) {
    return new LinearExpression(0);
  } else {
    return [].slice.apply(arguments).map(Cl.CL.Linify).reduce(function(sum, v) {
      return sum.plus(v);
    });
  }
};
Cl.CL.Minus = function() {
  switch (arguments.length) {
    case 0:
      return new LinearExpression(0);
    case 1:
      return Cl.CL.Linify(arguments[0]).times(-1);
    default:
      return Cl.CL.Linify(arguments[0]).minus(Cl.CL.Plus.apply(null, [].slice.call(arguments, 1)));
  }
};;

}); // close goog.scope()
