goog.provide('Cl.Constraint');
goog.provide('Cl.EditConstraint');
goog.provide('Cl.EditOrStayConstraint');
goog.provide('Cl.StayConstraint');

goog.require('Cl');
goog.require('Cl.LinearExpression');
goog.require('Cl.Strength');

goog.scope(function() {

;
;
;
/**
 * @constructor
 */
Cl.Constraint = function(strength, weight) {
  this.hash_code = Cl.Constraint.iConstraintNumber++;
  this._strength = strength || Cl.Strength.required;
  this._weight = weight || 1;
  this._times_added = 0;
};

Cl.Constraint.prototype.hashCode = function() {
  return this.hash_code;
};
Cl.Constraint.prototype.isEditConstraint = function() {
  return false;
};
Cl.Constraint.prototype.isInequality = function() {
  return false;
};
Cl.Constraint.prototype.isRequired = function() {
  return this._strength.isRequired();
};
Cl.Constraint.prototype.isStayConstraint = function() {
  return false;
};
Cl.Constraint.prototype.strength = function() {
  return this._strength;
};
Cl.Constraint.prototype.weight = function() {
  return this._weight;
};
Cl.Constraint.prototype.toString = function() {
  return this._strength + " {" + this._weight + "} (" + this.expression() + ")";
};
Cl.Constraint.prototype.setAttachedObject = function(_attachedObject) {
  this._attachedObject = _attachedObject;
};
Cl.Constraint.prototype.getAttachedObject = function() {
  return this._attachedObject;
};
Cl.Constraint.prototype.changeStrength = function(strength) {
  if (this._times_added === 0) {
    return this.setStrength(strength);
  } else {
    throw new Cl.errors.TooDifficult();
  }
};
Cl.Constraint.prototype.addedTo = function(solver) {
  return ++this._times_added;
};
Cl.Constraint.prototype.removedFrom = function(solver) {
  return --this._times_added;
};
Cl.Constraint.prototype.setStrength = function(_strength) {
  this._strength = _strength;
};
Cl.Constraint.prototype.setWeight = function(_weight) {
  this._weight = _weight;
};;
/**
 * @constructor
 * @extends {Cl.Constraint}
 */
Cl.EditOrStayConstraint = function(clv, strength, weight) {
  Cl.Constraint.call(this, strength, weight);
  this._variable = clv;
  this._expression = new Cl.LinearExpression(this._variable, -1, this._variable.value());
};
goog.inherits(Cl.EditOrStayConstraint, Cl.Constraint);

Cl.EditOrStayConstraint.prototype.variable = function() {
  return this._variable;
};
Cl.EditOrStayConstraint.prototype.expression = function() {
  return this._expression;
};
Cl.EditOrStayConstraint.prototype.setVariable = function(_variable) {
  this._variable = _variable;
};;
/**
 * @constructor
 * @extends {Cl.EditOrStayConstraint}
 */
Cl.EditConstraint = function() {};
goog.inherits(Cl.EditConstraint, Cl.EditOrStayConstraint);

Cl.EditConstraint.prototype.isEditConstraint = function() {
  return true;
};
Cl.EditConstraint.prototype.toString = function() {
  return "edit" + Cl.EditConstraint.superClass_.toString.call(this);
};;
/**
 * @constructor
 * @extends {Cl.EditOrStayConstraint}
 */
Cl.StayConstraint = function(clv, strength, weight) {
  Cl.EditOrStayConstraint.call(this, clv, strength || Cl.Strength.weak, weight);
};
goog.inherits(Cl.StayConstraint, Cl.EditOrStayConstraint);

Cl.StayConstraint.prototype.isStayConstraint = function() {
  return true;
};
Cl.StayConstraint.prototype.toString = function() {
  return "stay " + Cl.StayConstraint.superClass_.toString.call(this);
};;
Cl.Constraint.iConstraintNumber = 1;

}); // close goog.scope()
