goog.provide('Cl.errors');
goog.provide('Cl.errors.ConstraintNotFound');
goog.provide('Cl.errors.Error');
goog.provide('Cl.errors.NonlinearExpression');
goog.provide('Cl.errors.NotEnoughStays');
goog.provide('Cl.errors.RequiredFailure');
goog.provide('Cl.errors.TooDifficult');

goog.require('Cl');

goog.scope(function() {

;
/**
 * @constructor
 */
Cl.errors = function() {};
;
/**
 * @constructor
 */
Cl.errors.Error = function() {};

Cl.errors.Error.prototype = new Error();
Cl.errors.Error.prototype.description = function() {
  return "An error has occurred in Cassowary Coffee";
};
Cl.errors.Error.prototype.toString = function() {
  return this.description;
};;
/**
 * @constructor
 * @extends {Cl.errors.Error}
 */
Cl.errors.ConstraintNotFound = function() {};
goog.inherits(Cl.errors.ConstraintNotFound, Cl.errors.Error);

Cl.errors.ConstraintNotFound.prototype.description = "Tried to remove a constraint never added to the tableau";;
/**
 * @constructor
 * @extends {Cl.errors.Error}
 */
Cl.errors.NonlinearExpression = function() {};
goog.inherits(Cl.errors.NonlinearExpression, Cl.errors.Error);

Cl.errors.NonlinearExpression.prototype.description = "The resulting expression would be nonlinear";;
/**
 * @constructor
 * @extends {Cl.errors.Error}
 */
Cl.errors.NotEnoughStays = function() {};
goog.inherits(Cl.errors.NotEnoughStays, Cl.errors.Error);

Cl.errors.NotEnoughStays.prototype.description = "There are not enough stays to give specific values to every variable";;
/**
 * @constructor
 * @extends {Cl.errors.Error}
 */
Cl.errors.RequiredFailure = function() {};
goog.inherits(Cl.errors.RequiredFailure, Cl.errors.Error);

Cl.errors.RequiredFailure.prototype.description = "A required constraint cannot be satisfied";;
/**
 * @constructor
 * @extends {Cl.errors.Error}
 */
Cl.errors.TooDifficult = function() {};
goog.inherits(Cl.errors.TooDifficult, Cl.errors.Error);

Cl.errors.TooDifficult.prototype.description = "The constraints are too difficult to solve";;

}); // close goog.scope()
