goog.provide('Cl.LinearConstraint');
goog.provide('Cl.LinearEquation');
goog.provide('Cl.LinearInequality');

goog.require('Cl');
goog.require('Cl.CL');
goog.require('Cl.Constraint');
goog.require('Cl.Constraint');
goog.require('Cl.Strength');

goog.scope(function() {
  var CL = Cl.CL;
;
;
;
;
/**
 * @constructor
 * @extends {Cl.Constraint}
 */
Cl.LinearConstraint = function(cle, strength, weight) {
  Cl.Constraint.call(this, strength, weight);
  this._expression = cle;
};
goog.inherits(Cl.LinearConstraint, Cl.Constraint);

Cl.LinearConstraint.prototype.expression = function() {
  return this._expression;
};
Cl.LinearConstraint.prototype.setExpression = function(_expression) {
  this._expression = _expression;
};;
/**
 * @constructor
 * @extends {Cl.LinearConstraint}
 */
Cl.LinearInequality = function(a1, a2, a3, a4, a5) {
  var cle, clv, op, strength, weight;
  if (a1 instanceof Cl.LinearExpression && a3 instanceof Cl.AbstractVariable) {
    cle = a1;
    op = a2;
    clv = a3;
    strength = a4;
    weight = a5;
    Cl.LinearConstraint.call(this, cle.clone(), strength, weight);
    if (op === CL.LEQ) {
      this._expression.multiplyMe(-1);
      this._expression.addVariable(clv);
    } else if (op === CL.GEQ) {
      this._expression.addVariable(clv, -1);
    } else {
      throw new Cl.errors.InternalError("Invalid operator in ClLinearInequality constructor");
    }
  } else if (a1 instanceof Cl.LinearExpression) {
    Cl.LinearConstraint.call(this, a1, a2, a3);
  } else if (a2 === CL.GEQ) {
    Cl.LinearConstraint.call(this, new Cl.LinearExpression(a3), a4, a5);
    this._expression.multiplyMe(-1.0);
    this._expression.addVariable(a1);
  } else if (a2 === CL.LEQ) {
    Cl.LinearConstraint.call(this, new Cl.LinearExpression(a3), a4, a5);
    this._expression.addVariable(a1, -1.0);
  } else {
    throw new Cl.errors.InternalError("Invalid operator in ClLinearInequality constructor");
  }
};
goog.inherits(Cl.LinearInequality, Cl.LinearConstraint);

Cl.LinearInequality.prototype.isInequality = function() {
  return true;
};
Cl.LinearInequality.prototype.toString = function() {
  return Cl.LinearInequality.superClass_.toString.call(this) + " >= 0 )";
};;
/**
 * @constructor
 * @extends {Cl.LinearConstraint}
 */
Cl.LinearEquation = function(a1, a2, a3, a4) {
  var cle, clv, strength, val, weight;
  if (a1 instanceof Cl.LinearExpression && !a2 || a2 instanceof Cl.Strength) {
    Cl.LinearConstraint.call(this, a1, a2, a3);
  } else if ((a1 instanceof Cl.AbstractVariable) && (a2 instanceof Cl.LinearExpression)) {
    clv = a1;
    cle = a2;
    strength = a3;
    weight = a4;
    Cl.LinearConstraint.call(this, cle, strength, weight);
    this._expression.addVariable(clv, -1);
  } else if ((a1 instanceof Cl.AbstractVariable) && (typeof a2 === "number")) {
    clv = a1;
    val = a2;
    strength = a3;
    weight = a4;
    Cl.LinearConstraint.call(this, new Cl.LinearExpression(val), strength, weight);
    this._expression.addVariable(clv, -1);
  } else if ((a1 instanceof Cl.LinearExpression) && (a2 instanceof Cl.AbstractVariable)) {
    cle = a1;
    clv = a2;
    strength = a3;
    weight = a4;
    Cl.LinearConstraint.call(this, cle.clone(), strength, weight);
    this._expression.addVariable(clv, -1);
  } else if ((a1 instanceof Cl.LinearExpression) || (a1 instanceof Cl.AbstractVariable) || (typeof a1 === "number") && (a2 instanceof Cl.LinearExpression) || (a2 instanceof Cl.AbstractVariable) || (typeof a2 === "number")) {
    if (a1 instanceof Cl.LinearExpression) {
      a1 = a1.clone();
    } else {
      a1 = new Cl.LinearExpression(a1);
    }
    if (a2 instanceof Cl.LinearExpression) {
      a2 = a2.clone();
    } else {
      a2 = new Cl.LinearExpression(a2);
    }
    Cl.LinearConstraint.call(this, a1, a3, a4);
    this._expression.addExpression(a2, -1);
  } else {
    throw "Bad initializer to ClLinearEquation";
  }
};
goog.inherits(Cl.LinearEquation, Cl.LinearConstraint);

Cl.LinearEquation.prototype.toString = function() {
  return Cl.LinearEquation.superClass_.toString.call(this) + " = 0 )";
};;

}); // close goog.scope()
