goog.provide('Cl.Point');

goog.require('Cl');

goog.scope(function() {

;
/**
 * @constructor
 */
Cl.Point = function(x, y, suffix) {
  if (x instanceof ClVariable) {
    this.x = x;
  } else {
    if (suffix != null) {
      this.x = new ClVariable("x" + suffix, x);
    } else {
      this.x = new ClVariable(x);
    }
  }
  if (y instanceof ClVariable) {
    this.y = y;
  } else {
    if (suffix != null) {
      this.y = new ClVariable("y" + suffix, y);
    } else {
      this.y = new ClVariable(y);
    }
  }
};

Cl.Point.prototype.SetXY = function(x, y) {
  if (x instanceof ClVariable) {
    this.x = x;
  } else {
    this.x.set_value(x);
  }
  if (y instanceof ClVariable) {
    return this.y = y;
  } else {
    return this.y.set_value(y);
  }
};
Cl.Point.prototype.X = function() {
  return this.x;
};
Cl.Point.prototype.Y = function() {
  return this.y;
};
Cl.Point.prototype.Xvalue = function() {
  return this.x.value();
};
Cl.Point.prototype.Yvalue = function() {
  return this.y.value();
};
Cl.Point.prototype.toString = function() {
  return "(" + this.x + ", " + this.y + ")";
};;

}); // close goog.scope()
