goog.provide('Cl.SymbolicWeight');

goog.require('Cl');

goog.scope(function() {

;
/**
 * @constructor
 */
Cl.SymbolicWeight = function(w1, w2, w3) {
  this._values = new Array(w1, w2, w3);
};

Cl.SymbolicWeight.prototype.times = function(n) {
  return new Cl.SymbolicWeight(this._values[0] * n, this._values[1] * n, this._values[2] * n);
};
Cl.SymbolicWeight.prototype.divideBy = function(n) {
  return new Cl.SymbolicWeight(this._values[0] / n, this._values[1] / n, this._values[2] / n);
};
Cl.SymbolicWeight.prototype.add = function(c) {
  return new Cl.SymbolicWeight(this._values[0] + c._values[0], this._values[1] + c._values[1], this._values[2] + c._values[2]);
};
Cl.SymbolicWeight.prototype.subtract = function(c) {
  return new Cl.SymbolicWeight(this._values[0] - c._values[0], this._values[1] - c._values[1], this._values[2] - c._values[2]);
};
Cl.SymbolicWeight.prototype.lessThan = function(c) {
  var i;
  i = 0;
  while (i < this._values.length) {
    if (this._values[i] < c._values[i]) {
      return true;
    } else {
      if (this._values[i] > c._values[i]) {
        return false;
      }
    }
    ++i;
  }
  return false;
};
Cl.SymbolicWeight.prototype.lessThanOrEqual = function(c) {
  var i;
  i = 0;
  while (i < this._values.length) {
    if (this._values[i] < c._values[i]) {
      return true;
    } else {
      if (this._values[i] > c._values[i]) {
        return false;
      }
    }
    ++i;
  }
  return true;
};
Cl.SymbolicWeight.prototype.equal = function(c) {
  var i;
  i = 0;
  while (i < this._values.length) {
    if (this._values[i] !== c._values[i]) {
      return false;
    }
    ++i;
  }
  return true;
};
Cl.SymbolicWeight.prototype.greaterThan = function(c) {
  return !this.lessThanOrEqual(c);
};
Cl.SymbolicWeight.prototype.greaterThanOrEqual = function(c) {
  return !this.lessThan(c);
};
Cl.SymbolicWeight.prototype.isNegative = function() {
  return this.lessThan(Cl.SymbolicWeight.clsZero);
};
Cl.SymbolicWeight.prototype.toDouble = function() {
  var factor, i, multiplier, sum;
  sum = 0;
  factor = 1;
  multiplier = 1000;
  i = this._values.length - 1;
  while (i >= 0) {
    sum += this._values[i] * factor;
    factor *= multiplier;
    --i;
  }
  return sum;
};
Cl.SymbolicWeight.prototype.toString = function() {
  return "[" + this._values[0] + "," + this._values[1] + "," + this._values[2] + "]";
};
Cl.SymbolicWeight.prototype.cLevels = function() {
  return 3;
};;
Cl.SymbolicWeight.clsZero = new Cl.SymbolicWeight(0, 0, 0);

}); // close goog.scope()
