goog.provide('Cl.AbstractVariable');
goog.provide('Cl.DummyVariable');
goog.provide('Cl.ObjectiveVariable');
goog.provide('Cl.SlackVariable');
goog.provide('Cl.Variable');

goog.require('Cl');

goog.scope(function() {

;
/**
 * @constructor
 */
Cl.AbstractVariable = function(a1, a2) {
  var prefix, varnumber;
  this.hash_code = Cl.AbstractVariable.iVariableNumber++;
  if (typeof a1 === "string" || (!(a1 != null))) {
    this._name = a1 || "v" + this.hash_code;
  } else {
    varnumber = a1;
    prefix = a2;
    this._name = prefix + varnumber;
  }
};

Cl.AbstractVariable.prototype.hashCode = function() {
  return this.hash_code;
};
Cl.AbstractVariable.prototype.name = function() {
  return this._name;
};
Cl.AbstractVariable.prototype.setName = function(_name) {
  this._name = _name;
};
Cl.AbstractVariable.prototype.isDummy = function() {
  return false;
};
Cl.AbstractVariable.prototype.isExternal = function() {
  throw "abstract isExternal";
};
Cl.AbstractVariable.prototype.isPivotable = function() {
  throw "abstract isPivotable";
};
Cl.AbstractVariable.prototype.isRestricted = function() {
  throw "abstract isRestricted";
};
Cl.AbstractVariable.prototype.toString = function() {
  return "ABSTRACT[" + this._name + "]";
};;
Cl.AbstractVariable.iVariableNumber = 1;
/**
 * @constructor
 * @extends {Cl.AbstractVariable}
 */
Cl.Variable = function(name_or_val, value) {
  this._name = "";
  this._value = 0.0;
  if (typeof name_or_val === "string") {
    Cl.AbstractVariable.call(this, name_or_val);
    this._value = value || 0.0;
  } else if (typeof name_or_val === "number") {
    Cl.AbstractVariable.call(this);
    this._value = name_or_val;
  } else {
    Cl.AbstractVariable.call(this);
  }
  if (Cl.Variable._ourVarMap) {
    Cl.Variable._ourVarMap[this._name] = this;
  }
};
goog.inherits(Cl.Variable, Cl.AbstractVariable);

Cl.Variable.prototype.isDummy = function() {
  return false;
};
Cl.Variable.prototype.isExternal = function() {
  return true;
};
Cl.Variable.prototype.isPivotable = function() {
  return false;
};
Cl.Variable.prototype.isRestricted = function() {
  return false;
};
Cl.Variable.prototype.toString = function() {
  return "[" + this.name() + ":" + this._value + "]";
};
Cl.Variable.prototype.value = function() {
  return this._value;
};
Cl.Variable.prototype.set_value = function(_value) {
  this._value = _value;
};
Cl.Variable.prototype.change_value = function(_value) {
  this._value = _value;
};
Cl.Variable.prototype.setAttachedObject = function(_attachedObject) {
  this._attachedObject = _attachedObject;
};
Cl.Variable.prototype.getAttachedObject = function() {
  return this._attachedObject;
};;
/**
 * @constructor
 * @extends {Cl.AbstractVariable}
 */
Cl.DummyVariable = function(name_or_val, prefix) {
  Cl.AbstractVariable.call(this, name_or_val, prefix);
};
goog.inherits(Cl.DummyVariable, Cl.AbstractVariable);

Cl.DummyVariable.prototype.isDummy = function() {
  return true;
};
Cl.DummyVariable.prototype.isExternal = function() {
  return false;
};
Cl.DummyVariable.prototype.isPivotable = function() {
  return false;
};
Cl.DummyVariable.prototype.isRestricted = function() {
  return true;
};
Cl.DummyVariable.prototype.toString = function() {
  return "[" + this.name() + ":dummy]";
};;
/**
 * @constructor
 * @extends {Cl.AbstractVariable}
 */
Cl.ObjectiveVariable = function(name_or_val, prefix) {
  Cl.AbstractVariable.call(this, name_or_val, prefix);
};
goog.inherits(Cl.ObjectiveVariable, Cl.AbstractVariable);

Cl.ObjectiveVariable.prototype.isExternal = function() {
  return false;
};
Cl.ObjectiveVariable.prototype.isPivotable = function() {
  return false;
};
Cl.ObjectiveVariable.prototype.isRestricted = function() {
  return false;
};
Cl.ObjectiveVariable.prototype.toString = function() {
  return "[" + this.name() + ":obj]";
};;
/**
 * @constructor
 * @extends {Cl.AbstractVariable}
 */
Cl.SlackVariable = function(name_or_val, prefix) {
  Cl.AbstractVariable.call(this, name_or_val, prefix);
};
goog.inherits(Cl.SlackVariable, Cl.AbstractVariable);

Cl.SlackVariable.prototype.isExternal = function() {
  return false;
};
Cl.SlackVariable.prototype.isPivotable = function() {
  return true;
};
Cl.SlackVariable.prototype.isRestricted = function() {
  return true;
};
Cl.SlackVariable.prototype.toString = function() {
  return "[" + this.name() + ":slack]";
};;

}); // close goog.scope()
