;;This file autogenerated from 
;;
;;  src/cljx/dubstep/core.cljx
;;
(ns dubstep.core (:use [dubstep.util :only [->coll]]))
(defn machine "Returns a new state machine." [] (atom {:states {}, :events {}, :current #{}} :meta {:type :dubstep/state-machine}))
(defn get-in-sm [sm ks] (get-in (clojure.core/deref sm) ks))
(defn assoc-sm [sm ks v] (swap! sm (fn* [p1__14158#] (assoc-in p1__14158# ks v))))
(defn update-sm [sm & fntail] (swap! sm (fn* [p1__14653#] (apply update-in p1__14653# fntail))))
(defn get-name [sm] (get-in-sm sm [:name]))
(defn has-state? [sm s] (get-in-sm sm [:states s]))
(defn has-event? [sm e] (get-in-sm sm [:events e]))
(defn current [sm] (get-in-sm sm [:current]))
(defn in? [sm s] ((current sm) s))
(defn print-sm [sm] (str "<Dubstep: " (prn-str {:current (current sm), :states (keys (get-in-sm sm [:states])), :events (keys (get-in-sm sm [:events]))}) ">"))
(defn enter! "Move a state machine into the provided state(s)." [sm states] (doseq [s (->coll states)] (when-not (has-state? sm s) (throw (js/Error. (str "State machine doesn't have state " s)))) (when-not (in? sm s) (update-sm sm [:current] conj s) (when-let [enter (get-in-sm sm [:states s :enter])] (enter sm (get-in-sm sm [:states s :wubs]))))) sm)
(defn exit! "Move a state machine out of the provided state(s)." [sm states] (doseq [s (->coll states)] (when-not (has-state? sm s) (throw (js/Error. (str "State machine doesn't have state " s)))) (when (in? sm s) (update-sm sm [:current] disj s) (if-let [exit (get-in-sm sm [:states s :exit])] (exit sm (get-in-sm sm [:states s :wubs]))))) sm)
(defn transition! [sm states-to-exit states-to-enter] (apply exit! sm (->coll states-to-exit)) (apply enter! sm (->coll states-to-enter)) sm)
(defn trigger! [sm events & context] (doseq [e (->coll events)] (when-let [event (get-in-sm sm [:events e :event])] (apply event sm context))) sm)