;;This file autogenerated from 
;;
;;  src/cljx/dubstep/serialize.cljx
;;
(ns dubstep.serialize "(De)Serialize state machines and their associated wubs." (:use [dubstep.core :only [assoc-sm get-in-sm enter!]]))
(defmulti deserialize! "Restore a ref-like object's state from some value" (fn [x serialization-str] (let [t (get (meta x) :type)] (cond (keyword? t) t (= (type x) cljs.core.Atom) :atom :default (type x)))))
(defmethod deserialize! :atom [a v] (reset! a v))
(defmethod deserialize! :dubstep/state-machine [sm v] (if (string? v) (deserialize! sm (read-string v)) (let [{:keys [current states]} v] (when (or (nil? current) (nil? states)) (throw (Error. "Cannot deserialize state machine; :current and/or :states keys are missing"))) (doseq [s current] (enter! sm s)) (doseq [[s {:keys [wubs]}] states] (doseq [[w v] wubs] (deserialize! (get-in-sm sm [:states s :wubs w]) v))))))
(do (defmethod print-method clojure.lang.Atom [a w] (.write w (pr-str (clojure.core/deref a)))) (defmethod print-method :dubstep/state-machine [sm w] (binding [*print-meta* true] (.write w (pr-str (with-meta (clojure.core/deref sm) {:dubstep/state-machine true}))))) (defn serialize [sm] (pr-str sm)))