var ConstructorTable, DefaultReader, JTL, LiteralPrefix, TagTable, get_tag, p;

goog.provide("com.keminglabs.jtl");

goog.require("goog.structs.Map");

goog.require("goog.object");

p = function(x) {
  console.log(x);
  return x;
};

get_tag = function(literal_prefix, x) {
  var ks;

  if (x instanceof Object) {
    ks = Object.keys(x);
    if (ks.length === 1 && ks[0][0] === literal_prefix) {
      return Object.keys(x)[0].substring(1);
    }
  }
};

LiteralPrefix = "#";

DefaultReader = function(tag, x) {
  throw new Error("Tag '" + tag + "' not recognized");
};

TagTable = {
  "inst": function(x) {
    return new Date(Date.parse(x));
  }
};

ConstructorTable = new goog.structs.Map(Date, function(d) {
  return ["inst", d.toISOString()];
});

JTL = null;

goog.scope(function() {
  JTL = com.keminglabs.jtl;
  JTL.deserialize = function(x, opts) {
    var tag, tag_reader, val, _base;

    opts || (opts = {});
    opts["tag_table"] || (opts["tag_table"] = {});
    (_base = opts["tag_table"])["inst"] || (_base["inst"] = TagTable["inst"]);
    tag = get_tag(opts["literal_prefix"] || LiteralPrefix, x);
    if (tag) {
      tag_reader = opts["tag_table"][tag];
      val = x[Object.keys(x)[0]];
      if (tag_reader) {
        return tag_reader(JTL.deserialize(val, opts));
      } else {
        return (opts["default_reader"] || DefaultReader)(tag, val);
      }
    } else if (goog.isArray(x)) {
      return x.map(function(v) {
        return JTL.deserialize(v, opts);
      });
    } else if (goog.isObject(x)) {
      return goog.object.map(x, function(v, k) {
        return JTL.deserialize(v, opts);
      });
    } else {
      return x;
    }
  };
  JTL.serialize = function(x, opts) {
    var klass, res, serializer, tag, val, _ref, _ref1;

    opts || (opts = {});
    klass = x != null ? x["constructor"] : null;
    serializer = (_ref = opts["constructor_table"] || ConstructorTable) != null ? _ref.get(klass) : void 0;
    if (serializer) {
      _ref1 = serializer(x, opts), tag = _ref1[0], val = _ref1[1];
      res = {};
      res[(opts["literal_prefix"] || LiteralPrefix) + tag] = val;
      return res;
    } else if (goog.isArray(x)) {
      return x.map(function(v) {
        return JTL.serialize(v, opts);
      });
    } else if (goog.isObject(x)) {
      return goog.object.map(x, function(v, k) {
        return JTL.serialize(v, opts);
      });
    } else {
      return x;
    }
  };
  ;
});
