(ns com.keminglabs.util.macros
  (:require hiccup.core))

(defmacro p
  "Print and return native JavaScript argument."
  [x]
  `(let [res# ~x]
     (.log js/console res#)
     res#))

(defmacro pp
  "Pretty print and return argument (uses `prn-str` internally)."
  [x]
  `(let [res# ~x]
     (.log js/console (prn-str res#))
     res#))

(defmacro angular-el
  "Creates a new angular live DOM element from provided hiccup"
  [hiccup-el]
  `(.element ~'js/angular ~(hiccup.core/html hiccup-el)))
