(ns com.keminglabs.util.macros
  (:require hiccup.core))

(defmacro p
  "Print and return native JavaScript argument."
  [x]
  `(let [res# ~x]
     (.log js/console res#)
     res#))

(defmacro pp
  "Pretty print and return argument (uses `prn-str` internally)."
  [x]
  `(let [res# ~x]
     (.log js/console (prn-str res#))
     res#))

(defmacro angular-el
  "Creates a new angular live DOM element from provided hiccup"
  [hiccup-el]
  `(.element ~'js/angular ~(hiccup.core/html hiccup-el)))

(defmacro defng [name args & body]
  `(do
       (defn ~(with-meta name {:export true}) ~args
         ~@body)
     (~'aset ~name "$inject" (~'array ~@(map str args)))))

(defmacro fng
  "Similar to fn, but expands into Angular-minifier-safe version, a JavaScript array of argnames with fn in last position."
  [args & body]
  `(~'array ~@(map str args) (fn ~args ~@body)))