(ns singult.core
  (:require [singult.coffee :as sc]))

(defn clj->js
  "Recursively transforms ClojureScript maps into Javascript objects,
   other ClojureScript colls into JavaScript arrays, and ClojureScript
   keywords into JavaScript strings."
  [x]
  (cond
   (instance? sc/Unify x) x
   (keyword? x) (name x)
   (map? x)     (let [o (js-obj)]
                  (doseq [[k v] x]
                    (let [key (clj->js k)]
                      (when-not (string? key)
                        (throw "Cannot convert; JavaScript map keys must be strings"))
                      (aset o key (clj->js v))))
                  o)
   (coll? x)    (let [a (array)]
                  (doseq [item x]
                    (.push a (clj->js item)))
                  a)
   :else x))


(defn render [v]
  (-> v
      clj->js
      sc/canonicalize
      sc/render))

(defn merge! [$n v] (->> v
                         clj->js
                         sc/canonicalize
                         (sc/merge $n)))


(defn unify [data mapping & {:keys [key-fn enter update exit]
                             :or {key-fn (fn [d idx] idx)}}]
 
  (sc/Unify. (clj->js data)
              #(clj->js (mapping %))
             key-fn enter update exit))
