var array_p, explode_p, key_prefix, map_p, namespace_tag, number_p, p, re_svg_tags, re_tag, re_whitespace, string_p, unify_p, whitespace_node_p, xmlns;
var __hasProp = Object.prototype.hasOwnProperty;

goog.require("goog.string");

goog.provide("singult.coffee");

goog.provide("singult.coffee.Unify");

p = function(x) {
  console.log(x);
  return x;
};

re_tag = /([^\s\.#]+)(?:#([^\s\.#]+))?(?:\.([^\s#]+))?/;

re_svg_tags = /(svg|g|rect|circle|clipPath|path|line|polygon|polyline|text|textPath)/;

re_whitespace = /^\s+$/;

key_prefix = "\0";

xmlns = {
  xhtml: "http://www.w3.org/1999/xhtml",
  svg: "http://www.w3.org/2000/svg"
};

namespace_tag = function(tag_str) {
  var nsp, tag, _ref;
  _ref = tag_str.split(":"), nsp = _ref[0], tag = _ref[1];
  if (tag != null) {
    return [xmlns[nsp] || nsp, tag];
  } else {
    if (tag_str.match(re_svg_tags)) {
      return [xmlns.svg, tag_str];
    } else {
      return [xmlns.xhtml, tag_str];
    }
  }
};

explode_p = function(v) {
  return v[0] === ":*:";
};

unify_p = function(x) {
  return (x != null) && (x instanceof singult.coffee.Unify);
};

array_p = function(x) {
  return (x != null) && (x.forEach != null);
};

map_p = function(x) {
  return (x != null) && (!array_p(x)) && (!unify_p(x)) && (x instanceof Object);
};

string_p = function(x) {
  return (x != null) && (x.substring != null);
};

number_p = function(x) {
  return (x != null) && (x.toFixed != null);
};

whitespace_node_p = function($n) {
  return $n.nodeType === 3 && $n.textContent.match(re_whitespace);
};

singult.coffee.style = function($e, m) {
  var k, v, _results;
  _results = [];
  for (k in m) {
    if (!__hasProp.call(m, k)) continue;
    v = m[k];
    _results.push($e.style[goog.string.toCamelCase(k)] = v);
  }
  return _results;
};

singult.coffee.attr = function($e, attr_map) {
  var k, v, _results;
  if (attr_map.style != null) {
    singult.coffee.style($e, attr_map.style);
    delete attr_map.style;
  }
  _results = [];
  for (k in attr_map) {
    if (!__hasProp.call(attr_map, k)) continue;
    v = attr_map[k];
    _results.push($e.setAttribute(k, v));
  }
  return _results;
};

singult.coffee.node_data = function($e, d) {
  if (d != null) {
    return $e.__c2_data__ = d;
  } else {
    return $e.__c2_data__;
  }
};

singult.coffee.canonicalize = function(x) {
  if (number_p(x)) {
    return x.toString();
  } else if (array_p(x)) {
    return singult.coffee.canonicalize_hiccup(x);
  } else {
    return x;
  }
};

singult.coffee.canonicalize_hiccup = function(v) {
  var attr, canonical, canonical_children, children, cls_str, id, nsp, tag, tag_str, _, _ref, _ref2, _ref3;
  tag = v[0];
  _ref = map_p(v[1]) ? [v[1], v.slice(2)] : [{}, v.slice(1)], attr = _ref[0], children = _ref[1];
  _ref2 = tag.match(re_tag), _ = _ref2[0], tag_str = _ref2[1], id = _ref2[2], cls_str = _ref2[3];
  if (id != null) attr["id"] = id;
  if (cls_str != null) {
    attr["class"] = cls_str.replace(".", " ") + (attr["class"] != null ? " " + attr["class"] : "");
  }
  _ref3 = namespace_tag(tag_str), nsp = _ref3[0], tag = _ref3[1];
  canonical_children = [];
  children.forEach(function(v) {
    if (explode_p(v)) {
      return v.slice(1).forEach(function(v) {
        return canonical_children.push(singult.coffee.canonicalize(v));
      });
    } else {
      return canonical_children.push(singult.coffee.canonicalize(v));
    }
  });
  canonical = {
    nsp: nsp,
    tag: tag,
    attr: attr,
    children: canonical_children
  };
  return canonical;
};

singult.coffee.render = function(m) {
  var $e, c;
  if (string_p(m)) {
    return document.createTextNode(m);
  } else {
    $e = document.createElementNS(m.nsp, m.tag);
    singult.coffee.attr($e, m.attr);
    if (unify_p((c = m.children[0]))) {
      if (c.enter != null) {
        c.data.forEach(function(d) {
          return $e.appendChild(c.enter(d));
        });
      } else {
        c.data.forEach(function(d) {
          return $e.appendChild(singult.coffee.render(singult.coffee.canonicalize(c.mapping(d))));
        });
      }
    } else {
      m.children.forEach(function($c) {
        return $e.appendChild(singult.coffee.render($c));
      });
    }
    return $e;
  }
};

/**
 * @constructor
 */;

singult.coffee.Unify = function(data, mapping, key_fn, enter, update, exit) {
  this.data = data;
  this.mapping = mapping;
  this.key_fn = key_fn;
  this.enter = enter;
  this.update = update;
  return this.exit = exit;
};

singult.coffee.unify_ = function($container, u) {
  var $n, $nodes, enter, exit, i, key, nodes_by_key, update, _;
  enter = u.enter || function(d) {
    var $el;
    $el = singult.coffee.render(singult.coffee.canonicalize(u.mapping(d)));
    $container.appendChild($el);
    return $el;
  };
  update = u.update || function($n, d) {
    return singult.coffee.merge($n, singult.coffee.canonicalize(u.mapping(d)));
  };
  exit = u.exit || function($n) {
    return $container.removeChild($n);
  };
  $nodes = $container.childNodes;
  nodes_by_key = {};
  i = 0;
  while (i < $nodes.length) {
    key = key_prefix + u.key_fn(singult.coffee.node_data($nodes[i]), i);
    nodes_by_key[key] = $nodes[i];
    i += 1;
  }
  u.data.forEach(function(d, i) {
    var $el, $n;
    key = key_prefix + u.key_fn(d, i);
    if ($n = nodes_by_key[key]) {
      $el = update($n, d);
      singult.coffee.node_data($el, d);
      return delete nodes_by_key[key];
    } else {
      $el = enter(d);
      return singult.coffee.node_data($el, d);
    }
  });
  for (_ in nodes_by_key) {
    $n = nodes_by_key[_];
    p($n);
    exit($n);
  }
  return null;
};

singult.coffee.merge = function($e, m) {
  var $c, c, i, _i, _len, _ref;
  if (unify_p(m)) {
    singult.coffee.unify_($e, m);
  } else {
    if ($e.nodeName.toLowerCase() !== m.tag.toLowerCase()) {
      p($e);
      p(m);
      throw "Cannot merge $e into node of different type";
    }
    singult.coffee.attr($e, m.attr);
    _ref = $e.childNodes;
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      $c = _ref[_i];
      if (whitespace_node_p($c)) $e.removeChild($c);
    }
    if (unify_p(m.children[0])) {
      singult.coffee.merge($e, m.children[0]);
    } else {
      if ($e.childNodes.length > m.children.length) {
        throw "Removing DOM nodes in singult.core#merge! not yet implemented = (";
      }
      i = 0;
      while (i < m.children.length) {
        c = m.children[i] || "";
        $c = $e.childNodes[i];
        if (string_p(c)) {
          if ($c != null) {
            $c.textContent = c;
          } else {
            $e.appendChild(document.createTextNode(c));
          }
        } else if (map_p(c)) {
          if ($c != null) {
            singult.coffee.merge($c, c);
          } else {
            $e.appendChild(singult.coffee.render(c));
          }
        } else {
          p($c);
          p(c);
          throw "Cannot merge children";
        }
        i += 1;
      }
    }
  }
  return $e;
};
