;; (c) Copyright 2024-2025 clojure-collections Contributors. All rights reserved.
;;
;; Licensed under the Apache License, Version 2.0 (the "License");
;; you may not use this file except in compliance with the License.
;; You may obtain a copy of the License at
;;
;;     http://www.apache.org/licenses/LICENSE-2.0
;;
;; Unless required by applicable law or agreed to in writing, software
;; distributed under the License is distributed on an "AS IS" BASIS,
;; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
;; See the License for the specific language governing permissions and
;; limitations under the License.


;; KineticFire Labs: https://labs.kineticfire.com/
;;	   Project site: https://github.com/kineticfire-labs/clojure-collections/


(ns kineticfire.collections.set
  (:require [clojure.set :as set])
  (:gen-class))



(defn symmetric-difference [set1 set2]
  "Returns a set that is the symmetric difference between the first set `set1` and second set `set2`.  That is, the
  returned set contains all the values that are present in one set but not the other."
  (set/union (set/difference set1 set2) (set/difference set2 set1)))
