(ns com.laurent.utils.scl.core)

(defrecord TestClass [ a b ])
(defn new-tc [x y] (TestClass. (ref x) (ref y)))
(defn tc-equal [x y]
	(and (= @(:a x) @(:a y)) (= @(:b x) @(:b y))))

(defrecord SimpleChainedList [ obj next ])

(def *scl-comp* (ref #'=))

(defn new-scl [x] (SimpleChainedList. (ref x) (ref nil)))

(defn scl-pprint [oscl]
	(loop [scl oscl buf ">"]
		(when (not (nil? scl))
			(print buf)
			(print (str @(:obj scl) "\n"))
			(recur @(:next scl) (str " " buf)))))	


(defn scl-append [oscl x & {:keys [comp] :or {comp @*scl-comp*} } ] 
	(loop [scl oscl]
		(when (not (comp @(:obj scl) x ))
			(if (nil? @(:next scl))
				(dosync (ref-set (:next scl) (new-scl x)))
				(recur @(:next scl))))))


(defmacro scl-remove [oscl x & {:keys [comp] :or {comp @*scl-comp*}} ]
	`(if (~comp @(:obj ~oscl) ~x) 
		(def ~oscl @(:next ~oscl))
		(loop [scl# ~oscl]
		    (when (not (nil? @(:next scl#)))
			(if (~comp @(:obj @(:next scl#)) ~x)
				(dosync (ref-set (:next scl#) @(:next @(:next scl#))))
				(recur @(:next scl#)))))
		))

(defn scl-contains? [oscl x & {:keys [comp] :or {comp @*scl-comp*}}]
	(loop [scl oscl]
	    (if (nil? scl)
		false
		(if (comp @(:obj scl) x)
			true
			(recur @(:next scl))))))
			
(defn scl-count [oscl]
	(loop [scl oscl i 0]
		(if (not (nil? scl))
			(recur @(:next scl) (+ i 1))
			i)))

(defn scl-nth [oscl n]
	(loop [scl oscl i 0]
		(if (or (nil? scl) (= i n)) 
			(if (nil? scl) nil @(:obj scl))
			(recur @(:next scl) (+ i 1)))))

(defn scl-insert [oscl x y & {:keys [comp] :or {comp @*scl-comp*}}]
	(println comp)
	(when (not (scl-contains? oscl x)) 
	    (loop [scl oscl]
		(when (not (nil? scl))
		(if (comp @(:obj scl) y)
			(let [z @(:next scl)]
				(dosync (ref-set (:next scl) (new-scl x)))
				(dosync (ref-set (:next @(:next scl)) z)))
			(recur @(:next scl)))))))

(defmacro scl-insert-at [oscl x p & {:keys [comp] :or {comp @*scl-comp*}}]
	`( do
		(when (and (not (scl-contains? ~oscl ~x)) (= ~p 0))
			(def temp# (new-scl ~x))
			(dosync (ref-set (:next temp#) ~oscl))
			(def ~oscl temp#))
	(when (and (> ~p 0) (<= ~p (scl-count ~oscl))) 
		(scl-insert ~oscl ~x (scl-nth ~oscl (- ~p 1))))))
