/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.common;

import java.util.Map;

public class BootstrapCleanerStaticConfig {
    private final Map<String, RetentionStaticConfig> retentionOverride;
    private final RetentionStaticConfig retentionDefault;
    private final Map<String, BootstrapDBType> bootstrapTypeOverride;
    private final BootstrapDBType bootstrapTypeDefault;
    private final Map<String, Boolean> enableOptimizeTable;
    private final Boolean enableOptimizeTableDefault;
    private final Map<String, Boolean> enableForceTabTableCleanup;
    private final Boolean enableForceTabTableCleanupDefault;
    private final boolean enable;
    private final DiskSpaceTriggerConfig diskSpaceTrigger;
    private final PeriodicTriggerConfig periodicTrigger;

    public Map<String, RetentionStaticConfig> getRetentionOverride() {
        return this.retentionOverride;
    }

    public RetentionStaticConfig getRetentionDefault() {
        return this.retentionDefault;
    }

    public RetentionStaticConfig getRetentionConfig(String sourceName) {
        RetentionStaticConfig c = this.retentionOverride.get(sourceName);
        if (null == c) {
            c = this.retentionDefault;
        }
        return c;
    }

    public Boolean forceTabTableCleanup(String sourceName) {
        Boolean c = this.enableForceTabTableCleanup.get(sourceName);
        if (null == c) {
            c = this.enableForceTabTableCleanupDefault;
        }
        return c;
    }

    public Map<String, Boolean> getEnableOptimizeTable() {
        return this.enableOptimizeTable;
    }

    public Boolean isOptimizeTableEnabled(String sourceName) {
        Boolean c = this.enableOptimizeTable.get(sourceName);
        if (null == c) {
            c = this.enableOptimizeTableDefault;
        }
        return c;
    }

    public Boolean getEnableOptimizeTableeDefault() {
        return this.enableOptimizeTableDefault;
    }

    public Map<String, BootstrapDBType> getBootstrapTypeOverride() {
        return this.bootstrapTypeOverride;
    }

    public BootstrapDBType getBootstrapType(String sourceName) {
        BootstrapDBType c = this.bootstrapTypeOverride.get(sourceName);
        if (null == c) {
            c = this.bootstrapTypeDefault;
        }
        return c;
    }

    public BootstrapDBType getBootstrapTypeDefault() {
        return this.bootstrapTypeDefault;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public DiskSpaceTriggerConfig getDiskSpaceTrigger() {
        return this.diskSpaceTrigger;
    }

    public PeriodicTriggerConfig getPeriodSpaceTrigger() {
        return this.periodicTrigger;
    }

    public BootstrapCleanerStaticConfig(Map<String, RetentionStaticConfig> retentionOverride, RetentionStaticConfig retentionDefault, Map<String, BootstrapDBType> bootstrapTypeOverride, BootstrapDBType bootstrapTypeDefault, Map<String, Boolean> enableOptimizeTable, boolean enableOptimizeTableDefault, Map<String, Boolean> enableForceTabTableCleanup, boolean enableForceTabTableCleanupDefault, boolean enable, DiskSpaceTriggerConfig diskSpaceTrigger, PeriodicTriggerConfig periodicTrigger) {
        this.retentionOverride = retentionOverride;
        this.retentionDefault = retentionDefault;
        this.bootstrapTypeOverride = bootstrapTypeOverride;
        this.bootstrapTypeDefault = bootstrapTypeDefault;
        this.enableOptimizeTable = enableOptimizeTable;
        this.enableOptimizeTableDefault = enableOptimizeTableDefault;
        this.enableForceTabTableCleanup = enableForceTabTableCleanup;
        this.enableForceTabTableCleanupDefault = enableForceTabTableCleanupDefault;
        this.enable = enable;
        this.diskSpaceTrigger = diskSpaceTrigger;
        this.periodicTrigger = periodicTrigger;
    }

    public String toString() {
        return "BootstrapCleanerStaticConfig [retentionOverride=" + this.retentionOverride + ", retentionDefault=" + this.retentionDefault + ", bootstrapTypeOverride=" + this.bootstrapTypeOverride + ", bootstrapTypeDefault=" + (Object)((Object)this.bootstrapTypeDefault) + ", enableOptimizeTable=" + this.enableOptimizeTable + ", enableOptimizeTableDefault=" + this.enableOptimizeTableDefault + ", enableForceTabTableCleanup=" + this.enableForceTabTableCleanup + ", enableForceTabTableCleanupDefault=" + this.enableForceTabTableCleanupDefault + ", enable=" + this.enable + ", diskSpaceTrigger=" + this.diskSpaceTrigger + ", periodicTrigger=" + this.periodicTrigger + "]";
    }

    public static class DiskSpaceTriggerConfig {
        private final boolean enable;
        private final long runIntervalSeconds;
        private final double availableThresholdPercent;
        private final String bootstrapDBDrive;

        public DiskSpaceTriggerConfig(boolean enable, long runIntervalSeconds, double availableThresholdPercent, String bootstrapDBDrive) {
            this.enable = enable;
            this.runIntervalSeconds = runIntervalSeconds;
            this.availableThresholdPercent = availableThresholdPercent;
            this.bootstrapDBDrive = bootstrapDBDrive;
        }

        public boolean isEnable() {
            return this.enable;
        }

        public long getRunIntervalSeconds() {
            return this.runIntervalSeconds;
        }

        public double getAvailableThresholdPercent() {
            return this.availableThresholdPercent;
        }

        public String getBootstrapDBDrive() {
            return this.bootstrapDBDrive;
        }

        public String toString() {
            return "DiskSpaceTriggerConfig [enable=" + this.enable + ", runIntervalSeconds=" + this.runIntervalSeconds + ", availableThresholdPercent=" + this.availableThresholdPercent + ", bootstrapDBDrive=" + this.bootstrapDBDrive + "]";
        }
    }

    public static class PeriodicTriggerConfig {
        private final long runIntervalSeconds;
        private final boolean enable;
        private final boolean runOnStart;

        public long getRunIntervalSeconds() {
            return this.runIntervalSeconds;
        }

        public boolean isEnable() {
            return this.enable;
        }

        public boolean isRunOnStart() {
            return this.runOnStart;
        }

        public String toString() {
            return "PeriodicTriggerConfig [runIntervalSeconds=" + this.runIntervalSeconds + ", enable=" + this.enable + ", runOnStart=" + this.runOnStart + "]";
        }

        public PeriodicTriggerConfig(long runIntervalSeconds, boolean enable, boolean runOnStart) {
            this.runIntervalSeconds = runIntervalSeconds;
            this.enable = enable;
            this.runOnStart = runOnStart;
        }
    }

    public static class RetentionStaticConfig {
        private final RetentionType retentiontype;
        private final long retentionQuantity;

        public RetentionStaticConfig(RetentionType retentiontype, long retentionQuantity) {
            this.retentiontype = retentiontype;
            this.retentionQuantity = retentionQuantity;
        }

        public RetentionType getRetentiontype() {
            return this.retentiontype;
        }

        public long getRetentionQuantity() {
            return this.retentionQuantity;
        }

        public String toString() {
            return "RetentionStaticConfig [retentiontype=" + (Object)((Object)this.retentiontype) + ", retentionQuantity=" + this.retentionQuantity + "]";
        }
    }

    public static enum BootstrapDBType {
        BOOTSTRAP_CATCHUP_APPLIER_RUNNING,
        BOOTSTRAP_CATCHUP_APPLIER_NOT_RUNNING,
        BOOTSTRAP_FULL;


        public boolean isApplierRunning() {
            return this != BOOTSTRAP_CATCHUP_APPLIER_NOT_RUNNING;
        }

        public boolean isCatchupMode() {
            return this != BOOTSTRAP_FULL;
        }
    }

    public static enum RetentionType {
        NO_CLEANUP,
        RETENTION_SECONDS,
        RETENTION_LOGS;

    }
}

