/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.common;

import com.linkedin.databus.bootstrap.common.BootstrapConfig;
import com.linkedin.databus.client.DatabusHttpClientImpl;
import com.linkedin.databus2.core.BackoffTimerStaticConfigBuilder;
import com.linkedin.databus2.core.container.netty.ServerContainer;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class BootstrapConfigBase {
    public static final String MODULE = BootstrapConfig.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String BOOTSTRAP_DB_PROPS_OPT_LONG_NAME = "bootstrap_db_props";
    public static final char BOOTSTRAP_DB_PROP_OPT_CHAR = 'p';
    public static final int DEFAULT_BOOTSTRAP_HTTP_PORT = 6060;
    public static final String DEFAULT_BOOTSTRAP_DB_USERNAME = "bootstrap";
    public static final String DEFAULT_BOOTSTRAP_DB_PASSWORD = "bootstrap";
    public static final String DEFAULT_BOOTSTRAP_DB_HOSTNAME = "localhost";
    public static final String DEFAULT_BOOTSTRAP_DB_NAME = "bootstrap";
    public static final long DEFAULT_BOOTSTRAP_FETCH_SIZE = 1000L;
    public static final int DEFAULT_BOOTSTRAP_LOG_SIZE = 10000;
    public static final boolean DEFAULT_BOOTSTRAP_DB_STATE_CHECK = false;
    protected String _bootstrapDBUsername = "bootstrap";
    protected String _bootstrapDBPassword = "bootstrap";
    protected String _bootstrapDBHostname = "localhost";
    protected String _bootstrapDBName = "bootstrap";
    protected long _bootstrapBatchSize = 1000L;
    protected long _bootstrapSnapshotBatchSize = 0L;
    protected long _bootstrapCatchupBatchSize = 0L;
    protected int _bootstrapLogSize = 10000;
    protected boolean _bootstrapDBStateCheck = false;
    protected DatabusHttpClientImpl.Config _client = new DatabusHttpClientImpl.Config();
    protected ServerContainer.Config _container = new ServerContainer.Config();
    protected BackoffTimerStaticConfigBuilder _retryTimer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadConfigProperties(String[] args) throws IOException {
        GnuParser cliParser = new GnuParser();
        OptionBuilder.withLongOpt((String)BOOTSTRAP_DB_PROPS_OPT_LONG_NAME);
        OptionBuilder.withDescription((String)"Bootstrap producer properties to use");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"property_file");
        Option dbOption = OptionBuilder.create((char)'p');
        Options options = new Options();
        options.addOption(dbOption);
        CommandLine cmd = null;
        try {
            cmd = cliParser.parse(options, args);
        }
        catch (ParseException pe) {
            throw new RuntimeException("BootstrapConfig: failed to parse command-line options.", pe);
        }
        Properties props = null;
        if (cmd.hasOption('p')) {
            String propFile = cmd.getOptionValue('p');
            LOG.info((Object)("Loading bootstrap DB config from properties file " + propFile));
            props = new Properties();
            FileInputStream f = new FileInputStream(propFile);
            try {
                props.load(f);
            }
            finally {
                if (null != f) {
                    f.close();
                }
            }
        } else {
            LOG.info((Object)"Using system properties for bootstrap DB config");
        }
        return props;
    }

    public BootstrapConfigBase() throws IOException {
        this.setBootstrapHttpPort(6060);
        this._client.getCheckpointPersistence().setType(DatabusHttpClientImpl.CheckpointPersistenceStaticConfig.ProviderType.FILE_SYSTEM.toString());
        this._client.getCheckpointPersistence().getFileSystem().setRootDirectory("./bootstrap-checkpoints");
        this._retryTimer = new BackoffTimerStaticConfigBuilder();
    }

    public String getBootstrapDBUsername() {
        return this._bootstrapDBUsername;
    }

    public void setBootstrapDBUsername(String dbUsername) {
        this._bootstrapDBUsername = dbUsername;
    }

    public String getBootstrapDBName() {
        return this._bootstrapDBName;
    }

    public void setBootstrapDBName(String dbName) {
        this._bootstrapDBName = dbName;
    }

    public String getBootstrapDBPassword() {
        return this._bootstrapDBPassword;
    }

    public String getBootstrapDBHostname() {
        return this._bootstrapDBHostname;
    }

    @Deprecated
    public int getBootstrapHttpPort() {
        return this._container.getHttpPort();
    }

    public long getBootstrapBatchSize() {
        return this._bootstrapBatchSize;
    }

    public long getBootstrapSnapshotBatchSize() {
        return this._bootstrapSnapshotBatchSize > 0L ? this._bootstrapSnapshotBatchSize : this._bootstrapBatchSize;
    }

    public long getBootstrapCatchupBatchSize() {
        return this._bootstrapCatchupBatchSize > 0L ? this._bootstrapCatchupBatchSize : this._bootstrapBatchSize;
    }

    public int getBootstrapLogSize() {
        return this._bootstrapLogSize;
    }

    @Deprecated
    public void setBootstrapHttpPort(int bootstrapHttpPort) {
        this.getContainer().setHttpPort(bootstrapHttpPort);
    }

    public void setBootstrapDBPassword(String bootstrapDBPassword) {
        this._bootstrapDBPassword = bootstrapDBPassword;
    }

    public void setBootstrapDBHostname(String bootstrapDBHostname) {
        this._bootstrapDBHostname = bootstrapDBHostname;
    }

    public void setBootstrapCatchupBatchSize(long bootstrapBatchSize) {
        this._bootstrapCatchupBatchSize = bootstrapBatchSize;
    }

    public void setBootstrapSnapshotBatchSize(long bootstrapBatchSize) {
        this._bootstrapSnapshotBatchSize = bootstrapBatchSize;
    }

    public void setBootstrapBatchSize(long bootstrapBatchSize) {
        this._bootstrapBatchSize = bootstrapBatchSize;
    }

    public void setBootstrapLogSize(int bootstrapLogSize) {
        this._bootstrapLogSize = bootstrapLogSize;
    }

    public void setBootstrapDBStateCheck(boolean bootstrapDBStateCheck) {
        this._bootstrapDBStateCheck = bootstrapDBStateCheck;
    }

    public boolean getBootstrapDBStateCheck() {
        return this._bootstrapDBStateCheck;
    }

    public DatabusHttpClientImpl.Config getClient() {
        return this._client;
    }

    public void setClient(DatabusHttpClientImpl.Config client) {
        this._client = client;
    }

    public ServerContainer.Config getContainer() {
        return this._container;
    }

    public void setContainer(ServerContainer.Config container) {
        this._container = container;
    }

    public BackoffTimerStaticConfigBuilder getRetryTimer() {
        return this._retryTimer;
    }

    public void setRetryTimer(BackoffTimerStaticConfigBuilder retryTimer) {
        this._retryTimer = retryTimer;
    }
}

