/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.common;

public class BootstrapDBCleanerQueryHelper {
    private static BootstrapDBCleanerQueryHelper _singletonObj = null;

    public static BootstrapDBCleanerQueryHelper getInstance() {
        if (_singletonObj == null) {
            _singletonObj = new BootstrapDBCleanerQueryHelper();
        }
        return _singletonObj;
    }

    private BootstrapDBCleanerQueryHelper() {
    }

    public String getMarkDeletedStmt() {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE bootstrap_loginfo ");
        sql.append(" set deleted = 1");
        sql.append(" where srcid = ?");
        sql.append(" and logid = ?");
        return sql.toString();
    }

    public String getCandidateLogIdsForSrcStmt() {
        StringBuilder sql = new StringBuilder();
        sql.append("select logid, minwindowscn, maxwindowscn from bootstrap_loginfo ");
        sql.append("where srcid = ?");
        sql.append(" and maxwindowscn < ? ");
        sql.append(" and deleted = 0 ");
        sql.append(" and logid < ( select max(logid) from bootstrap_loginfo where srcid = ? )");
        sql.append(" order by logid desc");
        return sql.toString();
    }

    public String getSrcTable(int srcid) {
        return "tab_" + srcid;
    }

    public String getUpdateLogStartSCNStmt() {
        StringBuilder sql = new StringBuilder();
        sql.append("update bootstrap_sources set logstartscn = ?");
        sql.append(" where id = ?");
        return sql.toString();
    }

    public String getFirstLogTableWithGreaterSCNStmt() {
        StringBuilder sql = new StringBuilder();
        sql.append("select logid, minwindowscn, maxwindowscn from bootstrap_loginfo ");
        sql.append("where srcid = ?");
        sql.append(" and minwindowscn > ? ");
        sql.append(" order by logid asc limit 1");
        return sql.toString();
    }
}

