/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.common;

import com.linkedin.databus.bootstrap.common.BootstrapHttpStatsCollectorMBean;
import com.linkedin.databus.bootstrap.monitoring.server.mbean.DbusBootstrapHttpStats;
import com.linkedin.databus.bootstrap.monitoring.server.mbean.DbusBootstrapHttpStatsMBean;
import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.monitoring.mbean.DatabusMonitoringMBean;
import com.linkedin.databus.core.util.ReadWriteSyncedObject;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class BootstrapHttpStatsCollector
extends ReadWriteSyncedObject
implements BootstrapHttpStatsCollectorMBean {
    private static final String NO_PEER = "NONE";
    public static final String MODULE = BootstrapHttpStatsCollector.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final DbusBootstrapHttpStats _totalStats;
    private final HashMap<String, DbusBootstrapHttpStats> _perClientStats;
    private final MBeanServer _mbeanServer;
    private final ObjectName _collectorObjName;
    private final int _id;
    private final String _name;
    private final String _perPeerPrefix;
    private final String _curPeer;
    private final AtomicBoolean _enabled;

    public BootstrapHttpStatsCollector(int id, String name, boolean enabled, boolean threadSafe, MBeanServer mbeanServer) {
        this(id, name, enabled, threadSafe, NO_PEER, mbeanServer);
    }

    public BootstrapHttpStatsCollector(int id, String name, boolean enabled, boolean threadSafe, String peer, MBeanServer mbeanServer) {
        super(threadSafe);
        this._mbeanServer = mbeanServer;
        this._curPeer = peer;
        this._enabled = new AtomicBoolean(enabled);
        this._id = id;
        this._name = name;
        this._perPeerPrefix = this._name + ".peer.";
        this._totalStats = new DbusBootstrapHttpStats(this._id, this._name + ".total", enabled, threadSafe, null);
        this._perClientStats = new HashMap(1000);
        ObjectName jmxName = null;
        try {
            Hashtable<String, String> mbeanProps = new Hashtable<String, String>(5);
            mbeanProps.put("name", this._name);
            mbeanProps.put("type", BootstrapHttpStatsCollector.class.getSimpleName());
            mbeanProps.put("bootstrap", Integer.toString(id));
            jmxName = new ObjectName("com.linkedin.databus2", mbeanProps);
        }
        catch (Exception e) {
            LOG.error((Object)"Error creating JMX object name", (Throwable)e);
        }
        this._collectorObjName = jmxName;
        this.registerAsMBeans();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DbusBootstrapHttpStats getOrAddPerPeerCollector(String client, Lock writeLock) {
        Lock myWriteLock = null;
        if (null == writeLock) {
            myWriteLock = this.acquireWriteLock();
        }
        try {
            DbusBootstrapHttpStats clientStats = this._perClientStats.get(client);
            if (null == clientStats) {
                clientStats = new DbusBootstrapHttpStats(this._id, this._perPeerPrefix + client, true, this.isThreadSafe(), null);
                this._perClientStats.put(client, clientStats);
                if (null != this._mbeanServer) {
                    clientStats.registerAsMbean(this._mbeanServer);
                }
            }
            DbusBootstrapHttpStats dbusBootstrapHttpStats = clientStats;
            return dbusBootstrapHttpStats;
        }
        finally {
            this.releaseLock(myWriteLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(BootstrapHttpStatsCollector other) {
        this._totalStats.mergeStats((DatabusMonitoringMBean)other._totalStats);
        Lock otherReadLock = other.acquireReadLock();
        Lock writeLock = this.acquireWriteLock(otherReadLock);
        try {
            for (String peerName : other._perClientStats.keySet()) {
                DbusBootstrapHttpStats bean = other._perClientStats.get(peerName);
                this.mergePerPeer(peerName, bean, writeLock);
            }
        }
        finally {
            this.releaseLock(writeLock);
            this.releaseLock(otherReadLock);
        }
    }

    private void mergePerPeer(String peer, DbusBootstrapHttpStats other, Lock writeLock) {
        DbusBootstrapHttpStats curBean = this.getOrAddPerPeerCollector(peer, writeLock);
        curBean.mergeStats((DatabusMonitoringMBean)other);
    }

    protected void registerAsMBeans() {
        if (null != this._mbeanServer && null != this._collectorObjName) {
            try {
                if (this._mbeanServer.isRegistered(this._collectorObjName)) {
                    LOG.warn((Object)("unregistering stale mbean: " + this._collectorObjName));
                    this._mbeanServer.unregisterMBean(this._collectorObjName);
                }
                this._totalStats.registerAsMbean(this._mbeanServer);
                this._mbeanServer.registerMBean(this, this._collectorObjName);
                LOG.info((Object)("MBean registered " + this._collectorObjName));
            }
            catch (Exception e) {
                LOG.error((Object)"JMX registration failed", (Throwable)e);
            }
        }
    }

    public void unregisterMBeans() {
        if (null != this._mbeanServer && null != this._collectorObjName) {
            try {
                this._mbeanServer.unregisterMBean(this._collectorObjName);
                this._totalStats.unregisterMbean(this._mbeanServer);
                for (String clientName : this._perClientStats.keySet()) {
                    this._perClientStats.get(clientName).unregisterMbean(this._mbeanServer);
                }
                LOG.info((Object)("MBean unregistered " + this._collectorObjName));
            }
            catch (Exception e) {
                LOG.error((Object)"JMX deregistration failed", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this._totalStats.reset();
        Lock readLock = this.acquireReadLock();
        try {
            for (String peer : this._perClientStats.keySet()) {
                this._perClientStats.get(peer).reset();
            }
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    @Override
    public boolean isEnabled() {
        return this._enabled.get();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._enabled.set(enabled);
    }

    @Override
    public DbusBootstrapHttpStatsMBean getTotalStats() {
        return this._totalStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbusBootstrapHttpStatsMBean getPeerStats(String peer) {
        Lock readLock = this.acquireReadLock();
        try {
            DbusBootstrapHttpStats result;
            DbusBootstrapHttpStats dbusBootstrapHttpStats = result = this._perClientStats.get(peer);
            return dbusBootstrapHttpStats;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    @Override
    public void registerBootStrapReq(Checkpoint cp, long latency, long size) {
        this._totalStats.registerBootStrapReq(cp, latency, size);
    }

    @Override
    public void registerStartSCNReq(long latency) {
        this._totalStats.registerStartSCNReq(latency);
    }

    @Override
    public void registerTargetSCNReq(long latency) {
        this._totalStats.registerTargetSCNReq(latency);
    }

    @Override
    public void registerErrBootstrap() {
        this._totalStats.registerErrBootstrap();
    }

    @Override
    public void registerErrStartSCN() {
        this._totalStats.registerErrStartSCN();
    }

    @Override
    public void registerErrTargetSCN() {
        this._totalStats.registerErrTargetSCN();
    }

    @Override
    public void registerErrSqlException() {
        this._totalStats.registerErrSqlException();
    }

    @Override
    public void registerErrDatabaseTooOld() {
        this._totalStats.registerErrDatabaseTooOld();
    }
}

