/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.common;

import com.linkedin.databus.bootstrap.common.BootstrapHttpStatsCollector;
import com.linkedin.databus.bootstrap.common.BootstrapProducerStatsCollectorMBean;
import com.linkedin.databus.bootstrap.monitoring.producer.mbean.DbusBootstrapProducerStats;
import com.linkedin.databus.bootstrap.monitoring.producer.mbean.DbusBootstrapProducerStatsMBean;
import com.linkedin.databus.core.monitoring.mbean.DatabusMonitoringMBean;
import com.linkedin.databus.core.monitoring.mbean.StatsCollectorMergeable;
import com.linkedin.databus.core.util.ReadWriteSyncedObject;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class BootstrapProducerStatsCollector
extends ReadWriteSyncedObject
implements BootstrapProducerStatsCollectorMBean,
StatsCollectorMergeable<BootstrapProducerStatsCollector> {
    private static final String NO_SOURCE = "NONE";
    public static final String MODULE = BootstrapProducerStatsCollector.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final DbusBootstrapProducerStats _totalStats;
    private final HashMap<String, DbusBootstrapProducerStats> _perClientStats;
    private final MBeanServer _mbeanServer;
    private final ObjectName _collectorObjName;
    private final int _id;
    private final String _name;
    private final String _perSourcePrefix;
    private final String _curSource;
    private final AtomicBoolean _enabled;
    private final List<String> _logicalSources;

    public BootstrapProducerStatsCollector(int id, String name, boolean enabled, boolean threadSafe, MBeanServer mbeanServer, List<String> logicalSources) {
        this(id, name, enabled, threadSafe, NO_SOURCE, mbeanServer, logicalSources);
    }

    public BootstrapProducerStatsCollector(int id, String name, boolean enabled, boolean threadSafe, String source, MBeanServer mbeanServer, List<String> logicalSources) {
        super(threadSafe);
        this._mbeanServer = mbeanServer;
        this._curSource = source;
        this._enabled = new AtomicBoolean(enabled);
        this._id = id;
        this._name = name;
        this._perSourcePrefix = this._name + ".source.";
        this._logicalSources = logicalSources;
        this._totalStats = new DbusBootstrapProducerStats(this._id, this._name + ".total", enabled, threadSafe, null);
        this._perClientStats = new HashMap(1000);
        ObjectName jmxName = null;
        try {
            Hashtable<String, String> mbeanProps = new Hashtable<String, String>(5);
            mbeanProps.put("name", this._name);
            mbeanProps.put("type", BootstrapHttpStatsCollector.class.getSimpleName());
            mbeanProps.put("bootstrap", Integer.toString(id));
            jmxName = new ObjectName("com.linkedin.databus2", mbeanProps);
        }
        catch (Exception e) {
            LOG.error((Object)"Error creating JMX object name", (Throwable)e);
        }
        this._collectorObjName = jmxName;
        this.registerAsMBeans();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this._totalStats.reset();
        Lock readLock = this.acquireReadLock();
        try {
            for (String source : this._perClientStats.keySet()) {
                this._perClientStats.get(source).reset();
            }
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    @Override
    public boolean isEnabled() {
        return this._enabled.get();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._enabled.set(enabled);
    }

    @Override
    public DbusBootstrapProducerStatsMBean getTotalStats() {
        return this._totalStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbusBootstrapProducerStatsMBean getSourceStats(String source) {
        Lock writeLock = this.acquireWriteLock();
        try {
            DbusBootstrapProducerStats result;
            DbusBootstrapProducerStats dbusBootstrapProducerStats = result = this.getOrAddPerSourceCollector(source, writeLock);
            return dbusBootstrapProducerStats;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    @Override
    public void registerFellOffRelay() {
        this._totalStats.registerFellOffRelay();
    }

    @Override
    public void registerSQLException() {
        this._totalStats.registerSQLException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerBatch(String source, long latency, long numEvents, long currentSCN, long currentLogId, long currentRowId) {
        Lock writeLock = this.acquireWriteLock();
        try {
            DbusBootstrapProducerStats srcStats = this.getOrAddPerSourceCollector(source, writeLock);
            srcStats.registerBatch(latency, numEvents, currentSCN, currentLogId, currentRowId);
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    @Override
    public void registerEndWindow(long latency, long numEvents, long currentSCN) {
        this._totalStats.registerBatch(latency, numEvents, currentSCN, 0L, 0L);
    }

    protected void registerAsMBeans() {
        if (null != this._mbeanServer && null != this._collectorObjName) {
            try {
                if (this._mbeanServer.isRegistered(this._collectorObjName)) {
                    LOG.warn((Object)("unregistering stale mbean: " + this._collectorObjName));
                    this._mbeanServer.unregisterMBean(this._collectorObjName);
                }
                this._totalStats.registerAsMbean(this._mbeanServer);
                this._mbeanServer.registerMBean(this, this._collectorObjName);
                LOG.info((Object)("MBean registered " + this._collectorObjName));
            }
            catch (Exception e) {
                LOG.error((Object)"JMX registration failed", (Throwable)e);
            }
        }
    }

    public void unregisterMBeans() {
        if (null != this._mbeanServer && null != this._collectorObjName) {
            try {
                this._mbeanServer.unregisterMBean(this._collectorObjName);
                this._totalStats.unregisterMbean(this._mbeanServer);
                for (String clientName : this._perClientStats.keySet()) {
                    this._perClientStats.get(clientName).unregisterMbean(this._mbeanServer);
                }
                LOG.info((Object)("MBean unregistered " + this._collectorObjName));
            }
            catch (Exception e) {
                LOG.error((Object)"JMX deregistration failed", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(BootstrapProducerStatsCollector other) {
        this._totalStats.mergeStats((DatabusMonitoringMBean)other._totalStats);
        Lock otherReadLock = other.acquireReadLock();
        Lock writeLock = this.acquireWriteLock(otherReadLock);
        try {
            for (String sourceName : other._perClientStats.keySet()) {
                DbusBootstrapProducerStats bean = other._perClientStats.get(sourceName);
                this.mergePerSource(sourceName, bean, writeLock);
            }
        }
        finally {
            this.releaseLock(writeLock);
            this.releaseLock(otherReadLock);
        }
    }

    private void mergePerSource(String source, DbusBootstrapProducerStats other, Lock writeLock) {
        DbusBootstrapProducerStats curBean = this.getOrAddPerSourceCollector(source, writeLock);
        curBean.mergeStats((DatabusMonitoringMBean)other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DbusBootstrapProducerStats getOrAddPerSourceCollector(String client, Lock writeLock) {
        Lock myWriteLock = null;
        if (null == writeLock) {
            myWriteLock = this.acquireWriteLock();
        }
        try {
            DbusBootstrapProducerStats clientStats = this._perClientStats.get(client);
            if (null == clientStats) {
                clientStats = new DbusBootstrapProducerStats(this._id, this._perSourcePrefix + client, true, this.isThreadSafe(), null);
                this._perClientStats.put(client, clientStats);
                if (null != this._mbeanServer) {
                    clientStats.registerAsMbean(this._mbeanServer);
                }
            }
            DbusBootstrapProducerStats dbusBootstrapProducerStats = clientStats;
            return dbusBootstrapProducerStats;
        }
        finally {
            this.releaseLock(myWriteLock);
        }
    }

    public List<String> getLogicalSources() {
        return this._logicalSources;
    }

    public String getPhysicalSourceName() {
        return this._name;
    }

    public void resetAndMerge(List<BootstrapProducerStatsCollector> objList) {
    }
}

