/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.common;

import com.linkedin.databus2.util.DBHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SourceInfo {
    public static final String MODULE = SourceInfo.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private int _srcid;
    private int _currlogid;
    private int _maxRowId;
    private long _minwindowscn;
    private long _maxwindowscn;
    private int _status;

    public SourceInfo(int srcid, int currlogid, int maxRowId, long minwindowscn, long maxwindowscn, int status) {
        this._srcid = srcid;
        this._currlogid = currlogid;
        this._maxRowId = maxRowId;
        this._minwindowscn = minwindowscn;
        this._maxwindowscn = maxwindowscn;
        this._status = status;
    }

    public int getStatus() {
        return this._status;
    }

    public int getSrcId() {
        return this._srcid;
    }

    public int getCurrLogId() {
        return this._currlogid;
    }

    public int getNumRows() {
        return this._maxRowId;
    }

    public long getMinWindowScn() {
        return this._minwindowscn;
    }

    public long getMaxWindowScn() {
        return this._maxwindowscn;
    }

    public void setStatus(int status) {
        this._status = status;
    }

    public void setMaxRowId(int maxRowId) {
        this._maxRowId = maxRowId;
    }

    public void setWindowScn(long windowscn) {
        if (this._minwindowscn == -1L) {
            this._minwindowscn = windowscn;
        }
        this._maxwindowscn = windowscn;
    }

    public void saveToDB(Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("update bootstrap_loginfo set minwindowscn = ? , maxwindowscn = ? , maxrid = ? where srcid = ? and logid = ?");
            stmt.setLong(1, this._minwindowscn);
            stmt.setLong(2, this._maxwindowscn);
            stmt.setInt(3, this._maxRowId);
            stmt.setInt(4, this._srcid);
            stmt.setInt(5, this._currlogid);
            stmt.executeUpdate();
            conn.commit();
        }
        catch (SQLException e) {
            LOG.error((Object)("Error occurred when saving source info to database" + e));
            throw e;
        }
        finally {
            DBHelper.close((Statement)stmt);
        }
    }

    public void switchLogFile(Connection conn) throws SQLException {
        ++this._currlogid;
        this._maxRowId = 0;
        this._minwindowscn = -1L;
        this._maxwindowscn = -1L;
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("insert into bootstrap_loginfo(srcid, logid) values(?,?)");
            stmt.setInt(1, this._srcid);
            stmt.setInt(2, this._currlogid);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            LOG.error((Object)("Error occurred when saving source info to database" + e));
            throw e;
        }
        finally {
            DBHelper.close((Statement)stmt);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("srcid=" + this._srcid);
        sb.append("; logid=" + this._currlogid);
        sb.append("; maxRowId=" + this._maxRowId);
        sb.append("; minwindowscn=" + this._minwindowscn);
        sb.append("; maxwindowscn=" + this._maxwindowscn);
        sb.append("; status=" + this._status);
        return sb.toString();
    }
}

