/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.monitoring.producer.mbean;

import com.linkedin.databus.bootstrap.monitoring.producer.events.DbusBootstrapProducerStatsEvent;
import com.linkedin.databus.bootstrap.monitoring.producer.mbean.DbusBootstrapProducerStatsMBean;
import com.linkedin.databus.core.monitoring.mbean.AbstractMonitoringMBean;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.concurrent.locks.Lock;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificDatumWriter;

public class DbusBootstrapProducerStats
extends AbstractMonitoringMBean<DbusBootstrapProducerStatsEvent>
implements DbusBootstrapProducerStatsMBean {
    public DbusBootstrapProducerStats(int id, String dimension, boolean enabled, boolean threadSafe, DbusBootstrapProducerStatsEvent initData) {
        super(enabled, threadSafe, (Object)initData);
        ((DbusBootstrapProducerStatsEvent)((Object)this._event)).ownerId = id;
        ((DbusBootstrapProducerStatsEvent)((Object)this._event)).dimension = dimension;
        this.reset();
    }

    protected void resetData() {
        ((DbusBootstrapProducerStatsEvent)((Object)this._event)).currentLogId = 0L;
        ((DbusBootstrapProducerStatsEvent)((Object)this._event)).currentRowId = 0L;
        ((DbusBootstrapProducerStatsEvent)((Object)this._event)).currentSCN = 0L;
        ((DbusBootstrapProducerStatsEvent)((Object)this._event)).numDataEventsPerWindow = 0L;
        ((DbusBootstrapProducerStatsEvent)((Object)this._event)).numErrFellOffRelay = 0L;
        ((DbusBootstrapProducerStatsEvent)((Object)this._event)).numErrSqlException = 0L;
        ((DbusBootstrapProducerStatsEvent)((Object)this._event)).timestampLastResetMs = System.currentTimeMillis();
        ((DbusBootstrapProducerStatsEvent)((Object)this._event)).timeSinceLastResetMs = 0L;
        ((DbusBootstrapProducerStatsEvent)((Object)this._event)).latencyPerWindow = 0L;
        ((DbusBootstrapProducerStatsEvent)((Object)this._event)).numWindows = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumErrFellOffRelay() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapProducerStatsEvent)((Object)this._event)).numErrFellOffRelay;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumErrSqlException() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapProducerStatsEvent)((Object)this._event)).numErrSqlException;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLatencyPerWindow() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapProducerStatsEvent)((Object)this._event)).latencyPerWindow;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumDataEventsPerWindow() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapProducerStatsEvent)((Object)this._event)).numDataEventsPerWindow;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumWindows() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapProducerStatsEvent)((Object)this._event)).numWindows;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCurrentSCN() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapProducerStatsEvent)((Object)this._event)).currentSCN;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCurrentLogId() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapProducerStatsEvent)((Object)this._event)).currentLogId;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCurrentRowId() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapProducerStatsEvent)((Object)this._event)).currentRowId;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimestampLastResetMs() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapProducerStatsEvent)((Object)this._event)).timestampLastResetMs;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeSinceLastResetMs() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapProducerStatsEvent)((Object)this._event)).timeSinceLastResetMs;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    public JsonEncoder createJsonEncoder(OutputStream out) throws IOException {
        return new JsonEncoder(((DbusBootstrapProducerStatsEvent)((Object)this._event)).getSchema(), out);
    }

    public ObjectName generateObjectName() throws MalformedObjectNameException {
        Hashtable mbeanProps = this.generateBaseMBeanProps();
        mbeanProps.put("ownerId", Integer.toString(((DbusBootstrapProducerStatsEvent)((Object)this._event)).ownerId));
        mbeanProps.put("dimension", ((Object)((DbusBootstrapProducerStatsEvent)((Object)this._event)).dimension).toString());
        return new ObjectName("com.linkedin.databus2", mbeanProps);
    }

    protected void cloneData(DbusBootstrapProducerStatsEvent eventObj) {
        eventObj.currentLogId = ((DbusBootstrapProducerStatsEvent)((Object)this._event)).currentLogId;
        eventObj.currentRowId = ((DbusBootstrapProducerStatsEvent)((Object)this._event)).currentRowId;
        eventObj.currentSCN = ((DbusBootstrapProducerStatsEvent)((Object)this._event)).currentSCN;
        eventObj.numDataEventsPerWindow = ((DbusBootstrapProducerStatsEvent)((Object)this._event)).numDataEventsPerWindow;
        eventObj.numErrFellOffRelay = ((DbusBootstrapProducerStatsEvent)((Object)this._event)).numErrFellOffRelay;
        eventObj.numErrSqlException = ((DbusBootstrapProducerStatsEvent)((Object)this._event)).numErrSqlException;
        eventObj.timestampLastResetMs = ((DbusBootstrapProducerStatsEvent)((Object)this._event)).timestampLastResetMs;
        eventObj.timeSinceLastResetMs = ((DbusBootstrapProducerStatsEvent)((Object)this._event)).timeSinceLastResetMs;
        eventObj.latencyPerWindow = ((DbusBootstrapProducerStatsEvent)((Object)this._event)).latencyPerWindow;
        eventObj.numWindows = ((DbusBootstrapProducerStatsEvent)((Object)this._event)).numWindows;
    }

    protected DbusBootstrapProducerStatsEvent newDataEvent() {
        return new DbusBootstrapProducerStatsEvent();
    }

    protected SpecificDatumWriter<DbusBootstrapProducerStatsEvent> getAvroWriter() {
        return new SpecificDatumWriter(DbusBootstrapProducerStatsEvent.class);
    }

    protected void doMergeStats(Object eventData) {
        if (!(eventData instanceof DbusBootstrapProducerStatsEvent)) {
            LOG.warn((Object)("Attempt to merge unknown event class" + eventData.getClass().getName()));
            return;
        }
        DbusBootstrapProducerStatsEvent e = (DbusBootstrapProducerStatsEvent)((Object)eventData);
        if (((DbusBootstrapProducerStatsEvent)((Object)this._event)).ownerId > 0 && e.ownerId != ((DbusBootstrapProducerStatsEvent)((Object)this._event)).ownerId) {
            LOG.warn((Object)("Attempt to data for a different relay " + e.ownerId));
            return;
        }
        if (e.currentLogId > ((DbusBootstrapProducerStatsEvent)((Object)this._event)).currentLogId || e.currentLogId == ((DbusBootstrapProducerStatsEvent)((Object)this._event)).currentLogId && e.currentRowId > ((DbusBootstrapProducerStatsEvent)((Object)this._event)).currentRowId) {
            ((DbusBootstrapProducerStatsEvent)((Object)this._event)).currentLogId = e.currentLogId;
            ((DbusBootstrapProducerStatsEvent)((Object)this._event)).currentRowId = e.currentRowId;
        }
        ((DbusBootstrapProducerStatsEvent)((Object)this._event)).currentSCN = Math.max(((DbusBootstrapProducerStatsEvent)((Object)this._event)).currentSCN, e.currentSCN);
        ((DbusBootstrapProducerStatsEvent)((Object)this._event)).numDataEventsPerWindow += e.numDataEventsPerWindow;
        ((DbusBootstrapProducerStatsEvent)((Object)this._event)).numErrFellOffRelay += e.numErrFellOffRelay;
        ((DbusBootstrapProducerStatsEvent)((Object)this._event)).numErrSqlException += e.numErrSqlException;
        ((DbusBootstrapProducerStatsEvent)((Object)this._event)).latencyPerWindow += e.latencyPerWindow;
        ((DbusBootstrapProducerStatsEvent)((Object)this._event)).numWindows += e.numWindows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFellOffRelay() {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((DbusBootstrapProducerStatsEvent)((Object)this._event)).numErrFellOffRelay;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSQLException() {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((DbusBootstrapProducerStatsEvent)((Object)this._event)).numErrSqlException;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerBatch(long latency, long numEvents, long currentSCN, long currentLogId, long currentRowId) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((DbusBootstrapProducerStatsEvent)((Object)this._event)).numWindows;
            ((DbusBootstrapProducerStatsEvent)((Object)this._event)).latencyPerWindow += latency;
            ((DbusBootstrapProducerStatsEvent)((Object)this._event)).currentLogId = currentLogId;
            ((DbusBootstrapProducerStatsEvent)((Object)this._event)).currentRowId = currentRowId;
            ((DbusBootstrapProducerStatsEvent)((Object)this._event)).currentSCN = currentSCN;
            ((DbusBootstrapProducerStatsEvent)((Object)this._event)).numDataEventsPerWindow += numEvents;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }
}

