/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.producer;

import com.linkedin.databus.bootstrap.producer.BootstrapApplierThread;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class ProducerNotification {
    public static final String MODULE = ProducerNotification.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private boolean _waiting = false;

    public synchronized void startWaiting(BootstrapApplierThread.sourcePositions pos) throws InterruptedException, SQLException {
        this._waiting = true;
        pos.refresh();
        LOG.info((Object)"Entering wait for more events from DatabusBootstrapProducer");
        while (this._waiting) {
            this.wait();
        }
        LOG.info((Object)"Leaving wait to apply more events from DatabusBootstrapProducer");
        this._waiting = false;
    }

    public synchronized void stopWaiting() {
        if (this._waiting) {
            this.notifyAll();
            LOG.info((Object)"Notified applier to exit wait state");
        }
    }
}

