/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.server;

import com.linkedin.databus.bootstrap.common.BootstrapHttpStatsCollector;
import com.linkedin.databus.bootstrap.server.BootstrapRequestProcessor;
import com.linkedin.databus.bootstrap.server.BootstrapServerConfig;
import com.linkedin.databus.bootstrap.server.BootstrapServerStaticConfig;
import com.linkedin.databus.bootstrap.server.StartSCNRequestProcessor;
import com.linkedin.databus.bootstrap.server.TargetSCNRequestProcessor;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.ConfigLoader;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.container.monitoring.mbean.DatabusComponentAdmin;
import com.linkedin.databus2.core.container.netty.ServerContainer;
import com.linkedin.databus2.core.container.request.ConfigRequestProcessor;
import com.linkedin.databus2.core.container.request.ContainerOperationProcessor;
import com.linkedin.databus2.core.container.request.RequestProcessor;
import com.linkedin.databus2.core.container.request.RequestProcessorRegistry;
import java.io.IOException;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class BootstrapHttpServer
extends ServerContainer {
    public static final String MODULE = BootstrapHttpServer.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final BootstrapServerStaticConfig _bootstrapServerConfig;
    private final BootstrapHttpStatsCollector _bootstrapHttpStatsCollector;

    public BootstrapHttpServer(BootstrapServerConfig config) throws IOException, InvalidConfigException, DatabusException {
        this(config.build());
    }

    public BootstrapHttpServer(BootstrapServerStaticConfig bootstrapServerConfig, ByteOrder byteOrder) throws IOException, InvalidConfigException, DatabusException {
        super(bootstrapServerConfig.getDb().getContainer(), byteOrder);
        this._bootstrapServerConfig = bootstrapServerConfig;
        BootstrapHttpStatsCollector httpStatsColl = null;
        if (null == httpStatsColl) {
            httpStatsColl = new BootstrapHttpStatsCollector(this.getContainerStaticConfig().getId(), "bootstrapHttpOutbound", true, true, this.getMbeanServer());
        }
        this._bootstrapHttpStatsCollector = httpStatsColl;
        this.initializeBootstrapServerCommandProcessors();
    }

    public BootstrapHttpServer(BootstrapServerStaticConfig bootstrapServerConfig) throws DatabusException, IOException {
        this(bootstrapServerConfig, ByteOrder.BIG_ENDIAN);
    }

    public BootstrapHttpStatsCollector getBootstrapStatsCollector() {
        return this._bootstrapHttpStatsCollector;
    }

    protected DatabusComponentAdmin createComponentAdmin() {
        return new DatabusComponentAdmin((ServerContainer)this, this.getMbeanServer(), BootstrapHttpServer.class.getSimpleName());
    }

    public static void main(String[] args) throws Exception {
        Properties startupProps = ServerContainer.processCommandLineArgs((String[])args);
        BootstrapServerConfig config = new BootstrapServerConfig();
        ConfigLoader configLoader = new ConfigLoader("databus.bootstrap.", (ConfigBuilder)config);
        BootstrapServerStaticConfig staticConfig = (BootstrapServerStaticConfig)configLoader.loadConfig((Map)startupProps);
        BootstrapHttpServer bootstrapServer = new BootstrapHttpServer(staticConfig);
        try {
            bootstrapServer.registerShutdownHook();
            bootstrapServer.startAndBlock();
        }
        catch (Exception e) {
            LOG.error((Object)"Error starting the bootstrap server", (Throwable)e);
        }
        LOG.info((Object)"Exiting bootstrap server");
    }

    public void pause() {
        this.getComponentStatus().pause();
    }

    public void resume() {
        this.getComponentStatus().resume();
    }

    public void suspendOnError(Throwable cause) {
        this.getComponentStatus().suspendOnError(cause);
    }

    protected void initializeBootstrapServerCommandProcessors() throws DatabusException {
        LOG.info((Object)"Initializing Bootstrap HTTP Server");
        LOG.info((Object)("Config=" + this._bootstrapServerConfig));
        try {
            RequestProcessorRegistry processorRegistry = this.getProcessorRegistry();
            processorRegistry.register("config", (RequestProcessor)new ConfigRequestProcessor(null, (ServerContainer)this));
            processorRegistry.register("bootstrap", (RequestProcessor)new BootstrapRequestProcessor(null, this._bootstrapServerConfig, this));
            processorRegistry.register("startSCN", (RequestProcessor)new StartSCNRequestProcessor(null, this._bootstrapServerConfig, this));
            processorRegistry.register("targetSCN", (RequestProcessor)new TargetSCNRequestProcessor(null, this._bootstrapServerConfig, this));
            processorRegistry.register("operation", (RequestProcessor)new ContainerOperationProcessor(null, (ServerContainer)this));
        }
        catch (SQLException sqle) {
            throw new DatabusException("command registration failed", (Throwable)sqle);
        }
        catch (InstantiationException e) {
            throw new DatabusException("command registration failed", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new DatabusException("command registration failed", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new DatabusException("command registration failed", (Throwable)e);
        }
        LOG.info((Object)"Done Initializing Bootstrap HTTP Server");
    }
}

