/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.server;

import com.linkedin.databus.bootstrap.server.BootstrapHttpServer;
import com.linkedin.databus.bootstrap.server.BootstrapServerStaticConfig;
import com.linkedin.databus.client.pub.ServerInfo;
import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import com.linkedin.databus2.core.container.request.RequestProcessor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;

public abstract class BootstrapRequestProcessorBase
implements RequestProcessor {
    public static final String MODULE = BootstrapRequestProcessorBase.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String CHECKPOINT_PARAM = "checkPoint";
    private boolean _isServerInfoInitialized;
    protected String _serverHostPort;
    protected ServerInfo _serverInfo;
    protected final ExecutorService _executorService;
    protected final BootstrapServerStaticConfig _config;
    protected final BootstrapHttpServer _bootstrapServer;

    public BootstrapRequestProcessorBase(ExecutorService executorService, BootstrapServerStaticConfig config, BootstrapHttpServer bootstrapServer) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        this._config = config;
        this._executorService = executorService;
        this._bootstrapServer = bootstrapServer;
        this._isServerInfoInitialized = false;
    }

    public final DatabusRequest process(DatabusRequest request) throws IOException, RequestProcessingException {
        String bsServerInfo;
        this.initBootstrapServerInfo();
        String ckptStr = request.getParams().getProperty(CHECKPOINT_PARAM);
        Checkpoint ckpt = null;
        if (null != ckptStr && null != (bsServerInfo = (ckpt = new Checkpoint(ckptStr)).getBootstrapServerInfo()) && null != this._serverInfo) {
            ServerInfo expServerInfo = null;
            try {
                expServerInfo = ServerInfo.buildServerInfoFromHostPort((String)bsServerInfo.trim(), (String)":");
            }
            catch (Exception ex) {
                LOG.error((Object)("Unable to fetch ServerInfo from ckpt. Passed ServerInfo was :" + bsServerInfo.trim()));
            }
            if (null != expServerInfo && !this._serverInfo.equals((Object)expServerInfo)) {
                String msg = "Bootstrap Server Request should be served by different host : " + bsServerInfo + ", This instance is :" + this._serverHostPort;
                LOG.error((Object)msg);
                throw new RequestProcessingException(msg);
            }
        }
        DatabusRequest req = this.doProcess(request);
        if (null != this._serverHostPort) {
            req.getResponseContent().setMetadata("X-DBUS2-BS-HOSTPORT", (Object)this._serverHostPort);
        }
        return req;
    }

    protected abstract DatabusRequest doProcess(DatabusRequest var1) throws IOException, RequestProcessingException;

    public ExecutorService getExecutorService() {
        return this._executorService;
    }

    private void initBootstrapServerInfo() {
        if (!this._isServerInfoInitialized) {
            String host = null;
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                LOG.error((Object)"Unable to fetch the local hostname !! Trying to fetch IP Address !!", (Throwable)e);
                try {
                    host = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e1) {
                    LOG.error((Object)"Unable to fetch the local IP Address too !! Giving up", (Throwable)e1);
                    host = null;
                }
            }
            if (null != host) {
                int port = this._bootstrapServer.getHttpPort();
                this._serverHostPort = host + ":" + port;
                ServerInfo serverInfo = null;
                try {
                    serverInfo = ServerInfo.buildServerInfoFromHostPort((String)this._serverHostPort, (String)":");
                }
                catch (Exception e) {
                    LOG.error((Object)("Unable to build serverInfo from string (" + this._serverHostPort + ")"), (Throwable)e);
                }
                this._serverInfo = serverInfo;
            } else {
                this._serverHostPort = null;
                this._serverInfo = null;
                LOG.error((Object)"Unable to fetch local address !! Clients connecting to this bootstrap server will restart bootstrap on failures !!");
            }
            this._isServerInfoInitialized = true;
        }
    }
}

