/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.server;

import com.linkedin.databus.bootstrap.api.BootstrapProcessingException;
import com.linkedin.databus.bootstrap.common.BootstrapConn;
import com.linkedin.databus.bootstrap.common.BootstrapDBMetaDataDAO;
import com.linkedin.databus.bootstrap.common.BootstrapDBTimedQuery;
import com.linkedin.databus.bootstrap.server.BootstrapServerStaticConfig;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.container.request.BootstrapDatabaseTooOldException;
import com.linkedin.databus2.util.DBHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class BootstrapSCNProcessor {
    public static final String MODULE = BootstrapSCNProcessor.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final long START_SCN_QUERY_WAIT_TIME = 60000L;
    public static final long QUERY_WAIT_TIME_SLICE = 100L;
    private BootstrapDBMetaDataDAO _dbDao;
    private BootstrapServerStaticConfig _config;
    public static final String START_SCN_STMT_SQL_PREFIX = "SELECT min(windowscn) from bootstrap_applier_state where srcid IN (";
    public static final String START_SCN_STMT_SQL_SUFFIX = ")";
    public static final String PRODUCER_SCN_STMT_SQL_PREFIX = "SELECT max(windowscn) from bootstrap_producer_state where srcid IN (";
    public static final String PRODUCER_SCN_STMT_SQL_SUFFIX = ")";

    public BootstrapSCNProcessor(BootstrapServerStaticConfig config, DbusEventsStatisticsCollector curStatsCollector) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, DatabusException {
        this._config = config;
        BootstrapConn conn = new BootstrapConn();
        boolean autoCommit = true;
        conn.initBootstrapConn(true, config.getDb().getBootstrapDBUsername(), config.getDb().getBootstrapDBPassword(), config.getDb().getBootstrapDBHostname(), config.getDb().getBootstrapDBName());
        this._dbDao = new BootstrapDBMetaDataDAO(conn, config.getDb().getBootstrapDBHostname(), config.getDb().getBootstrapDBUsername(), config.getDb().getBootstrapDBPassword(), this._config.getDb().getBootstrapDBName(), true);
        LOG.info((Object)("BootstrapSCNProcessor: config=" + config + ", dbConn=" + conn));
    }

    protected BootstrapSCNProcessor() {
    }

    public boolean shouldBypassSnapshot(long sinceScn, long startScn, List<BootstrapDBMetaDataDAO.SourceStatusInfo> srcList) throws SQLException, BootstrapProcessingException {
        if (srcList == null || srcList.isEmpty()) {
            return false;
        }
        if (sinceScn <= 0L) {
            LOG.info((Object)("Client requesting from SCN (" + sinceScn + "). Bootstrap Snapshot will not be bypassed !!"));
            return false;
        }
        for (BootstrapDBMetaDataDAO.SourceStatusInfo pair : srcList) {
            long currRows;
            boolean disableSnapshotBypass = this._config.isBypassSnapshotDisabled(pair.getSrcName());
            if (disableSnapshotBypass) {
                return false;
            }
            boolean canCatchupFromLog = this.validateIfCanCatchupFromLog(sinceScn, startScn, pair.getSrcId());
            if (!canCatchupFromLog) {
                return false;
            }
            long threshold = this._config.getRowsThresholdForSnapshotBypass(pair.getSrcName());
            if (threshold == Long.MAX_VALUE || (currRows = this.getRowDiff(sinceScn, startScn, pair.getSrcId())) <= threshold) continue;
            LOG.info((Object)("Threshold check failed for source (" + pair.getSrcName() + ") Threshold:" + threshold + ",Approx Rows:" + currRows));
            return false;
        }
        return true;
    }

    protected boolean validateIfCanCatchupFromLog(long sinceScn, long startScn, int srcid) throws SQLException, BootstrapProcessingException {
        int startSCNLogId = this._dbDao.getLogIdToCatchup(srcid, startScn);
        if (sinceScn >= startScn) {
            return true;
        }
        int sinceSCNLogId = -1;
        try {
            sinceSCNLogId = this._dbDao.getLogIdToCatchup(srcid, sinceScn);
        }
        catch (BootstrapProcessingException bpe) {
            LOG.warn((Object)"Got Bootstrap Processing exception. Will disable bypassing snapshot !!", (Throwable)bpe);
            return false;
        }
        if (sinceSCNLogId > startSCNLogId) {
            String msg = "Internal Error. sinceSCNLogId > startSCNLogId but sinceSCN < startSCN, sinceScn:" + sinceScn + ",startScn:" + startScn + ",sinceSCNLogId:" + sinceSCNLogId + ",startSCNLogId:" + startSCNLogId;
            LOG.error((Object)msg);
            throw new BootstrapProcessingException(msg);
        }
        return true;
    }

    private long getRowDiff(long sinceScn, long startScn, int srcid) throws SQLException, BootstrapProcessingException {
        boolean debugEnabled = LOG.isDebugEnabled();
        int startSCNLogId = this._dbDao.getLogIdToCatchup(srcid, startScn);
        int sinceSCNLogId = this._dbDao.getLogIdToCatchup(srcid, sinceScn);
        long startRowNum = this._dbDao.getLogRowIdForSCN(sinceScn, sinceSCNLogId, srcid);
        long endRowNum = this._dbDao.getLogRowIdForSCN(startScn, startSCNLogId, srcid);
        if (debugEnabled) {
            LOG.debug((Object)("startRowNum is :" + startRowNum + ", endRowNum is :" + endRowNum + " sinceSCNLogId :" + sinceSCNLogId + ", startSCNLogId:" + startSCNLogId + ",sinceSCN :" + sinceScn + ",startSCN:" + startScn));
        }
        long numRows = 0L;
        if (sinceSCNLogId == startSCNLogId) {
            numRows = endRowNum - startRowNum;
        } else {
            long currNumRows = this._dbDao.getBootstrapConn().getMaxRowIdForLog(sinceSCNLogId, srcid);
            if (debugEnabled) {
                LOG.debug((Object)("MaxRid for srcid :" + srcid + " and logid:" + sinceSCNLogId + " is :" + currNumRows));
            }
            numRows = currNumRows - startRowNum;
            for (int i = sinceSCNLogId + 1; i < startSCNLogId; ++i) {
                currNumRows = this._dbDao.getBootstrapConn().getMaxRowIdForLog(i, srcid);
                if (debugEnabled) {
                    LOG.debug((Object)("MaxRid for srcid :" + srcid + " and logid:" + i + " is :" + currNumRows));
                }
                numRows += currNumRows;
            }
            numRows += endRowNum;
        }
        LOG.info((Object)("Total Rows (approx) :" + numRows + " between SCNs :" + sinceScn + " and " + startScn + " for srcid :" + srcid));
        return numRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public long getMinApplierWindowScn(long sinceScn, List<BootstrapDBMetaDataDAO.SourceStatusInfo> sourceList) throws BootstrapDatabaseTooOldException, BootstrapProcessingException, SQLException {
        long terminationTime = System.currentTimeMillis() + 60000L;
        long startScn = -1L;
        long producerScn = -1L;
        ResultSet rs = null;
        Connection conn = this._dbDao.getBootstrapConn().getDBConn();
        PreparedStatement getScnStmt = null;
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (BootstrapDBMetaDataDAO.SourceStatusInfo pair : sourceList) {
            if (!pair.isValidSource()) {
                throw new BootstrapProcessingException("Bootstrap DB not servicing source :" + pair.getSrcId());
            }
            if (!first) {
                buf.append(",");
            }
            buf.append(pair.getSrcId());
            first = false;
        }
        String sources = buf.toString();
        while (producerScn < sinceScn && System.currentTimeMillis() < terminationTime) {
            try {
                String applierSql = START_SCN_STMT_SQL_PREFIX + sources + ")";
                String producerSql = PRODUCER_SCN_STMT_SQL_PREFIX + sources + ")";
                LOG.info((Object)("Executing Applier SCN Query :" + applierSql));
                getScnStmt = conn.prepareStatement(applierSql);
                rs = new BootstrapDBTimedQuery(getScnStmt, this._config.getQueryTimeoutInSec()).executeQuery();
                if (rs.next()) {
                    startScn = rs.getLong(1);
                }
                DBHelper.close((ResultSet)rs, (Statement)getScnStmt, null);
                rs = null;
                getScnStmt = null;
                LOG.info((Object)("Executing Producer SCN Query :" + producerSql));
                getScnStmt = conn.prepareStatement(producerSql);
                rs = new BootstrapDBTimedQuery(getScnStmt, this._config.getQueryTimeoutInSec()).executeQuery();
                if (rs.next()) {
                    producerScn = rs.getLong(1);
                }
                if (producerScn < startScn) {
                    String msg = "Bootstrap Producer has lower SCN than Applier SCN. This is unexpected !! Producer SCN :" + producerScn + ", Applier SCN :" + startScn;
                    LOG.fatal((Object)msg);
                    throw new BootstrapDatabaseTooOldException(msg);
                }
                if (producerScn < sinceScn) {
                    LOG.warn((Object)"Bootstrap producer has not caught up to all events in its buffer yet to server client properly");
                    Thread.sleep(100L);
                }
                DBHelper.close((ResultSet)rs, (Statement)getScnStmt, null);
            }
            catch (InterruptedException e) {
                DBHelper.close(rs, getScnStmt, null);
            }
            catch (SQLException e2) {
                LOG.warn((Object)"SQLException encountered while querying for start scn", (Throwable)e2);
                continue;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                DBHelper.close(rs, getScnStmt, null);
            }
        }
        if (producerScn < sinceScn) {
            String msg = "Bootstrap producer is slower than the client. Client is at SCN :" + sinceScn + ", Producer is at SCN :" + producerScn + ", Applier is at SCN :" + startScn;
            LOG.error((Object)msg);
            throw new BootstrapDatabaseTooOldException(msg);
        }
        LOG.info((Object)("StartSCN Request for sources :" + sources + ",Client SCN :" + sinceScn + ",Producer SCN :" + producerScn + ", Applier SCN :" + startScn));
        return startScn;
    }

    public long getSourceTargetScn(int srcId) throws SQLException {
        long scn = 0L;
        ResultSet rs = null;
        PreparedStatement targetScnStmt = this.getTargetScnStmt();
        try {
            targetScnStmt.setInt(1, srcId);
            rs = new BootstrapDBTimedQuery(targetScnStmt, this._config.getQueryTimeoutInSec()).executeQuery();
            while (rs.next()) {
                scn = rs.getLong(1);
                LOG.info((Object)("target scn for source " + srcId + " is " + scn));
            }
            rs.close();
        }
        catch (SQLException e) {
            try {
                LOG.error((Object)"Error encountered while selecting target scn for bootstrap_producer_state:", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                DBHelper.close(rs, (Statement)targetScnStmt, null);
                throw throwable;
            }
        }
        DBHelper.close((ResultSet)rs, (Statement)targetScnStmt, null);
        return scn;
    }

    private PreparedStatement getTargetScnStmt() throws SQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this._dbDao.getBootstrapConn().getDBConn();
            stmt = conn.prepareStatement("SELECT windowscn FROM bootstrap_producer_state where srcid = ?");
        }
        catch (SQLException e) {
            LOG.error((Object)"Error occurred while creating getTargetScnStatement", (Throwable)e);
            throw e;
        }
        return stmt;
    }

    public BootstrapDBMetaDataDAO getBootstrapMetaDataDAO() {
        return this._dbDao;
    }

    public List<BootstrapDBMetaDataDAO.SourceStatusInfo> getSourceIdAndStatusFromName(List<String> sourceList) throws SQLException, BootstrapDatabaseTooOldException {
        return this._dbDao.getSourceIdAndStatusFromName(sourceList, true);
    }

    public BootstrapDBMetaDataDAO.SourceStatusInfo getSrcIdStatusFromDB(String source, boolean activeCheck) throws SQLException, BootstrapDatabaseTooOldException {
        return this._dbDao.getSrcIdStatusFromDB(source, activeCheck);
    }

    public void shutdown() {
        if (null != this._dbDao) {
            this._dbDao.getBootstrapConn().close();
            this._dbDao = null;
        }
    }
}

