/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.server;

import com.linkedin.databus.bootstrap.common.BootstrapConfig;
import com.linkedin.databus.bootstrap.server.BootstrapServerStaticConfig;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class BootstrapServerConfig
implements ConfigBuilder<BootstrapServerStaticConfig> {
    public static final long DEFAULT_LONGEST_DB_TXN_TIME_MINS = 240L;
    public static final long DEFAULT_DEFAULT_THRESHOLD_FOR_SNAPSHOT_BYPASS = -1L;
    public static final boolean DEFAULT_PREDICATEPUSHDOWN = true;
    public static final boolean DEFAULT_MINSCNCHECK = true;
    public static final int DEFAULT_BOOTSTRAP_DB_QUERY_EXECUTION_TIMEOUT_IN_SEC = 3600;
    private Long defaultRowsThresholdForSnapshotBypass = -1L;
    private int queryTimeoutInSec = 3600;
    private final Map<String, Long> rowsThresholdForSnapshotBypass;
    private final Map<String, Boolean> disableSnapshotBypass = new HashMap<String, Boolean>();
    private final Map<String, Boolean> predicatePushDownBypass;
    private BootstrapConfig db;
    private boolean predicatePushDown = true;
    private boolean enableMinScnCheck = true;
    private long longestDbTxnTimeMins = 240L;

    public boolean getPredicatePushDown() {
        return this.predicatePushDown;
    }

    public void setPredicatePushDown(boolean predicatePushDown) {
        this.predicatePushDown = predicatePushDown;
    }

    public BootstrapServerStaticConfig build() throws InvalidConfigException {
        return new BootstrapServerStaticConfig(this.defaultRowsThresholdForSnapshotBypass, this.rowsThresholdForSnapshotBypass, this.disableSnapshotBypass, this.predicatePushDown, this.predicatePushDownBypass, this.queryTimeoutInSec, this.enableMinScnCheck, this.db.build(), this.longestDbTxnTimeMins);
    }

    public Long getDefaultRowsThresholdForSnapshotBypass() {
        return this.defaultRowsThresholdForSnapshotBypass;
    }

    public void setDefaultRowsThresholdForSnapshotBypass(Long defaultRowsThresholdForSnapshotBypass) {
        this.defaultRowsThresholdForSnapshotBypass = defaultRowsThresholdForSnapshotBypass;
    }

    public Long getRowsThresholdForSnapshotBypass(String source) {
        Long threshold = this.rowsThresholdForSnapshotBypass.get(source);
        if (null == threshold) {
            return this.defaultRowsThresholdForSnapshotBypass;
        }
        return threshold;
    }

    public long getLongestDbTxnTimeMins() {
        return this.longestDbTxnTimeMins;
    }

    public void setRowsThresholdForSnapshotBypass(String source, Long threshold) {
        this.rowsThresholdForSnapshotBypass.put(source, threshold);
    }

    public int getQueryTimeoutInSec() {
        return this.queryTimeoutInSec;
    }

    public void setQueryTimeoutInSec(int queryTimeInSec) {
        this.queryTimeoutInSec = queryTimeInSec;
    }

    public Boolean getDisableSnapshotBypass(String source) {
        Boolean disableBypass = this.disableSnapshotBypass.get(source);
        if (null == disableBypass) {
            return false;
        }
        return disableBypass;
    }

    public void setDisableSnapshotBypass(String source, Boolean disableBypass) {
        this.disableSnapshotBypass.put(source, disableBypass);
    }

    public boolean getPredicatePushDownBypass(String source) {
        Boolean predicateOverride = this.predicatePushDownBypass.get(source);
        if (predicateOverride == null) {
            return true;
        }
        return predicateOverride;
    }

    public void setPredicatePushDownBypass(String source, boolean override) {
        this.predicatePushDownBypass.put(source, override);
    }

    public boolean isEnableMinScnCheck() {
        return this.enableMinScnCheck;
    }

    public void setEnableMinScnCheck(boolean enableMinScnCheck) {
        this.enableMinScnCheck = enableMinScnCheck;
    }

    public void setLongestDbTxnTimeMins(long longestDbTxnTimeMins) {
        this.longestDbTxnTimeMins = longestDbTxnTimeMins;
    }

    public BootstrapConfig getDb() {
        return this.db;
    }

    public void setDb(BootstrapConfig db) {
        this.db = db;
    }

    public BootstrapServerConfig() throws IOException {
        this.rowsThresholdForSnapshotBypass = new HashMap<String, Long>();
        this.predicatePushDownBypass = new HashMap<String, Boolean>();
        this.db = new BootstrapConfig();
    }
}

