/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.server;

import com.linkedin.databus.bootstrap.common.BootstrapReadOnlyConfig;
import java.util.Map;

public class BootstrapServerStaticConfig {
    private final long _longestDbTxnTimeMins;
    private final Long defaultRowsThresholdForSnapshotBypass;
    private final Map<String, Long> rowsThresholdForSnapshotBypass;
    private final Map<String, Boolean> disableSnapshotBypass;
    private final BootstrapReadOnlyConfig db;
    private final boolean predicatePushDown;
    private final Map<String, Boolean> predicatePushDownBypass;
    private final int queryTimeoutInSec;
    private final boolean enableMinScnCheck;

    public BootstrapServerStaticConfig(Long defaultRowsThresholdForSnapshotBypass, Map<String, Long> rowsThresholdForSnapshotBypass, Map<String, Boolean> disableSnapshotBypass, boolean predicatePushDown, Map<String, Boolean> predicatePushDownBypass, int queryTimeoutInSec, boolean enableMinScnCheck, BootstrapReadOnlyConfig db, long longestDbTxnTimeMins) {
        this.defaultRowsThresholdForSnapshotBypass = defaultRowsThresholdForSnapshotBypass;
        this.rowsThresholdForSnapshotBypass = rowsThresholdForSnapshotBypass;
        this.disableSnapshotBypass = disableSnapshotBypass;
        this.predicatePushDown = predicatePushDown;
        this.predicatePushDownBypass = predicatePushDownBypass;
        this.queryTimeoutInSec = queryTimeoutInSec;
        this.enableMinScnCheck = enableMinScnCheck;
        this.db = db;
        this._longestDbTxnTimeMins = longestDbTxnTimeMins;
    }

    public String toString() {
        return "BootstrapStaticConfig [defaultRowsThresholdForSnapshotBypass=" + this.defaultRowsThresholdForSnapshotBypass + ", rowsThresholdForSnapshotBypass=" + this.rowsThresholdForSnapshotBypass + ", disableSnapshotBypass=" + this.disableSnapshotBypass + " , queryTimeoutInSec=" + this.queryTimeoutInSec + " predicatePushDown= " + this.predicatePushDown + " enableMinScnCheck= " + this.enableMinScnCheck + ", db=" + this.db + "]";
    }

    public boolean getPredicatePushDown() {
        return this.predicatePushDown;
    }

    public Map<String, Boolean> predicatePushDownBypass() {
        return this.predicatePushDownBypass;
    }

    public Long getDefaultRowsThresholdForSnapshotBypass() {
        return this.defaultRowsThresholdForSnapshotBypass;
    }

    public long getLongestDbTxnTimeMins() {
        return this._longestDbTxnTimeMins;
    }

    public int getQueryTimeoutInSec() {
        return this.queryTimeoutInSec;
    }

    public Map<String, Long> getRowsThresholdForSnapshotBypass() {
        return this.rowsThresholdForSnapshotBypass;
    }

    public Map<String, Boolean> getDisableSnapshotBypass() {
        return this.disableSnapshotBypass;
    }

    public BootstrapReadOnlyConfig getDb() {
        return this.db;
    }

    public boolean isBypassSnapshotDisabled(String source) {
        Boolean byPass = this.disableSnapshotBypass.get(source);
        if (null == byPass) {
            return false;
        }
        return byPass;
    }

    public boolean isPredicatePushDownEnabled(String source) {
        if (source == null) {
            return this.getPredicatePushDown();
        }
        Boolean predicateOverride = this.predicatePushDownBypass.get(source);
        if (predicateOverride == null) {
            return this.getPredicatePushDown();
        }
        return predicateOverride;
    }

    public boolean isEnableMinScnCheck() {
        return this.enableMinScnCheck;
    }

    public long getRowsThresholdForSnapshotBypass(String source) {
        long threshold = this.defaultRowsThresholdForSnapshotBypass;
        Long t = this.rowsThresholdForSnapshotBypass.get(source);
        if (null != t) {
            threshold = t;
        }
        return threshold;
    }
}

