/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.server;

import com.linkedin.databus.bootstrap.common.BootstrapDBMetaDataDAO;
import com.linkedin.databus.bootstrap.common.BootstrapHttpStatsCollector;
import com.linkedin.databus.bootstrap.server.BootstrapHttpServer;
import com.linkedin.databus.bootstrap.server.BootstrapRequestProcessorBase;
import com.linkedin.databus.bootstrap.server.BootstrapSCNProcessor;
import com.linkedin.databus.bootstrap.server.BootstrapServerStaticConfig;
import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus2.core.container.request.BootstrapDatabaseTooOldException;
import com.linkedin.databus2.core.container.request.BootstrapDatabaseTooYoungException;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class StartSCNRequestProcessor
extends BootstrapRequestProcessorBase {
    public static final String MODULE = StartSCNRequestProcessor.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String COMMAND_NAME = "startSCN";
    public static final String SOURCES_PARAM = "sources";
    public static final String SOURCE_DELIMITER = ",";

    public StartSCNRequestProcessor(ExecutorService executorService, BootstrapServerStaticConfig config, BootstrapHttpServer bootstrapServer) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        super(executorService, config, bootstrapServer);
    }

    @Override
    protected DatabusRequest doProcess(DatabusRequest request) throws IOException, RequestProcessingException {
        BootstrapHttpStatsCollector bootstrapStatsCollector = this._bootstrapServer.getBootstrapStatsCollector();
        long startTime = System.currentTimeMillis();
        String sources = request.getRequiredStringParam(SOURCES_PARAM);
        List<String> srcList = this.getSources(sources);
        Checkpoint ckpt = new Checkpoint(request.getRequiredStringParam("checkPoint"));
        LOG.info((Object)("StartSCN requested for sources : (" + sources + "). CheckPoint is :" + ckpt));
        long sinceScn = ckpt.getBootstrapSinceScn();
        ObjectMapper mapper = new ObjectMapper();
        StringWriter out = new StringWriter(1024);
        long startSCN = -1L;
        BootstrapSCNProcessor processor = null;
        try {
            processor = new BootstrapSCNProcessor(this._config, this._bootstrapServer.getInboundEventStatisticsCollector());
            List<BootstrapDBMetaDataDAO.SourceStatusInfo> srcStatusPairs = null;
            try {
                srcStatusPairs = processor.getSourceIdAndStatusFromName(srcList);
                startSCN = processor.getMinApplierWindowScn(sinceScn, srcStatusPairs);
                if (processor.shouldBypassSnapshot(sinceScn, startSCN, srcStatusPairs)) {
                    LOG.info((Object)("Bootstrap Snapshot phase will be bypassed for startScn request :" + request));
                    LOG.info((Object)("Original startSCN is:" + startSCN + ", Setting startSCN to the sinceSCN:" + sinceScn));
                    startSCN = sinceScn;
                } else {
                    if (startSCN == -1L) {
                        throw new RequestProcessingException("Bootstrap DB is being initialized! startSCN=" + startSCN);
                    }
                    if (this._config.isEnableMinScnCheck()) {
                        long minScn = processor.getBootstrapMetaDataDAO().getMinScnOfSnapshots(srcStatusPairs);
                        LOG.info((Object)("Min scn for tab tables is: " + minScn));
                        if (minScn == -1L) {
                            throw new BootstrapDatabaseTooYoungException("BootstrapDB has no minScn for these sources, but minScn check is enabled! minScn=" + minScn);
                        }
                        if (sinceScn <= minScn && (sinceScn != 0L || minScn != 0L)) {
                            LOG.error((Object)("Bootstrap Snapshot doesn't have requested data . sinceScn too old! sinceScn is " + sinceScn + " but minScn available is " + minScn));
                            throw new BootstrapDatabaseTooYoungException("Min scn=" + minScn + " Since scn=" + sinceScn);
                        }
                    } else {
                        LOG.debug((Object)"Bypassing minScn check! ");
                    }
                }
            }
            catch (BootstrapDatabaseTooOldException tooOldException) {
                if (bootstrapStatsCollector != null) {
                    bootstrapStatsCollector.registerErrStartSCN();
                    bootstrapStatsCollector.registerErrDatabaseTooOld();
                }
                LOG.error((Object)"The bootstrap database is too old!", (Throwable)tooOldException);
                throw new RequestProcessingException((Throwable)tooOldException);
            }
            catch (BootstrapDatabaseTooYoungException e) {
                if (bootstrapStatsCollector != null) {
                    bootstrapStatsCollector.registerErrStartSCN();
                    bootstrapStatsCollector.registerErrBootstrap();
                }
                LOG.error((Object)"The bootstrap database is too young!", (Throwable)e);
                throw new RequestProcessingException((Throwable)e);
            }
            catch (SQLException e) {
                if (bootstrapStatsCollector != null) {
                    bootstrapStatsCollector.registerErrStartSCN();
                    bootstrapStatsCollector.registerErrSqlException();
                }
                LOG.error((Object)"Error encountered while fetching startSCN from database.", (Throwable)e);
                throw new RequestProcessingException((Throwable)e);
            }
            mapper.writeValue((Writer)out, (Object)String.valueOf(startSCN));
            byte[] resultBytes = out.toString().getBytes(Charset.defaultCharset());
            request.getResponseContent().write(ByteBuffer.wrap(resultBytes));
            LOG.info((Object)("startSCN: " + startSCN + " with server Info :" + this._serverHostPort));
        }
        catch (RequestProcessingException ex) {
            LOG.error((Object)"Got exception while calculating startSCN", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Object)"Got exception while calculating startSCN", (Throwable)ex);
            throw new RequestProcessingException((Throwable)ex);
        }
        finally {
            if (null != processor) {
                processor.shutdown();
            }
        }
        if (bootstrapStatsCollector != null) {
            bootstrapStatsCollector.registerStartSCNReq(System.currentTimeMillis() - startTime);
        }
        return request;
    }

    private List<String> getSources(String sources) {
        String[] sourceList;
        ArrayList<String> srcList = new ArrayList<String>();
        if (null == sources) {
            return null;
        }
        for (String s : sourceList = sources.split(SOURCE_DELIMITER)) {
            srcList.add(s);
        }
        return srcList;
    }
}

