/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.server;

import com.linkedin.databus.bootstrap.api.BootstrapProcessingException;
import com.linkedin.databus.bootstrap.common.BootstrapDBMetaDataDAO;
import com.linkedin.databus.bootstrap.common.BootstrapHttpStatsCollector;
import com.linkedin.databus.bootstrap.server.BootstrapHttpServer;
import com.linkedin.databus.bootstrap.server.BootstrapRequestProcessorBase;
import com.linkedin.databus.bootstrap.server.BootstrapSCNProcessor;
import com.linkedin.databus.bootstrap.server.BootstrapServerStaticConfig;
import com.linkedin.databus2.core.container.request.BootstrapDatabaseTooOldException;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class TargetSCNRequestProcessor
extends BootstrapRequestProcessorBase {
    public static final String MODULE = TargetSCNRequestProcessor.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String COMMAND_NAME = "targetSCN";
    public static final String SOURCE_PARAM = "source";

    public TargetSCNRequestProcessor(ExecutorService executorService, BootstrapServerStaticConfig config, BootstrapHttpServer bootstrapServer) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        super(executorService, config, bootstrapServer);
    }

    @Override
    protected DatabusRequest doProcess(DatabusRequest request) throws IOException, RequestProcessingException {
        BootstrapHttpStatsCollector bootstrapStatsCollector = this._bootstrapServer.getBootstrapStatsCollector();
        long startTime = System.currentTimeMillis();
        int srcId = -1;
        long targetScn = -1L;
        String source = request.getRequiredStringParam(SOURCE_PARAM);
        BootstrapSCNProcessor processor = null;
        try {
            processor = new BootstrapSCNProcessor(this._config, this._bootstrapServer.getInboundEventStatisticsCollector());
            try {
                BootstrapDBMetaDataDAO.SourceStatusInfo srcIdStatus = processor.getSrcIdStatusFromDB(source, true);
                if (!srcIdStatus.isValidSource()) {
                    throw new BootstrapProcessingException("Bootstrap DB not servicing source :" + source);
                }
                srcId = srcIdStatus.getSrcId();
                targetScn = processor.getSourceTargetScn(srcId);
            }
            catch (BootstrapDatabaseTooOldException tooOldException) {
                if (bootstrapStatsCollector != null) {
                    bootstrapStatsCollector.registerErrTargetSCN();
                    bootstrapStatsCollector.registerErrDatabaseTooOld();
                }
                LOG.error((Object)"The bootstrap database is too old!", (Throwable)tooOldException);
                throw new RequestProcessingException((Throwable)tooOldException);
            }
            catch (SQLException e) {
                if (bootstrapStatsCollector != null) {
                    bootstrapStatsCollector.registerErrTargetSCN();
                    bootstrapStatsCollector.registerErrSqlException();
                }
                LOG.error((Object)"Error encountered while fetching targetSCN from database.", (Throwable)e);
                throw new RequestProcessingException((Throwable)e);
            }
            ObjectMapper mapper = new ObjectMapper();
            StringWriter out = new StringWriter(1024);
            mapper.writeValue((Writer)out, (Object)String.valueOf(targetScn));
            byte[] resultBytes = out.toString().getBytes(Charset.defaultCharset());
            request.getResponseContent().write(ByteBuffer.wrap(resultBytes));
            LOG.info((Object)("targetSCN: " + targetScn));
        }
        catch (Exception ex) {
            LOG.error((Object)"Got exception while calculating targetSCN", (Throwable)ex);
            throw new RequestProcessingException((Throwable)ex);
        }
        finally {
            if (null != processor) {
                processor.shutdown();
            }
        }
        if (bootstrapStatsCollector != null) {
            bootstrapStatsCollector.registerTargetSCNReq(System.currentTimeMillis() - startTime);
        }
        return request;
    }
}

