/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.utils;

import com.linkedin.databus.bootstrap.utils.BootstrapReaderEventHandler;
import com.linkedin.databus.bootstrap.utils.BootstrapTableReader;
import com.linkedin.databus.core.DbusEvent;
import java.io.File;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class BootstrapAvroRecordDumper {
    public static final String MODULE = BootstrapAvroRecordDumper.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String OUTPUT_DIR_OPT_LONG_NAME = "output_dir";
    public static final char OUTPUT_DIR_OPT_CHAR = 'o';
    public static String outputDir = null;

    public static void main(String[] args) throws Exception {
        BootstrapTableReader.init(args);
        BootstrapTableReader reader = new BootstrapTableReader(new DumpEventHandler(outputDir, BootstrapTableReader.getSchema()));
        reader.execute();
    }

    public static void parseArgs(String[] args) throws IOException {
        GnuParser cliParser = new GnuParser();
        OptionBuilder.withLongOpt((String)OUTPUT_DIR_OPT_LONG_NAME);
        OptionBuilder.withDescription((String)"Help screen");
        Option outputDirOption = OptionBuilder.create((char)'o');
        Options options = new Options();
        options.addOption(outputDirOption);
        CommandLine cmd = null;
        try {
            cmd = cliParser.parse(options, args);
        }
        catch (ParseException pe) {
            LOG.fatal((Object)"Bootstrap Avro Record Dumper: failed to parse command-line options.", (Throwable)pe);
            throw new RuntimeException("Bootstrap Avro Record Dumper: failed to parse command-line options.", pe);
        }
        if (cmd.hasOption('o')) {
            outputDir = cmd.getOptionValue('o');
        }
    }

    public static class DumpEventHandler
    implements BootstrapReaderEventHandler {
        private String _query = null;
        private DataFileWriter<GenericRecord> writer = null;
        private File directory = null;
        private File currentFile = null;

        public DumpEventHandler(String dir, Schema schema) throws IOException {
            DataFileWriter writeCreator = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));
            this.directory = new File(dir);
            if (!this.directory.isDirectory()) {
                throw new RuntimeException("The path (" + dir + ") either does not exist or is not a directory !!");
            }
            this.currentFile = new File(this.directory.getAbsolutePath() + "/part-000.avro");
            this.writer = writeCreator.create(schema, this.currentFile);
        }

        @Override
        public void onRecord(DbusEvent event, GenericRecord record) {
            try {
                this.writer.append((Object)record);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        @Override
        public void onStart(String query) {
            this._query = query;
        }

        @Override
        public void onEnd(int count) {
            System.out.println("Read " + count + " records by executing query :( " + this._query + ")");
        }
    }
}

