/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.utils;

import com.linkedin.databus.bootstrap.common.BootstrapCleanerConfig;
import com.linkedin.databus.bootstrap.common.BootstrapCleanerStaticConfig;
import com.linkedin.databus.bootstrap.common.BootstrapConfig;
import com.linkedin.databus.bootstrap.common.BootstrapDBCleaner;
import com.linkedin.databus.bootstrap.common.BootstrapReadOnlyConfig;
import com.linkedin.databus.bootstrap.utils.BootstrapSeederMain;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.ConfigLoader;
import com.linkedin.databus2.util.DBHelper;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;

public class BootstrapDBCleanerMain {
    public static final String MODULE = BootstrapSeederMain.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String HELP_OPT_LONG_NAME = "help";
    public static final char HELP_OPT_CHAR = 'h';
    public static final String BOOTSTRAP_SOURCES_OPT_LONG_NAME = "sources";
    public static final char BOOTSTRAP_SOURCES_PROP_OPT_CHAR = 's';
    public static final String BOOTSTRAP_DB_PROPS_OPT_LONG_NAME = "bootstrap_db_props";
    public static final char BOOTSTRAP_DB_PROP_OPT_CHAR = 'p';
    public static final String CLEANER_CMD_LINE_PROPS_OPT_LONG_NAME = "cleaner_cmdline_props";
    public static final char CLEANER_CMD_LINE_PROPS_OPT_CHAR = 'c';
    public static final String LOG4J_PROPS_OPT_LONG_NAME = "log_props";
    public static final char LOG4J_PROPS_OPT_CHAR = 'l';
    private static BootstrapCleanerStaticConfig _sCleanerConfig = null;
    private static BootstrapReadOnlyConfig _sBootstrapConfig = null;
    private static List<String> _sSources = null;
    private static Properties _sBootstrapConfigProps = null;

    public static void main(String[] args) throws Exception {
        BootstrapDBCleanerMain.parseArgs(args);
        BootstrapCleanerConfig config = new BootstrapCleanerConfig();
        BootstrapConfig bsConfig = new BootstrapConfig();
        ConfigLoader configLoader = new ConfigLoader("databus.bootstrap.cleaner.", (ConfigBuilder)config);
        ConfigLoader configLoader2 = new ConfigLoader("databus.bootstrap.db.", (ConfigBuilder)bsConfig);
        _sCleanerConfig = (BootstrapCleanerStaticConfig)configLoader.loadConfig((Map)_sBootstrapConfigProps);
        _sBootstrapConfig = (BootstrapReadOnlyConfig)configLoader2.loadConfig((Map)_sBootstrapConfigProps);
        BootstrapDBCleaner cleaner = new BootstrapDBCleaner("StandAloneCleaner", _sCleanerConfig, _sBootstrapConfig, null, _sSources);
        cleaner.doClean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseArgs(String[] args) throws IOException {
        GnuParser cliParser = new GnuParser();
        OptionBuilder.withLongOpt((String)HELP_OPT_LONG_NAME);
        OptionBuilder.withDescription((String)"Help screen");
        Option helpOption = OptionBuilder.create((char)'h');
        OptionBuilder.withLongOpt((String)BOOTSTRAP_DB_PROPS_OPT_LONG_NAME);
        OptionBuilder.withDescription((String)"Bootstrap Cleaner and DB properties to use");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"property_file");
        Option dbOption = OptionBuilder.create((char)'p');
        OptionBuilder.withLongOpt((String)CLEANER_CMD_LINE_PROPS_OPT_LONG_NAME);
        OptionBuilder.withDescription((String)"Cmd line override of cleaner config properties. Semicolon separated.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"Semicolon_separated_properties");
        Option cmdLinePropsOption1 = OptionBuilder.create((char)'c');
        OptionBuilder.withLongOpt((String)LOG4J_PROPS_OPT_LONG_NAME);
        OptionBuilder.withDescription((String)"Log4j properties to use");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"property_file");
        Option log4jPropsOption = OptionBuilder.create((char)'l');
        OptionBuilder.withLongOpt((String)BOOTSTRAP_SOURCES_OPT_LONG_NAME);
        OptionBuilder.withDescription((String)"Comma seperated list of sourceNames. If not provided, no source will be cleaned up");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"comma-seperated sources");
        Option sourcesOption = OptionBuilder.create((char)'s');
        Options options = new Options();
        options.addOption(helpOption);
        options.addOption(dbOption);
        options.addOption(cmdLinePropsOption1);
        options.addOption(log4jPropsOption);
        options.addOption(sourcesOption);
        CommandLine cmd = null;
        try {
            cmd = cliParser.parse(options, args);
        }
        catch (ParseException pe) {
            LOG.error((Object)"Bootstrap Physical Config: failed to parse command-line options.", (Throwable)pe);
            throw new RuntimeException("Bootstrap Physical Config: failed to parse command-line options.", pe);
        }
        if (cmd.hasOption('l')) {
            String log4jPropFile = cmd.getOptionValue('l');
            PropertyConfigurator.configure((String)log4jPropFile);
            LOG.info((Object)("Using custom logging settings from file " + log4jPropFile));
        } else {
            PatternLayout defaultLayout = new PatternLayout("%d{ISO8601} +%r [%t] (%p) {%c} %m%n");
            ConsoleAppender defaultAppender = new ConsoleAppender((Layout)defaultLayout);
            Logger.getRootLogger().removeAllAppenders();
            Logger.getRootLogger().addAppender((Appender)defaultAppender);
            LOG.info((Object)"Using default logging settings");
        }
        if (cmd.hasOption('h')) {
            BootstrapDBCleanerMain.printCliHelp(options);
            System.exit(0);
        }
        if (cmd.hasOption('s')) {
            String[] srcList;
            _sSources = new ArrayList<String>();
            String srcListStr = cmd.getOptionValue('s');
            LOG.info((Object)("Going to run cleaner for only these sources : " + srcListStr));
            for (String s : srcList = srcListStr.split(",")) {
                _sSources.add(s);
            }
        }
        if (!cmd.hasOption('p')) {
            throw new RuntimeException("Bootstrap config is not provided");
        }
        String propFile = cmd.getOptionValue('p');
        LOG.info((Object)("Loading bootstrap DB config from properties file " + propFile));
        _sBootstrapConfigProps = new Properties();
        FileInputStream f = new FileInputStream(propFile);
        try {
            _sBootstrapConfigProps.load(f);
        }
        finally {
            f.close();
        }
        if (cmd.hasOption('c')) {
            String cmdLinePropString = cmd.getOptionValue('c');
            BootstrapDBCleanerMain.updatePropsFromCmdLine(_sBootstrapConfigProps, cmdLinePropString);
        }
    }

    private static void printCliHelp(Options cliOptions) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("java " + BootstrapDBCleanerMain.class.getName(), cliOptions);
    }

    private static void updatePropsFromCmdLine(Properties props, String cmdLinePropString) {
        String[] cmdLinePropSplit;
        for (String s : cmdLinePropSplit = cmdLinePropString.split(";")) {
            String[] onePropSplit = s.split("=");
            if (onePropSplit.length != 2) {
                LOG.error((Object)("CMD line property setting " + s + "is not valid!"));
                continue;
            }
            LOG.info((Object)("CMD line Property overwride: " + s));
            props.put(onePropSplit[0], onePropSplit[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getSourceNames(Connection conn) throws SQLException {
        ArrayList<String> srcNames = new ArrayList<String>();
        String sql = "select src from bootstrap_sources";
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                srcNames.add(name);
            }
        }
        catch (Throwable throwable) {
            DBHelper.close(rs, (Statement)stmt, null);
            throw throwable;
        }
        DBHelper.close((ResultSet)rs, (Statement)stmt, null);
        return srcNames;
    }
}

