/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.utils;

import com.linkedin.databus.bootstrap.common.BootstrapConn;
import com.linkedin.databus.bootstrap.common.BootstrapDBMetaDataDAO;
import com.linkedin.databus.bootstrap.common.BootstrapReadOnlyConfig;
import com.linkedin.databus.core.DbusEventBufferAppendable;
import com.linkedin.databus.core.DbusEventBufferStreamAppendable;
import com.linkedin.databus.core.DbusEventFactory;
import com.linkedin.databus.core.DbusEventInfo;
import com.linkedin.databus.core.DbusEventKey;
import com.linkedin.databus.core.DbusOpcode;
import com.linkedin.databus.core.InternalDatabusEventsListener;
import com.linkedin.databus.core.InvalidEventException;
import com.linkedin.databus.core.KeyTypeNotImplementedException;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus2.producers.db.OracleTriggerMonitoredSourceInfo;
import com.linkedin.databus2.util.DBHelper;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BootstrapDBSeeder
implements DbusEventBufferAppendable,
DbusEventBufferStreamAppendable {
    private static final int FIFTY_MB_IN_BYTES = 50000000;
    public static final String MODULE = BootstrapDBSeeder.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private BootstrapDBMetaDataDAO _bootstrapDao = null;
    private BootstrapReadOnlyConfig _config = null;
    private ByteBuffer _buf = null;
    private ByteArrayInputStream _bufStream = null;
    private ByteArrayInputStream _bufStream2 = null;
    private final Map<Short, PreparedStatement> _statementMap;
    private short _currSrcId = (short)-1;
    private long _totLatency = 0L;
    private long _scn = 0L;
    private List<OracleTriggerMonitoredSourceInfo> _sources = null;
    private Map<String, Long> _lastRows = null;
    private Map<String, String> _lastKeys = null;
    private String _lastSeenKey = null;
    private long _startSCN = -1L;

    public BootstrapDBSeeder(BootstrapReadOnlyConfig config, List<OracleTriggerMonitoredSourceInfo> sources) throws Exception {
        this._config = config;
        this._statementMap = new HashMap<Short, PreparedStatement>();
        byte[] b = new byte[50000000];
        this._buf = ByteBuffer.wrap(b);
        this._bufStream = new ByteArrayInputStream(b);
        this._bufStream2 = new ByteArrayInputStream(b);
        this.getConnection();
        this._sources = sources;
        this.initSources();
    }

    public void initSources() throws SQLException {
        LOG.info((Object)("MySQL JDBC Version :" + this.getConnection().getMetaData().getDriverVersion()));
        this._lastRows = new HashMap<String, Long>();
        this._lastKeys = new HashMap<String, String>();
        for (OracleTriggerMonitoredSourceInfo sourceInfo : this._sources) {
            this.createBootStrapSourceDB(sourceInfo);
            this._lastRows.put(sourceInfo.getEventView(), this.getRowIdFromCheckpoint(sourceInfo));
            String k = this.geSrcKeyFromCheckpoint(sourceInfo);
            this._lastKeys.put(sourceInfo.getEventView(), k);
            if (-1 == this._currSrcId) {
                this._currSrcId = sourceInfo.getSourceId();
            }
            if (null != this._lastSeenKey) continue;
            this._lastSeenKey = k;
        }
    }

    public void startSeeding() throws SQLException {
        this.setBootstrapSourceStatus(2);
    }

    public Map<String, Long> getLastRows() {
        return this._lastRows;
    }

    public Map<String, String> getLastKeys() {
        return this._lastKeys;
    }

    private PreparedStatement prepareInsertStatement(short srcId) throws SQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        StringBuilder sql = new StringBuilder();
        try {
            conn = this.getConnection();
            sql.append("insert into ");
            sql.append(this.getTableName(srcId));
            sql.append("(scn, srckey, val) ");
            sql.append(" values(?,?,?) ");
            sql.append("on duplicate key update scn = ?, ");
            sql.append("val = ?");
            stmt = conn.prepareStatement(sql.toString());
        }
        catch (SQLException e) {
            LOG.fatal((Object)("Unable to create insert statement for Statement : (" + sql + ")"), (Throwable)e);
            throw e;
        }
        return stmt;
    }

    public Connection getConnection() {
        Connection conn = null;
        if (this._bootstrapDao == null) {
            LOG.info((Object)"<<<< Creating Bootstrap Connection!! >>>>");
            BootstrapConn dbConn = new BootstrapConn();
            try {
                dbConn.initBootstrapConn(false, 1, this._config.getBootstrapDBUsername(), this._config.getBootstrapDBPassword(), this._config.getBootstrapDBHostname(), this._config.getBootstrapDBName());
                this._bootstrapDao = new BootstrapDBMetaDataDAO(dbConn, this._config.getBootstrapDBHostname(), this._config.getBootstrapDBUsername(), this._config.getBootstrapDBPassword(), this._config.getBootstrapDBName(), false);
            }
            catch (Exception e) {
                LOG.fatal((Object)"Unable to open BootstrapDB Connection !!", (Throwable)e);
                throw new RuntimeException("Got exception when getting bootstrap DB Connection.", e);
            }
        }
        try {
            conn = this._bootstrapDao.getBootstrapConn().getDBConn();
        }
        catch (SQLException e) {
            LOG.fatal((Object)"Not able to open BootstrapDB Connection !!", (Throwable)e);
            throw new RuntimeException("Got exception when getting bootstrap DB Connection.", e);
        }
        return conn;
    }

    public void setBootstrapSourceStatus(int status) throws SQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            String sql = "insert into bootstrap_sources (id, src, status) values (?, ?, ?) on duplicate key update id = ?, src= ?, status=?";
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            for (OracleTriggerMonitoredSourceInfo sourceInfo : this._sources) {
                stmt.setInt(1, sourceInfo.getSourceId());
                stmt.setString(2, sourceInfo.getSourceName());
                stmt.setInt(3, status);
                stmt.setInt(4, sourceInfo.getSourceId());
                stmt.setString(5, sourceInfo.getSourceName());
                stmt.setInt(6, status);
                stmt.executeUpdate();
            }
            conn.commit();
        }
        catch (SQLException sqlEx) {
            try {
                LOG.error((Object)"Got Exception while initializing Bootstrap Sources !!", (Throwable)sqlEx);
                if (conn != null) {
                    conn.rollback();
                }
                throw sqlEx;
            }
            catch (Throwable throwable) {
                DBHelper.close(stmt);
                throw throwable;
            }
        }
        DBHelper.close((Statement)stmt);
    }

    public void createBootStrapSourceDB(OracleTriggerMonitoredSourceInfo source) throws SQLException {
        this._bootstrapDao.createNewSrcTable((int)source.getSourceId());
    }

    public String getTableName(int srcId) throws SQLException {
        return this._bootstrapDao.getBootstrapConn().getSrcTableName(srcId);
    }

    public void start(long startSCN) {
        this._scn = startSCN;
    }

    public void startEvents() {
    }

    public boolean appendEvent(DbusEventKey key, short pPartitionId, short lPartitionId, long timeStamp, short srcId, byte[] schemaId, byte[] value, boolean enableTracing, DbusEventsStatisticsCollector statsCollector) {
        return this.appendEvent(key, this._scn, pPartitionId, lPartitionId, timeStamp, srcId, schemaId, value, enableTracing, statsCollector);
    }

    @Deprecated
    public boolean appendEvent(DbusEventKey key, short pPartitionId, short lPartitionId, long timeStamp, short srcId, byte[] schemaId, byte[] value, boolean enableTracing) {
        throw new RuntimeException("Not implemented!!!");
    }

    public boolean appendEvent(DbusEventKey key, DbusEventKey seederChunkKey, long sequenceId, short pPartitionId, short lPartitionId, long timeStamp, short srcId, byte[] schemaId, byte[] value, boolean enableTracing, DbusEventsStatisticsCollector statsCollector) {
        DbusEventInfo eventInfo = new DbusEventInfo(DbusOpcode.UPSERT, sequenceId, pPartitionId, lPartitionId, timeStamp, srcId, schemaId, value, enableTracing, false);
        return this.appendEvent(key, seederChunkKey, eventInfo, statsCollector);
    }

    public boolean appendEvent(DbusEventKey key, short pPartitionId, short lPartitionId, long timeStamp, short srcId, byte[] schemaId, byte[] value, boolean enableTracing, boolean isReplicated, DbusEventsStatisticsCollector statsCollector) {
        throw new RuntimeException("This API not expected to be called on BootstrapDBSeeder !!");
    }

    public boolean appendEvent(DbusEventKey key, DbusEventKey seederChunkKey, DbusEventInfo eventInfo, DbusEventsStatisticsCollector statsCollector) {
        boolean isDebugEnabled = LOG.isDebugEnabled();
        boolean ret = false;
        PreparedStatement stmt = null;
        if (this._startSCN == -1L) {
            this._startSCN = eventInfo.getSequenceId();
        }
        short srcId = eventInfo.getSrcId();
        long sequenceId = eventInfo.getSequenceId();
        try {
            this._lastSeenKey = seederChunkKey.getKeyType() == DbusEventKey.KeyType.LONG ? "" + seederChunkKey.getLongKey() : seederChunkKey.getStringKey();
            if (isDebugEnabled) {
                LOG.debug((Object)("Seeder Chunk Key is: " + seederChunkKey + ",EventInfo :" + eventInfo + ", Key is :" + key));
            }
            eventInfo.setOpCode(null);
            eventInfo.setAutocommit(true);
            if (eventInfo.getValueLength() >= 50000000) {
                LOG.fatal((Object)("Event Size larger than 50 MB. For Key :" + key + ", avro record size is : " + eventInfo.getValueLength()));
            }
            DbusEventFactory.serializeEvent((DbusEventKey)key, (ByteBuffer)this._buf, (DbusEventInfo)eventInfo);
            long end = System.nanoTime();
            stmt = this._statementMap.get(srcId);
            if (null == stmt) {
                stmt = this.prepareInsertStatement(srcId);
                this._statementMap.put(srcId, stmt);
            }
            if (isDebugEnabled) {
                LOG.debug((Object)("Number of Bytes in serialized format:" + this._buf.position()));
                LOG.debug((Object)("Key is :" + (key.getKeyType() == DbusEventKey.KeyType.LONG ? key.getLongKey() : key.getStringKey())));
            }
            stmt.setLong(1, sequenceId);
            String keyStr = null;
            keyStr = key.getKeyType() == DbusEventKey.KeyType.LONG ? key.getLongKey().toString() : key.getStringKey();
            stmt.setString(2, keyStr);
            this._bufStream.reset();
            stmt.setBlob(3, this._bufStream, this._buf.position());
            stmt.setLong(4, sequenceId);
            this._bufStream2.reset();
            stmt.setBlob(5, this._bufStream2, this._buf.position());
            stmt.executeUpdate();
            long end2 = System.nanoTime();
            this._totLatency += end2 - end;
            this._currSrcId = srcId;
            ret = true;
        }
        catch (SQLException sqlEx) {
            LOG.error((Object)("Error occured while inserting record for key:" + key.getStringKey() + "(" + key.getLongKey() + ") with sequenceId:" + sequenceId), (Throwable)sqlEx);
            throw new RuntimeException(sqlEx);
        }
        catch (KeyTypeNotImplementedException ex) {
            LOG.error((Object)("KeyNotImplemented error while inserting record for key:" + key.getStringKey() + "(" + key.getLongKey() + ") with sequenceId:" + sequenceId), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        finally {
            this._buf.clear();
        }
        return ret;
    }

    public void rollbackEvents() {
        Connection conn = this.getConnection();
        try {
            LOG.error((Object)"Rolling back uncommitted bootstrap events");
            conn.rollback();
        }
        catch (SQLException e) {
            LOG.error((Object)"Unable to rollback while seeding bootstrap.", (Throwable)e);
        }
    }

    public void endEvents(boolean updateWindowScn, long windowScn, boolean updateIndex, boolean callListener, DbusEventsStatisticsCollector statsCollector) {
    }

    public void endSource(long scn) {
        String seederSql = "update bootstrap_seeder_state set endscn = ? where srcid = ? ";
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(seederSql);
            stmt.setLong(1, scn);
            stmt.setInt(2, this._currSrcId);
            stmt.executeUpdate();
            conn.commit();
        }
        catch (SQLException sqlEx) {
            try {
                throw new RuntimeException(sqlEx);
            }
            catch (Throwable throwable) {
                DBHelper.close(stmt);
                throw throwable;
            }
        }
        DBHelper.close((Statement)stmt);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endSeeding() {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        long minScn = -1L;
        try {
            String sql = this.getMinSCNSeederQuery();
            conn = this.getConnection();
            stmt = conn.createStatement();
            LOG.info((Object)("Executing Min startSCN Query in Bootstrap DB:" + sql));
            rs = stmt.executeQuery(sql);
            rs.next();
            minScn = rs.getLong(1);
            LOG.info((Object)("Minimum startSCN of all the sources which were seeded was :" + minScn));
            this.updateBootstrapStateTable(minScn, "bootstrap_applier_state");
            this.updateBootstrapStateTable(minScn, "bootstrap_producer_state");
            this.createLogTableRows();
            this.setBootstrapSourceStatus(3);
            conn.commit();
        }
        catch (SQLException sqlEx) {
            try {
                LOG.error((Object)"Got Exception while updating bootstrap state tables", (Throwable)sqlEx);
                try {
                    conn.rollback();
                    throw new RuntimeException(sqlEx);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while rolling back ...", (Throwable)ex);
                }
                throw new RuntimeException(sqlEx);
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable throwable) {
                DBHelper.close(rs, stmt, null);
                throw throwable;
            }
        }
        DBHelper.close((ResultSet)rs, (Statement)stmt, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBootstrapStateTable(long scn, String table) throws SQLException {
        String upsertSQL = this.getBootstrapStateInsertStmt(table);
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(upsertSQL);
            for (OracleTriggerMonitoredSourceInfo srcInfo : this._sources) {
                stmt.setInt(1, srcInfo.getSourceId());
                stmt.setInt(2, 0);
                stmt.setLong(3, scn);
                stmt.setLong(4, 0L);
                stmt.setInt(5, 0);
                stmt.setLong(6, scn);
                stmt.setLong(7, 0L);
                stmt.executeUpdate();
            }
        }
        catch (Throwable throwable) {
            DBHelper.close(stmt);
            throw throwable;
        }
        DBHelper.close((Statement)stmt);
    }

    private void createLogTableRows() throws SQLException {
        String sql = "insert into bootstrap_loginfo (srcid, logid, minwindowscn, maxwindowscn, maxrid) values ( ?, 0, -1, -1, 0)";
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            for (OracleTriggerMonitoredSourceInfo srcInfo : this._sources) {
                try {
                    stmt.setInt(1, srcInfo.getSourceId());
                    stmt.executeUpdate();
                    this._bootstrapDao.createNewLogTable((int)srcInfo.getSourceId());
                }
                catch (SQLException sqlEx) {
                    LOG.error((Object)"Got Error inserting entry into bootstrap_loginfo but proceeding !!", (Throwable)sqlEx);
                }
            }
        }
        catch (SQLException sqlEx) {
            try {
                LOG.error((Object)"Got Error inserting entry into bootstrap_loginfo !!", (Throwable)sqlEx);
                throw sqlEx;
            }
            catch (Throwable throwable) {
                DBHelper.close(stmt);
                throw throwable;
            }
        }
        DBHelper.close((Statement)stmt);
    }

    private String getBootstrapStateInsertStmt(String table) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(table);
        sql.append(" (srcid, logid, windowscn, rid) values ( ?, ?, ?, ?) ");
        sql.append(" on duplicate key update logid = ?, windowscn = ?, rid = ?");
        return sql.toString();
    }

    private String getMinSCNSeederQuery() {
        StringBuilder buf = new StringBuilder();
        buf.append("select min(startscn) from bootstrap_seeder_state where srcid IN (");
        for (int i = 0; i < this._sources.size() - 1; ++i) {
            buf.append(this._sources.get(i).getSourceId()).append(", ");
        }
        buf.append(this._sources.get(this._sources.size() - 1).getSourceId());
        buf.append(")");
        return buf.toString();
    }

    public void endEvents(long rowId, DbusEventsStatisticsCollector statsCollector) {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("insert into bootstrap_seeder_state ");
            sql.append("values ( ?, ?, -1, ?, ?)");
            sql.append("on duplicate key update rid = ?, srckey = ?");
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql.toString());
            stmt.setInt(1, this._currSrcId);
            stmt.setLong(2, this._startSCN);
            stmt.setLong(3, rowId);
            stmt.setString(4, this._lastSeenKey);
            stmt.setLong(5, rowId);
            stmt.setString(6, this._lastSeenKey);
            LOG.info((Object)("\t Total Latency before commit :" + this._totLatency / 1000000000L));
            stmt.executeUpdate();
            long start = System.nanoTime();
            conn.commit();
            long end = System.nanoTime();
            long lat = (end - start) / 1000000L;
            LOG.info((Object)("\t Comit time (msec) :" + lat));
        }
        catch (Exception e) {
            try {
                LOG.fatal((Object)"Got Exception in endEvents !!", (Throwable)e);
                throw new RuntimeException("Got Exception in endEvents !!", e);
            }
            catch (Throwable throwable) {
                DBHelper.close(stmt);
                throw throwable;
            }
        }
        DBHelper.close((Statement)stmt);
    }

    public boolean empty() {
        return false;
    }

    public int readEvents(ReadableByteChannel readChannel, Iterable<InternalDatabusEventsListener> eventListeners, DbusEventsStatisticsCollector statsCollector) throws InvalidEventException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRowIdFromCheckpoint(OracleTriggerMonitoredSourceInfo sourceInfo) {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet row = null;
        long rowId = -1L;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("select rid from bootstrap_seeder_state ");
            sql.append("where srcid = ?");
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql.toString());
            stmt.setInt(1, sourceInfo.getSourceId());
            row = stmt.executeQuery();
            if (row.next()) {
                rowId = row.getLong(1);
            }
            DBHelper.close((ResultSet)row, (Statement)stmt, null);
        }
        catch (Exception e) {
            LOG.error((Object)"Got exception while trying to fetch the rowid from bootstrap_seeder_state !!", (Throwable)e);
        }
        finally {
            DBHelper.close(row, stmt, null);
        }
        return rowId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String geSrcKeyFromCheckpoint(OracleTriggerMonitoredSourceInfo sourceInfo) {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet row = null;
        String srcKey = null;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("select srckey from bootstrap_seeder_state ");
            sql.append("where srcid = ?");
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql.toString());
            stmt.setInt(1, sourceInfo.getSourceId());
            row = stmt.executeQuery();
            if (row.next()) {
                srcKey = row.getString(1);
            }
            DBHelper.close((ResultSet)row, (Statement)stmt, null);
        }
        catch (Exception e) {
            LOG.error((Object)"Got exception while trying to fetch the srckey from bootstrap_seeder_state !!", (Throwable)e);
        }
        finally {
            DBHelper.close(row, stmt, null);
        }
        return srcKey;
    }

    public long getMinScn() {
        return 0L;
    }

    public long lastWrittenScn() {
        return 0L;
    }

    public void setStartSCN(long sinceSCN) {
    }

    public long getPrevScn() {
        return 0L;
    }

    public boolean appendEvent(DbusEventKey key, long sequenceId, short pPartitionId, short lPartitionId, long timeStamp, short srcId, byte[] schemaId, byte[] value, boolean enableTracing, DbusEventsStatisticsCollector statsCollector) {
        return false;
    }

    public boolean appendEvent(DbusEventKey key, DbusEventInfo eventInfo, DbusEventsStatisticsCollector statsCollector) {
        return false;
    }
}

