/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.utils;

import com.linkedin.databus.bootstrap.common.BootstrapConfig;
import com.linkedin.databus.bootstrap.common.BootstrapConn;
import com.linkedin.databus.bootstrap.common.BootstrapDBMetaDataDAO;
import com.linkedin.databus.bootstrap.common.BootstrapReadOnlyConfig;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.ConfigLoader;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.container.netty.ServerContainer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.log4j.Logger;

public class BootstrapDbControlMain {
    public static final Logger LOG = Logger.getLogger((String)BootstrapDbControlMain.class.getName());
    public static final String ACTION_OPTION_NAME = "action";
    public static final char ACTION_OPTION_CHAR = 'a';
    public static final String SRCID_OPTION_NAME = "srcid";
    public static final char SRCID_OPTION_CHAR = 'S';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws IOException, DatabusException, InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        Cli cli = new Cli("java " + BootstrapDbControlMain.class.getSimpleName() + " [options]");
        cli.processCommandLineArgs(args);
        Properties cfgProps = cli.getConfigProps();
        BootstrapConfig cfgBuilder = new BootstrapConfig();
        ConfigLoader configLoad = new ConfigLoader("databus.bootstrap.", (ConfigBuilder)cfgBuilder);
        configLoad.loadConfig((Map)cfgProps);
        BootstrapReadOnlyConfig cfg = cfgBuilder.build();
        BootstrapConn conn = new BootstrapConn();
        try {
            conn.initBootstrapConn(true, cfg.getBootstrapDBUsername(), cfg.getBootstrapDBPassword(), cfg.getBootstrapDBHostname(), cfg.getBootstrapDBName());
            BootstrapDBMetaDataDAO dao = new BootstrapDBMetaDataDAO(conn, cfg.getBootstrapDBHostname(), cfg.getBootstrapDBUsername(), cfg.getBootstrapDBPassword(), cfg.getBootstrapDBName(), false);
            switch (cli.getAction()) {
                case CREATE_LOG_TABLE: {
                    dao.createNewLogTable(cli.getSrcId().intValue());
                    return;
                }
                case CREATE_TAB_TABLE: {
                    dao.createNewSrcTable(cli.getSrcId().intValue());
                    return;
                }
                default: {
                    throw new RuntimeException("unknown action: " + (Object)((Object)cli.getAction()));
                }
            }
        }
        finally {
            conn.close();
        }
    }

    public static class Cli
    extends ServerContainer.Cli {
        private Action _action = null;
        private Integer _srcId = null;

        public Cli() {
        }

        public Cli(String usage) {
            super(usage);
        }

        public void processCommandLineArgs(String[] cliArgs) throws IOException, DatabusException {
            super.processCommandLineArgs(cliArgs);
            CommandLine cmdLine = this.getCmdLine();
            if (!cmdLine.hasOption('a')) {
                throw new DatabusException("action expected; see --help for usage");
            }
            String actionString = cmdLine.getOptionValue('a').toUpperCase();
            try {
                this._action = Action.valueOf(actionString);
            }
            catch (IllegalArgumentException e) {
                throw new DatabusException("invalid action: " + actionString);
            }
            if (this._action.equals((Object)Action.CREATE_LOG_TABLE) || this._action.equals((Object)Action.CREATE_TAB_TABLE)) {
                if (!cmdLine.hasOption('S')) {
                    throw new DatabusException("srcid expected; see --help for usage");
                }
                String srcidString = cmdLine.getOptionValue('S');
                try {
                    this._srcId = Integer.parseInt(srcidString);
                }
                catch (NumberFormatException e) {
                    throw new DatabusException("invalid srcid: " + srcidString);
                }
            }
        }

        protected void constructCommandLineOptions() {
            super.constructCommandLineOptions();
            OptionBuilder.withArgName((String)BootstrapDbControlMain.ACTION_OPTION_NAME);
            OptionBuilder.hasArg();
            OptionBuilder.withLongOpt((String)BootstrapDbControlMain.ACTION_OPTION_NAME);
            OptionBuilder.withDescription((String)("action:" + Action.generateActionList()));
            Option actionOption = OptionBuilder.create((char)'a');
            OptionBuilder.withArgName((String)BootstrapDbControlMain.SRCID_OPTION_NAME);
            OptionBuilder.hasArg();
            OptionBuilder.withLongOpt((String)BootstrapDbControlMain.SRCID_OPTION_NAME);
            OptionBuilder.withDescription((String)"action:");
            Option srcidOption = OptionBuilder.create((char)'S');
            this._cliOptions.addOption(actionOption);
            this._cliOptions.addOption(srcidOption);
        }

        public Action getAction() {
            return this._action;
        }

        public Integer getSrcId() {
            return this._srcId;
        }
    }

    public static enum Action {
        CREATE_LOG_TABLE,
        CREATE_TAB_TABLE;


        public static String generateActionList() {
            return Arrays.toString((Object[])new Action[]{CREATE_LOG_TABLE, CREATE_TAB_TABLE});
        }
    }
}

