/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.utils;

import com.linkedin.databus.bootstrap.common.BootstrapConfig;
import com.linkedin.databus.bootstrap.common.BootstrapConn;
import com.linkedin.databus.bootstrap.common.BootstrapDBMetaDataDAO;
import com.linkedin.databus.bootstrap.common.BootstrapReadOnlyConfig;
import com.linkedin.databus.bootstrap.utils.BootstrapDBCleanerMain;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.ConfigLoader;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;

public class BootstrapDropSource {
    public static final String MODULE = BootstrapDropSource.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String HELP_OPT_LONG_NAME = "help";
    public static final char HELP_OPT_CHAR = 'h';
    public static final String BOOTSTRAP_DB_PROPS_OPT_LONG_NAME = "bootstrap_db_props";
    public static final char BOOTSTRAP_DB_PROP_OPT_CHAR = 'p';
    public static final String CMD_LINE_PROPS_OPT_LONG_NAME = "cmdline_props";
    public static final char CMD_LINE_PROPS_OPT_CHAR = 'c';
    public static final String LOG4J_PROPS_OPT_LONG_NAME = "log_props";
    public static final char LOG4J_PROPS_OPT_CHAR = 'l';
    public static final String SOURCE_ID_OPT_LONG_NAME = "source_id";
    public static final char SOURCE_ID_OPT_CHAR = 's';
    private static Properties _sBootstrapConfigProps = null;
    private int _srcId = 0;
    private BootstrapDBMetaDataDAO _dbDao = null;
    private BootstrapReadOnlyConfig _config = null;

    public BootstrapDropSource(BootstrapReadOnlyConfig config, int srcId) {
        this._srcId = srcId;
        this._config = config;
    }

    public Connection getConnection() {
        Connection conn = null;
        if (this._dbDao == null) {
            LOG.info((Object)"<<<< Creating Bootstrap Connection!! >>>>");
            BootstrapConn dbConn = new BootstrapConn();
            try {
                dbConn.initBootstrapConn(false, this._config.getBootstrapDBUsername(), this._config.getBootstrapDBPassword(), this._config.getBootstrapDBHostname(), this._config.getBootstrapDBName());
                this._dbDao = new BootstrapDBMetaDataDAO(dbConn, this._config.getBootstrapDBHostname(), this._config.getBootstrapDBUsername(), this._config.getBootstrapDBPassword(), this._config.getBootstrapDBName(), false);
            }
            catch (Exception e) {
                LOG.fatal((Object)"Unable to open BootstrapDB Connection !!", (Throwable)e);
                throw new RuntimeException("Got exception when getting bootstrap DB Connection.", e);
            }
        }
        try {
            conn = this._dbDao.getBootstrapConn().getDBConn();
        }
        catch (SQLException e) {
            LOG.fatal((Object)"Not able to open BootstrapDB Connection !!", (Throwable)e);
            throw new RuntimeException("Got exception when getting bootstrap DB Connection.", e);
        }
        return conn;
    }

    public static void main(String[] args) throws Exception {
        int srcId = BootstrapDropSource.parseArgs(args);
        BootstrapConfig config = new BootstrapConfig();
        ConfigLoader configLoader = new ConfigLoader("bootstrap.", (ConfigBuilder)config);
        BootstrapReadOnlyConfig staticConfig = (BootstrapReadOnlyConfig)configLoader.loadConfig((Map)_sBootstrapConfigProps);
        BootstrapDropSource cleaner = new BootstrapDropSource(staticConfig, srcId);
        cleaner.cleanup();
    }

    public void cleanup() throws Exception {
        this.getConnection();
        this._dbDao.dropSourceInDB(this._srcId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int parseArgs(String[] args) throws IOException {
        GnuParser cliParser = new GnuParser();
        OptionBuilder.withLongOpt((String)HELP_OPT_LONG_NAME);
        OptionBuilder.withDescription((String)"Help screen");
        Option helpOption = OptionBuilder.create((char)'h');
        OptionBuilder.withLongOpt((String)SOURCE_ID_OPT_LONG_NAME);
        OptionBuilder.withDescription((String)"Source ID for which tables need to be dropped");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"Source ID");
        Option sourceIdOption = OptionBuilder.create((char)'s');
        OptionBuilder.withLongOpt((String)BOOTSTRAP_DB_PROPS_OPT_LONG_NAME);
        OptionBuilder.withDescription((String)"Bootstrap producer properties to use");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"property_file");
        Option dbOption = OptionBuilder.create((char)'p');
        OptionBuilder.withLongOpt((String)CMD_LINE_PROPS_OPT_LONG_NAME);
        OptionBuilder.withDescription((String)"Cmd line override of config properties. Semicolon separated.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"Semicolon_separated_properties");
        Option cmdLinePropsOption = OptionBuilder.create((char)'c');
        OptionBuilder.withLongOpt((String)LOG4J_PROPS_OPT_LONG_NAME);
        OptionBuilder.withDescription((String)"Log4j properties to use");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"property_file");
        Option log4jPropsOption = OptionBuilder.create((char)'l');
        Options options = new Options();
        options.addOption(helpOption);
        options.addOption(sourceIdOption);
        options.addOption(dbOption);
        options.addOption(cmdLinePropsOption);
        options.addOption(log4jPropsOption);
        CommandLine cmd = null;
        try {
            cmd = cliParser.parse(options, args);
        }
        catch (ParseException pe) {
            LOG.error((Object)"Bootstrap Physical Config: failed to parse command-line options.", (Throwable)pe);
            throw new RuntimeException("Bootstrap Physical Config: failed to parse command-line options.", pe);
        }
        if (cmd.hasOption('l')) {
            String log4jPropFile = cmd.getOptionValue('l');
            PropertyConfigurator.configure((String)log4jPropFile);
            LOG.info((Object)("Using custom logging settings from file " + log4jPropFile));
        } else {
            PatternLayout defaultLayout = new PatternLayout("%d{ISO8601} +%r [%t] (%p) {%c} %m%n");
            ConsoleAppender defaultAppender = new ConsoleAppender((Layout)defaultLayout);
            Logger.getRootLogger().removeAllAppenders();
            Logger.getRootLogger().addAppender((Appender)defaultAppender);
            LOG.info((Object)"Using default logging settings");
        }
        if (cmd.hasOption('h')) {
            BootstrapDropSource.printCliHelp(options);
            System.exit(0);
        }
        if (!cmd.hasOption('s')) {
            throw new RuntimeException("Source ID is not provided");
        }
        if (!cmd.hasOption('p')) {
            throw new RuntimeException("Bootstrap config is not provided");
        }
        String propFile = cmd.getOptionValue('p');
        LOG.info((Object)("Loading bootstrap DB config from properties file " + propFile));
        _sBootstrapConfigProps = new Properties();
        FileInputStream f = new FileInputStream(propFile);
        try {
            _sBootstrapConfigProps.load(f);
        }
        finally {
            f.close();
        }
        if (cmd.hasOption('c')) {
            String cmdLinePropString = cmd.getOptionValue('c');
            BootstrapDropSource.updatePropsFromCmdLine(_sBootstrapConfigProps, cmdLinePropString);
        }
        return Integer.parseInt(cmd.getOptionValue('s'));
    }

    private static void updatePropsFromCmdLine(Properties props, String cmdLinePropString) {
        String[] cmdLinePropSplit;
        for (String s : cmdLinePropSplit = cmdLinePropString.split(";")) {
            String[] onePropSplit = s.split("=");
            if (onePropSplit.length != 2) {
                LOG.error((Object)("CMD line property setting " + s + "is not valid!"));
                continue;
            }
            LOG.info((Object)("CMD line Property overwride: " + s));
            props.put(onePropSplit[0], onePropSplit[1]);
        }
    }

    private static void printCliHelp(Options cliOptions) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("java " + BootstrapDBCleanerMain.class.getName(), cliOptions);
    }
}

