/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.utils;

import com.linkedin.databus.core.DbusEventBufferAppendable;
import com.linkedin.databus.core.DbusEventBufferStreamAppendable;
import com.linkedin.databus.core.DbusEventInfo;
import com.linkedin.databus.core.DbusEventKey;
import com.linkedin.databus.core.InternalDatabusEventsListener;
import com.linkedin.databus.core.InvalidEventException;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus.core.util.RateMonitor;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.log4j.Logger;

public class BootstrapEventBuffer
implements DbusEventBufferAppendable,
DbusEventBufferStreamAppendable {
    public static final String MODULE = BootstrapEventBuffer.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final int END_OF_FILE = -1;
    public static final int END_OF_SOURCE = -2;
    public static final int ERROR_CODE = -3;
    private BlockingQueue<EventBufferEntry> _buffer = null;
    private BlockingQueue<EventBufferEntry> _freePool = null;
    private volatile RateMonitor _freePoolTakeLatency = new RateMonitor("FreePoolTake");
    private volatile RateMonitor _freePoolPutLatency = new RateMonitor("FreePoolPut");
    private volatile RateMonitor _bufferTakeLatency = new RateMonitor("BufferTake");
    private volatile RateMonitor _bufferPutLatency = new RateMonitor("BufferPut");
    private volatile RateMonitor _handlerLatency = new RateMonitor("Handler");
    private volatile long _scn;
    private volatile EventBufferEntry _eofEntry;

    public BootstrapEventBuffer(int capacity) {
        this._buffer = new ArrayBlockingQueue<EventBufferEntry>(capacity);
        this._freePool = new ArrayBlockingQueue<EventBufferEntry>(capacity);
        this._eofEntry = new EventBufferEntry();
        this._eofEntry.setType(EventType.EVENT_EOF);
        for (int i = 0; i < capacity; ++i) {
            this._freePool.add(new EventBufferEntry());
        }
    }

    public void start(long startSCN) {
        this._scn = startSCN;
        this._freePoolTakeLatency.start();
        this._freePoolTakeLatency.suspend();
        this._freePoolPutLatency.start();
        this._freePoolPutLatency.suspend();
        this._bufferTakeLatency.start();
        this._bufferTakeLatency.suspend();
        this._bufferPutLatency.start();
        this._bufferPutLatency.suspend();
        this._handlerLatency.start();
        this._handlerLatency.suspend();
    }

    public void startEvents() {
    }

    public void logLatency() {
        LOG.info((Object)("_freePoolTakeLatency - Latency :" + this._freePoolTakeLatency.getDuration() / 1000000L));
        LOG.info((Object)("_freePoolPutLatency Latency :" + this._freePoolPutLatency.getDuration() / 1000000L));
        LOG.info((Object)("_bufferTakeLatency - Latency :" + this._bufferTakeLatency.getDuration() / 1000000L));
        LOG.info((Object)("_bufferPutLatency - Latency :" + this._bufferPutLatency.getDuration() / 1000000L));
        LOG.info((Object)("_handlerLatency - Latency :" + this._handlerLatency.getDuration() / 1000000L));
        LOG.info((Object)("Buffer SIZE:" + this._buffer.size()));
    }

    public boolean appendEvent(DbusEventKey key, long sequenceId, short pPartitionId, short lPartitionId, long timeStamp, short srcId, byte[] schemaId, byte[] value, boolean enableTracing, DbusEventsStatisticsCollector statsCollector) {
        throw new RuntimeException("Method not supported ||");
    }

    public boolean appendEvent(DbusEventKey key, short pPartitionId, short lPartitionId, long timeStamp, short srcId, byte[] schemaId, byte[] value, boolean enableTracing) {
        throw new RuntimeException("Method not supported ||");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSpecialEvent(EventType type, long rowId) throws InterruptedException {
        EventBufferEntry entry = null;
        try {
            this._freePoolTakeLatency.resume();
            entry = this._freePool.take();
        }
        finally {
            this._freePoolTakeLatency.suspend();
        }
        entry.setType(type);
        entry.setTimeStamp(rowId);
        try {
            this._bufferPutLatency.resume();
            this._buffer.put(entry);
        }
        finally {
            this._bufferPutLatency.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readNextEvent(EventProcessor processor) {
        EventBufferEntry entry = null;
        try {
            this._bufferTakeLatency.resume();
            entry = this._buffer.take();
        }
        catch (InterruptedException ie) {
            LOG.error((Object)"Got interrupted while waiting for next event !!", (Throwable)ie);
            processor.process(this._eofEntry, this._scn);
            boolean bl = false;
            return bl;
        }
        finally {
            this._bufferTakeLatency.suspend();
        }
        boolean success = false;
        try {
            this._handlerLatency.resume();
            success = processor.process(entry, this._scn);
        }
        finally {
            this._handlerLatency.suspend();
        }
        try {
            this._freePoolPutLatency.resume();
            this._freePool.put(entry);
        }
        catch (InterruptedException ie) {
            LOG.error((Object)"Got interrupted while waiting for returning to free pool !!", (Throwable)ie);
            processor.process(this._eofEntry, this._scn);
        }
        finally {
            this._freePoolPutLatency.suspend();
        }
        return success;
    }

    public boolean appendEvent(DbusEventKey key, DbusEventKey seederChunkKey, short pPartitionId, short lPartitionId, long timeStamp, short srcId, byte[] schemaId, byte[] value, boolean enableTracing, boolean isReplicated, DbusEventsStatisticsCollector statsCollector) {
        DbusEventInfo eventInfo = new DbusEventInfo(null, 0L, pPartitionId, lPartitionId, timeStamp, srcId, schemaId, value, enableTracing, false);
        eventInfo.setReplicated(isReplicated);
        return this.appendEvent(key, seederChunkKey, eventInfo, statsCollector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean appendEvent(DbusEventKey key, DbusEventKey seederChunkKey, DbusEventInfo eventInfo, DbusEventsStatisticsCollector statsCollector) {
        EventBufferEntry entry = null;
        try {
            this._freePoolTakeLatency.resume();
            entry = this._freePool.take();
        }
        catch (InterruptedException ie) {
            LOG.error((Object)"Got interrupted while waiting for free pool !!", (Throwable)ie);
            try {
                this.addSpecialEvent(EventType.EVENT_EOF, 0L);
            }
            catch (InterruptedException ie2) {
                // empty catch block
            }
            this._freePool.add(entry);
            boolean ie2 = false;
            return ie2;
        }
        finally {
            this._freePoolTakeLatency.suspend();
        }
        entry.reset(key, seederChunkKey, eventInfo.getpPartitionId(), eventInfo.getlPartitionId(), eventInfo.getTimeStampInNanos(), eventInfo.getSrcId(), eventInfo.getSchemaId(), eventInfo.getValueBytes(), eventInfo.isEnableTracing(), eventInfo.isReplicated(), statsCollector);
        try {
            this._bufferPutLatency.resume();
            this._buffer.put(entry);
        }
        catch (InterruptedException ie) {
            LOG.error((Object)"Got interrupted while putting to busy pool !!", (Throwable)ie);
            try {
                this.addSpecialEvent(EventType.EVENT_EOF, 0L);
            }
            catch (InterruptedException ie2) {
                // empty catch block
            }
            this._freePool.add(entry);
            boolean bl = false;
            return bl;
        }
        finally {
            this._bufferPutLatency.suspend();
        }
        return true;
    }

    public void rollbackEvents() {
    }

    public void endEvents(boolean updateWindowScn, long sequence, boolean updateIndex, boolean callListener, DbusEventsStatisticsCollector statsCollector) {
    }

    public void endEvents(long rowId, long scn, DbusEventsStatisticsCollector statsCollector) {
        block8: {
            try {
                if (rowId >= 0L) {
                    this.addSpecialEvent(EventType.EVENT_EOP, rowId);
                    LOG.info((Object)("Adding EOP Event : " + rowId));
                    break block8;
                }
                if (-1L == rowId) {
                    this.addSpecialEvent(EventType.EVENT_EOF, scn);
                    break block8;
                }
                if (-2L == rowId) {
                    this.addSpecialEvent(EventType.EVENT_EOS, scn);
                    break block8;
                }
                if (-3L == rowId) {
                    this.addSpecialEvent(EventType.EVENT_ERROR, scn);
                    break block8;
                }
                throw new RuntimeException("Unknown rowId :" + rowId);
            }
            catch (InterruptedException ie) {
                try {
                    this.addSpecialEvent(EventType.EVENT_EOF, rowId);
                }
                catch (InterruptedException ie2) {
                    // empty catch block
                }
            }
        }
    }

    public boolean empty() {
        return this._buffer.size() == 0;
    }

    public int readEvents(ReadableByteChannel readChannel, Iterable<InternalDatabusEventsListener> eventListeners, DbusEventsStatisticsCollector statsCollector) throws InvalidEventException {
        return 0;
    }

    public long getMinScn() {
        return 0L;
    }

    public long lastWrittenScn() {
        return 0L;
    }

    public void setStartSCN(long sinceSCN) {
    }

    public long getPrevScn() {
        return 0L;
    }

    public void endEvents(long sequence, DbusEventsStatisticsCollector statsCollector) {
    }

    public boolean appendEvent(DbusEventKey key, short pPartitionId, short lPartitionId, long timeStamp, short srcId, byte[] schemaId, byte[] value, boolean enableTracing, DbusEventsStatisticsCollector statsCollector) {
        return false;
    }

    public boolean appendEvent(DbusEventKey key, DbusEventInfo eventInfo, DbusEventsStatisticsCollector statsCollector) {
        return false;
    }

    public boolean appendEvent(DbusEventKey key, short pPartitionId, short lPartitionId, long timeStamp, short srcId, byte[] schemaId, byte[] value, boolean enableTracing, boolean isReplicated, DbusEventsStatisticsCollector statsCollector) {
        return false;
    }

    public static class EventBufferEntry {
        private EventType type;
        private DbusEventKey key;
        private DbusEventKey seederChunkKey;
        private short pPartitionId;
        private short lPartitionId;
        private long timeStamp;
        private short srcId;
        private byte[] schemaId;
        private byte[] value;
        private boolean enableTracing;
        private DbusEventsStatisticsCollector statsCollector;
        private boolean isReplicated;

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        public EventType getType() {
            return this.type;
        }

        public void setType(EventType type) {
            this.type = type;
        }

        public DbusEventKey getKey() {
            return this.key;
        }

        public short getLogicalPartitionId() {
            return this.lPartitionId;
        }

        public short getPhysicalPartitionId() {
            return this.pPartitionId;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public short getSrcId() {
            return this.srcId;
        }

        public byte[] getSchemaId() {
            return this.schemaId;
        }

        public byte[] getValue() {
            return this.value;
        }

        public boolean isEnableTracing() {
            return this.enableTracing;
        }

        public boolean isReplicated() {
            return this.isReplicated;
        }

        public DbusEventsStatisticsCollector getStatsCollector() {
            return this.statsCollector;
        }

        public DbusEventKey getSeederChunkKey() {
            return this.seederChunkKey;
        }

        public void setSeederChunkKey(DbusEventKey seederChunkKey) {
            this.seederChunkKey = seederChunkKey;
        }

        public void reset(DbusEventKey key, DbusEventKey seederChunkKey, short pPartitionId, short lPartitionId, long timeStamp, short srcId, byte[] schemaId, byte[] value, boolean enableTracing, boolean isReplicated, DbusEventsStatisticsCollector statsCollector) {
            this.type = EventType.EVENT_VALID;
            this.key = key;
            this.seederChunkKey = seederChunkKey;
            this.lPartitionId = lPartitionId;
            this.pPartitionId = pPartitionId;
            this.timeStamp = timeStamp;
            this.srcId = srcId;
            this.schemaId = schemaId;
            this.value = value;
            this.enableTracing = enableTracing;
            this.isReplicated = isReplicated;
            this.statsCollector = statsCollector;
        }

        public String toString() {
            return "EventBufferEntry [type=" + (Object)((Object)this.type) + ", key=" + this.key + ", seederChunkKey=" + this.seederChunkKey + ", pPartitionId=" + this.pPartitionId + ", lPartitionId=" + this.lPartitionId + ", timeStamp=" + this.timeStamp + ", srcId=" + this.srcId + ", schemaId=" + Arrays.toString(this.schemaId) + ", value=" + Arrays.toString(this.value) + ", enableTracing=" + this.enableTracing + ", statsCollector=" + this.statsCollector + ", isReplicated=" + this.isReplicated + "]";
        }
    }

    public static interface EventProcessor {
        public boolean process(EventBufferEntry var1, long var2);
    }

    public static enum EventType {
        EVENT_VALID,
        EVENT_EOF,
        EVENT_EOP,
        EVENT_EOS,
        EVENT_ERROR;

    }
}

