/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.utils;

import com.linkedin.databus.bootstrap.common.BootstrapConfig;
import com.linkedin.databus.bootstrap.common.BootstrapReadOnlyConfig;
import com.linkedin.databus.bootstrap.utils.BootstrapDBSeeder;
import com.linkedin.databus.bootstrap.utils.BootstrapEventBuffer;
import com.linkedin.databus.bootstrap.utils.BootstrapSeederOracleEventProducerFactory;
import com.linkedin.databus.bootstrap.utils.BootstrapSeederWriterThread;
import com.linkedin.databus.bootstrap.utils.BootstrapSrcDBEventReader;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.ConfigLoader;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.producers.db.OracleTriggerMonitoredSourceInfo;
import com.linkedin.databus2.relay.OracleJarUtils;
import com.linkedin.databus2.relay.config.LogicalSourceConfig;
import com.linkedin.databus2.relay.config.PhysicalSourceConfig;
import com.linkedin.databus2.relay.config.ReplicationBitSetterStaticConfig;
import com.linkedin.databus2.schemas.FileSystemSchemaRegistryService;
import com.linkedin.databus2.schemas.SchemaRegistryConfigBuilder;
import com.linkedin.databus2.schemas.SchemaRegistryService;
import com.linkedin.databus2.schemas.SchemaRegistryStaticConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.codehaus.jackson.map.ObjectMapper;

public class BootstrapSeederMain {
    public static final String MODULE = BootstrapSeederMain.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String HELP_OPT_LONG_NAME = "help";
    public static final String BOOTSTRAP_DB_PROPS_OPT_LONG_NAME = "bootstrap_db_props";
    public static final String PHYSICAL_CONFIG_OPT_LONG_NAME = "physical_config";
    public static final String LOG4J_PROPS_OPT_LONG_NAME = "log_props";
    public static final String VALIDATION_TYPE_OPT_LONG_NAME = "validation-type";
    public static final String VALIDATION_SAMPLE_PCT_LONG_NAME = "validation-sample-pct";
    public static final char HELP_OPT_CHAR = 'h';
    public static final char BOOTSTRAP_DB_PROP_OPT_CHAR = 'p';
    public static final char PHYSICAL_CONFIG_OPT_CHAR = 'c';
    public static final char LOG4J_PROPS_OPT_CHAR = 'l';
    public static final char VALIDATION_TYPE_OPT_CHAR = 'v';
    public static final char VALIDATION_SAMPLE_PCT_CHAR = 's';
    private static Properties _sBootstrapConfigProps = null;
    private static String _sSourcesConfigFile = null;
    private static DataSource _sDataStore = null;
    private static StaticConfig _sStaticConfig = null;
    private static List<OracleTriggerMonitoredSourceInfo> _sources = null;
    private static BootstrapDBSeeder _sSeeder = null;
    private static BootstrapSrcDBEventReader _sReader = null;
    private static BootstrapSeederWriterThread _sWriterThread = null;
    private static BootstrapEventBuffer _sBootstrapBuffer = null;
    private static String _validationType = "normal";
    private static double _validationSamplePct = 100.0;

    public static BootstrapDBSeeder getSeeder() {
        return _sSeeder;
    }

    public static String getValidationType() {
        return _validationType;
    }

    public static double getValidationSamplePct() {
        return _validationSamplePct;
    }

    public static BootstrapSrcDBEventReader getReader() {
        return _sReader;
    }

    public static Properties getBootstrapConfigProps() {
        return _sBootstrapConfigProps;
    }

    public static String getSourcesConfigFile() {
        return _sSourcesConfigFile;
    }

    public static DataSource getDataStore() {
        return _sDataStore;
    }

    public static StaticConfig getStaticConfig() {
        return _sStaticConfig;
    }

    public static List<OracleTriggerMonitoredSourceInfo> getSources() {
        return _sources;
    }

    public static void main(String[] args) throws Exception {
        BootstrapSeederMain.init(args);
        _sSeeder.startSeeding();
        _sReader.start();
        _sWriterThread.start();
    }

    public static void init(String[] args) throws Exception {
        BootstrapSeederMain.parseArgs(args);
        File sourcesJson = new File(_sSourcesConfigFile);
        ObjectMapper mapper = new ObjectMapper();
        PhysicalSourceConfig physicalSourceConfig = (PhysicalSourceConfig)mapper.readValue(sourcesJson, PhysicalSourceConfig.class);
        physicalSourceConfig.checkForNulls();
        Config config = new Config();
        ConfigLoader configLoader = new ConfigLoader("databus.seed.", (ConfigBuilder)config);
        _sStaticConfig = (StaticConfig)configLoader.loadConfig((Map)_sBootstrapConfigProps);
        String uri = physicalSourceConfig.getUri();
        if (!uri.startsWith("jdbc:oracle")) {
            throw new InvalidConfigException("Invalid source URI (" + physicalSourceConfig.getUri() + "). Only jdbc:oracle: URIs are supported.");
        }
        String sourceTypeStr = physicalSourceConfig.getReplBitSetter().getSourceType();
        if (ReplicationBitSetterStaticConfig.SourceType.TOKEN.toString().equalsIgnoreCase(sourceTypeStr)) {
            throw new InvalidConfigException("Token Source-type for Replication bit setter config cannot be set for trigger-based Databus relay !!");
        }
        try {
            Class oracleDataSourceClass = OracleJarUtils.loadClass((String)"oracle.jdbc.pool.OracleDataSource");
            Object ods = oracleDataSourceClass.newInstance();
            Method setURLMethod = oracleDataSourceClass.getMethod("setURL", String.class);
            setURLMethod.invoke(ods, uri);
            _sDataStore = (DataSource)ods;
        }
        catch (Exception e) {
            String errMsg = "Error creating a data source object ";
            LOG.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        BootstrapSeederOracleEventProducerFactory factory = new BootstrapSeederOracleEventProducerFactory(_sStaticConfig.getController().getPKeyNameMap());
        _sources = new ArrayList<OracleTriggerMonitoredSourceInfo>();
        FileSystemSchemaRegistryService schemaRegistryService = FileSystemSchemaRegistryService.build((FileSystemSchemaRegistryService.StaticConfig)_sStaticConfig.getSchemaRegistry().getFileSystem());
        HashSet<String> seenUris = new HashSet<String>();
        for (LogicalSourceConfig sourceConfig : physicalSourceConfig.getSources()) {
            String srcUri = sourceConfig.getUri();
            if (seenUris.contains(srcUri)) {
                String msg = "Uri (" + srcUri + ") is used for more than one sources. Currently Bootstrap Seeder cannot support seeding sources with the same URI together. Please have them run seperately !!";
                LOG.fatal((Object)msg);
                throw new InvalidConfigException(msg);
            }
            seenUris.add(srcUri);
            OracleTriggerMonitoredSourceInfo source = factory.buildOracleMonitoredSourceInfo(sourceConfig.build(), physicalSourceConfig.build(), (SchemaRegistryService)schemaRegistryService);
            _sources.add(source);
        }
        _sSeeder = new BootstrapDBSeeder(_sStaticConfig.getBootstrap(), _sources);
        _sBootstrapBuffer = new BootstrapEventBuffer(_sStaticConfig.getController().getCommitInterval() * 2);
        _sWriterThread = new BootstrapSeederWriterThread(_sBootstrapBuffer, _sSeeder);
        _sReader = new BootstrapSrcDBEventReader(_sDataStore, _sBootstrapBuffer, _sStaticConfig.getController(), _sources, _sSeeder.getLastRows(), _sSeeder.getLastKeys(), 0L);
    }

    public static void parseArgs(String[] args) throws IOException {
        block15: {
            GnuParser cliParser = new GnuParser();
            OptionBuilder.withLongOpt((String)HELP_OPT_LONG_NAME);
            OptionBuilder.withDescription((String)"Help screen");
            Option helpOption = OptionBuilder.create((char)'h');
            OptionBuilder.withLongOpt((String)PHYSICAL_CONFIG_OPT_LONG_NAME);
            OptionBuilder.withDescription((String)"Bootstrap producer properties to use");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"property_file");
            Option sourcesOption = OptionBuilder.create((char)'c');
            OptionBuilder.withLongOpt((String)BOOTSTRAP_DB_PROPS_OPT_LONG_NAME);
            OptionBuilder.withDescription((String)"Bootstrap producer properties to use");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"property_file");
            Option dbOption = OptionBuilder.create((char)'p');
            OptionBuilder.withLongOpt((String)LOG4J_PROPS_OPT_LONG_NAME);
            OptionBuilder.withDescription((String)"Log4j properties to use");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"property_file");
            Option log4jPropsOption = OptionBuilder.create((char)'l');
            OptionBuilder.withLongOpt((String)VALIDATION_TYPE_OPT_LONG_NAME);
            OptionBuilder.withDescription((String)"Type of validation algorithm , normal[cmp two sorted streams of oracle and bootstrap db]  or point[entry in bootstrap checked in oracle]");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"validation_type");
            Option validationType = OptionBuilder.create((char)'v');
            OptionBuilder.withLongOpt((String)VALIDATION_SAMPLE_PCT_LONG_NAME);
            OptionBuilder.withDescription((String)"Validation sample pct ,0.0 to 100.00 [100.0]");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"validation_sample_pct");
            Option validationSamplePct = OptionBuilder.create((char)'s');
            Options options = new Options();
            options.addOption(helpOption);
            options.addOption(sourcesOption);
            options.addOption(dbOption);
            options.addOption(log4jPropsOption);
            options.addOption(validationType);
            options.addOption(validationSamplePct);
            CommandLine cmd = null;
            try {
                cmd = cliParser.parse(options, args);
            }
            catch (ParseException pe) {
                LOG.fatal((Object)"Bootstrap Physical Config: failed to parse command-line options.", (Throwable)pe);
                throw new RuntimeException("Bootstrap Physical Config: failed to parse command-line options.", pe);
            }
            if (cmd.hasOption('l')) {
                String log4jPropFile = cmd.getOptionValue('l');
                PropertyConfigurator.configure((String)log4jPropFile);
                LOG.info((Object)("Using custom logging settings from file " + log4jPropFile));
            } else {
                PatternLayout defaultLayout = new PatternLayout("%d{ISO8601} +%r [%t] (%p) {%c} %m%n");
                ConsoleAppender defaultAppender = new ConsoleAppender((Layout)defaultLayout);
                Logger.getRootLogger().removeAllAppenders();
                Logger.getRootLogger().addAppender((Appender)defaultAppender);
                Logger.getRootLogger().setLevel(Level.INFO);
                LOG.info((Object)("Using default logging settings. Log Level is :" + Logger.getRootLogger().getLevel()));
            }
            if (cmd.hasOption('h')) {
                BootstrapSeederMain.printCliHelp(options);
                System.exit(0);
            }
            if (!cmd.hasOption('c')) {
                throw new RuntimeException("Sources Config is not provided; use --help for usage");
            }
            if (!cmd.hasOption('p')) {
                throw new RuntimeException("Bootstrap config is not provided; use --help for usage");
            }
            _sSourcesConfigFile = cmd.getOptionValue('c');
            String propFile = cmd.getOptionValue('p');
            LOG.info((Object)("Loading bootstrap DB config from properties file " + propFile));
            _sBootstrapConfigProps = new Properties();
            _sBootstrapConfigProps.load(new FileInputStream(propFile));
            if (!cmd.hasOption('v')) {
                _validationType = "normal";
            } else {
                String vtype = cmd.getOptionValue('v');
                if (vtype.equals("point") || vtype.equals("normal") || vtype.equals("pointBs")) {
                    _validationType = vtype;
                } else {
                    throw new RuntimeException("Validation type has to be one of 'normal' or 'point' or 'pointBs'");
                }
            }
            if (cmd.hasOption('s')) {
                try {
                    _validationSamplePct = Double.parseDouble(cmd.getOptionValue('s'));
                    if (_validationSamplePct < 0.0 || _validationSamplePct > 100.0) {
                        throw new RuntimeException("Error in specifying: validation-sample-pctShould be between 0.0 and 100.0. It was " + _validationSamplePct);
                    }
                    break block15;
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Error in specifying: validation-sample-pct Exception:" + e);
                }
            }
            _validationSamplePct = 100.0;
        }
    }

    private static void printCliHelp(Options cliOptions) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("java " + BootstrapSeederMain.class.getName(), cliOptions);
    }

    public static class Config
    implements ConfigBuilder<StaticConfig> {
        private BootstrapSrcDBEventReader.Config _controller = new BootstrapSrcDBEventReader.Config();
        private SchemaRegistryConfigBuilder _schemaRegistry;
        private BootstrapConfig _bootstrap;
        private final Map<String, String> _checkpointPersistanceScript = new HashMap<String, String>();
        private static final String DEFAULT_SCRIPT = "";

        public Config() {
            try {
                this._bootstrap = new BootstrapConfig();
            }
            catch (IOException io) {
                LOG.error((Object)"Got exception while instantiating BootstrapConfig !!", (Throwable)io);
                throw new RuntimeException("Got exception while instantiating BootstrapConfig !!", io);
            }
            this._schemaRegistry = new SchemaRegistryConfigBuilder();
        }

        public StaticConfig build() throws InvalidConfigException {
            return new StaticConfig(this._controller.build(), this._schemaRegistry.build(), this._bootstrap.build(), this._checkpointPersistanceScript);
        }

        public SchemaRegistryConfigBuilder getSchemaRegistry() {
            return this._schemaRegistry;
        }

        public BootstrapConfig getBootstrap() {
            return this._bootstrap;
        }

        public BootstrapSrcDBEventReader.Config getController() {
            return this._controller;
        }

        public void setSchemaRegistry(SchemaRegistryConfigBuilder schemaRegistry) {
            this._schemaRegistry = schemaRegistry;
        }

        public void setBootstrap(BootstrapConfig bootstrap) {
            this._bootstrap = bootstrap;
        }

        public void setController(BootstrapSrcDBEventReader.Config controller) {
            this._controller = controller;
        }

        public void setCheckpointPersistanceScript(String source, String script) {
            this._checkpointPersistanceScript.put(source, script);
        }

        public String getCheckpointPersistanceScript(String source) {
            String script = this._checkpointPersistanceScript.get(source);
            if (null == script) {
                this._checkpointPersistanceScript.put(source, DEFAULT_SCRIPT);
                return DEFAULT_SCRIPT;
            }
            return script;
        }
    }

    public static class StaticConfig {
        private final BootstrapSrcDBEventReader.StaticConfig _controller;
        private final SchemaRegistryStaticConfig _schemaRegistry;
        private final BootstrapReadOnlyConfig _bootstrap;

        public SchemaRegistryStaticConfig getSchemaRegistry() {
            return this._schemaRegistry;
        }

        public BootstrapReadOnlyConfig getBootstrap() {
            return this._bootstrap;
        }

        public BootstrapSrcDBEventReader.StaticConfig getController() {
            return this._controller;
        }

        public StaticConfig(BootstrapSrcDBEventReader.StaticConfig controller, SchemaRegistryStaticConfig schemaRegistry, BootstrapReadOnlyConfig bootstrap, Map<String, String> checkpointPersistanceScript) {
            this._controller = controller;
            this._schemaRegistry = schemaRegistry;
            this._bootstrap = bootstrap;
        }
    }
}

