/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.utils;

import com.linkedin.databus.bootstrap.utils.BootstrapDBSeeder;
import com.linkedin.databus.bootstrap.utils.BootstrapEventBuffer;
import com.linkedin.databus.bootstrap.utils.DbusSeederBaseThread;
import com.linkedin.databus.core.util.RateMonitor;
import org.apache.log4j.Logger;

public class BootstrapSeederWriterThread
extends DbusSeederBaseThread
implements BootstrapEventBuffer.EventProcessor {
    private static final Logger LOG = Logger.getLogger(BootstrapSeederWriterThread.class);
    private static final boolean _sDebug = LOG.isDebugEnabled();
    private final BootstrapDBSeeder _seeder;
    private final BootstrapEventBuffer _buffer;
    private final RateMonitor _mySQLWriteLatency = new RateMonitor("mySQLWriteLatency");

    public BootstrapSeederWriterThread(BootstrapEventBuffer buffer, BootstrapDBSeeder seeder) {
        super("BootstrapSeederWriterThread");
        this._seeder = seeder;
        this._buffer = buffer;
        this._mySQLWriteLatency.start();
        this._mySQLWriteLatency.suspend();
    }

    @Override
    public boolean process(BootstrapEventBuffer.EventBufferEntry entry, long scn) {
        this._rate.tick();
        switch (entry.getType()) {
            case EVENT_VALID: {
                if (_sDebug) {
                    LOG.debug((Object)("Received a new record for writing with key :" + entry.getKey()));
                }
                this._mySQLWriteLatency.resume();
                this._seeder.appendEvent(entry.getKey(), entry.getSeederChunkKey(), scn, entry.getPhysicalPartitionId(), entry.getLogicalPartitionId(), entry.getTimeStamp(), entry.getSrcId(), entry.getSchemaId(), entry.getValue(), entry.isEnableTracing(), entry.getStatsCollector());
                this._mySQLWriteLatency.suspend();
                break;
            }
            case EVENT_EOP: {
                LOG.info((Object)"EOP received by the SeederWriterThread. ||");
                LOG.info((Object)("Writer Rate is :" + this._rate.getRate()));
                this._buffer.logLatency();
                LOG.info((Object)("MYSQL Writer Latency :" + this._mySQLWriteLatency.getDuration() / 1000000L));
                this._seeder.endEvents(entry.getTimeStamp(), null);
                break;
            }
            case EVENT_EOS: {
                LOG.info((Object)"EOS received by the SeederWriterThread. ||");
                LOG.info((Object)("Writer Rate is :" + this._rate.getRate()));
                this._buffer.logLatency();
                LOG.info((Object)("MYSQL Writer Latency :" + this._mySQLWriteLatency.getDuration() / 1000000L));
                this._seeder.endSource(scn);
                break;
            }
            case EVENT_EOF: {
                LOG.info((Object)"EOF received by the SeederWriterThread. Stopping !!");
                LOG.info((Object)("Writer Rate is :" + this._rate.getRate()));
                this._buffer.logLatency();
                LOG.info((Object)("MYSQL Writer Latency :" + this._mySQLWriteLatency.getDuration() / 1000000L));
                this._seeder.endSeeding();
                this._stop.set(true);
                break;
            }
            case EVENT_ERROR: {
                LOG.error((Object)"ERROR received by the SeederWriterThread. Stopping !!");
                LOG.info((Object)("Writer Rate is :" + this._rate.getRate()));
                this._buffer.logLatency();
                LOG.info((Object)("MYSQL Writer Latency :" + this._mySQLWriteLatency.getDuration() / 1000000L));
                this._stop.set(true);
            }
        }
        return true;
    }

    @Override
    public void run() {
        boolean success = true;
        this._rate.start();
        LOG.info((Object)"MYSQL Writer Thread started !!");
        long count = 0L;
        while (!this._stop.get() && success) {
            ++count;
            success = this._buffer.readNextEvent(this);
        }
        LOG.info((Object)"MYSQL Writer Thread done !!");
    }
}

