/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.utils;

import com.linkedin.databus.bootstrap.utils.BootstrapEventBuffer;
import com.linkedin.databus.bootstrap.utils.DbusSeederBaseThread;
import com.linkedin.databus.core.DbusEventBufferAppendable;
import com.linkedin.databus.core.DbusEventKey;
import com.linkedin.databus.core.UnsupportedKeyException;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus.core.util.RateMonitor;
import com.linkedin.databus.core.util.StringUtils;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.producers.EventCreationException;
import com.linkedin.databus2.producers.db.EventReaderSummary;
import com.linkedin.databus2.producers.db.OracleTriggerMonitoredSourceInfo;
import com.linkedin.databus2.producers.db.ReadEventCycleSummary;
import com.linkedin.databus2.producers.db.SourceDBEventReader;
import com.linkedin.databus2.util.DBHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class BootstrapSrcDBEventReader
extends DbusSeederBaseThread
implements SourceDBEventReader {
    private static final Logger LOG = Logger.getLogger(BootstrapSrcDBEventReader.class);
    private static final long MILLISEC_TO_MIN = 60000L;
    private final List<OracleTriggerMonitoredSourceInfo> _sources;
    private final DataSource _dataSource;
    private final BootstrapEventBuffer _bootstrapSeedWriter;
    private final int _numRetries;
    private final int _numRowsPrefetch;
    private final int _LOBPrefetchSize;
    private final int _commitInterval;
    private final long _sinceSCN;
    private final int _numRowsPerQuery;
    private final boolean _enableNumRowsQuery;
    private final Map<String, Long> _lastRows;
    private final Map<String, String> _lastKeys;
    private final Map<String, File> _keyTxnFilesMap;
    private final Map<String, Integer> _keyTxnBufferSizeMap;
    private final Map<String, String> _pKeyNameMap;
    private final Map<String, DbusEventKey.KeyType> _pKeyTypeMap;
    private final Map<String, String> _pKeyIndexMap;
    private final Map<String, String> _queryHintMap;
    private final Map<String, String> _eventQueryMap;
    private final Map<String, String> _beginSrcKeyMap;
    private final Map<String, String> _endSrcKeyMap;
    private final Method _setLobPrefetchSizeMethod;
    private final Class<?> _oraclePreparedStatementClass;

    public Map<String, File> getKeyTxnFilesMap() {
        return this._keyTxnFilesMap;
    }

    public Map<String, Integer> getKeyTxnBufferSizeMap() {
        return this._keyTxnBufferSizeMap;
    }

    public Map<String, String> getpKeyNameMap() {
        return this._pKeyNameMap;
    }

    public Map<String, DbusEventKey.KeyType> getpKeyTypeMap() {
        return this._pKeyTypeMap;
    }

    public BootstrapSrcDBEventReader(DataSource dataSource, BootstrapEventBuffer eventBuffer, StaticConfig config, List<OracleTriggerMonitoredSourceInfo> sources, Map<String, Long> lastRows, Map<String, String> lastKeys, long sinceSCN) throws Exception {
        super("BootstrapSrcDBEventReader");
        ArrayList<OracleTriggerMonitoredSourceInfo> sourcesTemp = new ArrayList<OracleTriggerMonitoredSourceInfo>();
        sourcesTemp.addAll(sources);
        this._sources = Collections.unmodifiableList(sourcesTemp);
        this._dataSource = dataSource;
        this._bootstrapSeedWriter = eventBuffer;
        this._keyTxnFilesMap = new HashMap<String, File>();
        this._numRowsPerQuery = config.getNumRowsPerQuery();
        this._keyTxnBufferSizeMap = config.getKeyTxnBufferSizeMap();
        Map<String, String> keyTxnFiles = config.getKeyTxnFilesMap();
        for (Map.Entry<String, String> entry : keyTxnFiles.entrySet()) {
            LOG.info((Object)("Adding KeyTxnMapFile Entry :" + entry));
            this._keyTxnFilesMap.put(entry.getKey(), new File(entry.getValue()));
        }
        this._enableNumRowsQuery = config.isEnableNumRowsQuery();
        this._commitInterval = config.getCommitInterval();
        this._numRowsPrefetch = config.getNumRowsPrefetch();
        this._LOBPrefetchSize = config.getLOBPrefetchSize();
        this._numRetries = config.getNumRetries();
        this._sinceSCN = sinceSCN;
        this._lastRows = new HashMap<String, Long>(lastRows);
        this._lastKeys = new HashMap<String, String>(lastKeys);
        this._pKeyNameMap = config.getPKeyNameMap();
        this._pKeyTypeMap = config.getPKeyTypeMap();
        this._pKeyIndexMap = config.getPKeyIndexMap();
        this._queryHintMap = config.getQueryHintMap();
        this._eventQueryMap = config.getEventQueryMap();
        this._beginSrcKeyMap = config.getBeginSrcKeyMap();
        this._endSrcKeyMap = config.getEndSrcKeyMap();
        File file = new File("ojdbc6-11.2.0.2.0.jar");
        URL ojdbcJarFile = file.toURI().toURL();
        URLClassLoader cl = URLClassLoader.newInstance(new URL[]{ojdbcJarFile});
        this._oraclePreparedStatementClass = cl.loadClass("oracle.jdbc.OraclePreparedStatement");
        this._setLobPrefetchSizeMethod = this._oraclePreparedStatementClass.getMethod("setLobPrefetchSize", Integer.TYPE);
        this.validate();
    }

    public void validate() throws Exception {
        boolean isNullQueryHint;
        if (null == this._pKeyTypeMap) {
            throw new Exception("_pKeyTypeMap cannot be null !!");
        }
        if (null == this._pKeyNameMap) {
            throw new Exception("_pKeyNameMap cannot be null !!");
        }
        boolean isNullIndex = null == this._pKeyIndexMap;
        boolean bl = isNullQueryHint = null == this._queryHintMap;
        if (isNullIndex && isNullQueryHint) {
            throw new Exception("Index and Query Hint both cannot be null !!");
        }
        for (OracleTriggerMonitoredSourceInfo s : this._sources) {
            if (null == this._pKeyTypeMap.get(s.getEventView())) {
                throw new Exception("pKey Type for Source (" + s.getEventView() + ") not provided !!");
            }
            if (null == this._pKeyNameMap.get(s.getEventView())) {
                throw new Exception("pKey Name for Source (" + s.getEventView() + ") not provided !!");
            }
            if (!isNullIndex && null != this._pKeyIndexMap.get(s.getEventView()) || !isNullQueryHint && null != this._queryHintMap.get(s.getEventView())) continue;
            throw new Exception("Both pkey Index and Query Hint for source (" + s.getEventView() + ") not provided !!");
        }
    }

    @Override
    public void run() {
        try {
            this.readEventsFromAllSources(this._sinceSCN);
        }
        catch (Exception ex) {
            LOG.error((Object)"Got Error when executing readEventsFromAllSources !!", (Throwable)ex);
        }
        LOG.info((Object)(Thread.currentThread().getName() + " done seeding ||"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadEventCycleSummary readEventsFromAllSources(long sinceSCN) throws DatabusException, EventCreationException, UnsupportedKeyException {
        long maxScn;
        ArrayList<EventReaderSummary> summaries = new ArrayList<EventReaderSummary>();
        long endScn = maxScn = -1L;
        boolean error = false;
        long startTS = System.currentTimeMillis();
        try {
            this._rate.start();
            this._rate.suspend();
            Connection conn = null;
            try {
                conn = this._dataSource.getConnection();
                LOG.info((Object)("Oracle JDBC Version :" + conn.getMetaData().getDriverVersion()));
            }
            finally {
                DBHelper.close((Connection)conn);
            }
            if (!this._sources.isEmpty()) {
                maxScn = this.getMaxScn(this._sources.get(0));
            }
            for (OracleTriggerMonitoredSourceInfo sourceInfo : this._sources) {
                LOG.info((Object)("Bootstrapping " + sourceInfo.getEventView()));
                this._bootstrapSeedWriter.start(maxScn);
                EventReaderSummary summary = this.readEventsForSource(sourceInfo, maxScn);
                endScn = this.getMaxScn(this._sources.get(0));
                this._bootstrapSeedWriter.endEvents(-2L, endScn, null);
                summaries.add(summary);
            }
        }
        catch (Exception ex) {
            error = true;
            throw new DatabusException((Throwable)ex);
        }
        finally {
            if (error) {
                this._bootstrapSeedWriter.endEvents(-3L, endScn, null);
                LOG.error((Object)"Seeder stopping unexpectedly !!");
            } else {
                this._bootstrapSeedWriter.endEvents(-1L, endScn, null);
                LOG.info((Object)"Completed Seeding !!");
            }
            LOG.info((Object)("Start SCN :" + maxScn));
            LOG.info((Object)("End SCN :" + endScn));
        }
        long endTS = System.currentTimeMillis();
        ReadEventCycleSummary cycleSummary = new ReadEventCycleSummary("seeder", summaries, maxScn, endTS - startTS);
        return cycleSummary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumRows(Connection conn, String table) throws SQLException {
        String sql = BootstrapSrcDBEventReader.generateCountQuery(table);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        long numRows = 0L;
        try {
            conn = this._dataSource.getConnection();
            LOG.info((Object)("NumRows Query :" + sql));
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            rs.next();
            numRows = rs.getLong(1);
        }
        catch (Throwable throwable) {
            DBHelper.close(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        DBHelper.close((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return numRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventReaderSummary readEventsForSource(OracleTriggerMonitoredSourceInfo sourceInfo, long maxScn) throws DatabusException, EventCreationException, UnsupportedKeyException, SQLException, IOException {
        int retryMax = this._numRetries;
        int numRetry = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        DbusEventKey.KeyType keyType = this._pKeyTypeMap.get(sourceInfo.getEventView());
        String keyName = this._pKeyNameMap.get(sourceInfo.getEventView());
        String sql = this._eventQueryMap.get(sourceInfo.getEventView());
        String endSrcKey = this._endSrcKeyMap.get(sourceInfo.getEventView());
        if (sql == null) {
            sql = BootstrapSrcDBEventReader.generateEventQuery2(sourceInfo, keyName, keyType, this.getPKIndex(sourceInfo), this.getQueryHint(sourceInfo));
        }
        LOG.info((Object)("Chunked  Query for Source (" + sourceInfo + ") is :" + sql));
        LOG.info((Object)("EndSrcKey for source (" + sourceInfo + ") is :" + endSrcKey));
        PrimaryKeyTxn endKeyTxn = null;
        if (null != endSrcKey && !endSrcKey.trim().isEmpty()) {
            endKeyTxn = DbusEventKey.KeyType.LONG == keyType ? new PrimaryKeyTxn(new Long(endSrcKey)) : new PrimaryKeyTxn(endSrcKey);
        }
        long timestamp = System.currentTimeMillis();
        int numRowsFetched = 0;
        long totalEventSize = 0L;
        long timeStart = System.currentTimeMillis();
        long checkpointInterval = this._commitInterval;
        boolean done = false;
        long lastTime = timeStart;
        long numRows = 0L;
        PrimaryKeyTxn pKey = null;
        String minKeySQL = BootstrapSrcDBEventReader.generateMinKeyQuery(sourceInfo, keyName);
        String srcName = sourceInfo.getEventView();
        LOG.info((Object)("Bootstrapping for Source :" + srcName));
        String lastKey = this._lastKeys.get(sourceInfo.getEventView());
        File f = this._keyTxnFilesMap.get(srcName);
        FileWriter oStream = new FileWriter(f, f.exists());
        BufferedWriter keyTxnWriter = new BufferedWriter(oStream, this._keyTxnBufferSizeMap.get(srcName));
        this._bootstrapSeedWriter.startEvents();
        RateMonitor seedingRate = new RateMonitor("Seeding Rate");
        RateMonitor queryRate = new RateMonitor("Query Rate");
        seedingRate.start();
        seedingRate.suspend();
        queryRate.start();
        queryRate.suspend();
        boolean isException = false;
        long totProcessTime = 0L;
        try {
            conn = this._dataSource.getConnection();
            pstmt = conn.prepareStatement(sql);
            numRows = this._enableNumRowsQuery ? this.getNumRows(conn, BootstrapSrcDBEventReader.getTableName(sourceInfo)) : -1L;
            long currRowId = this._lastRows.get(sourceInfo.getEventView());
            if (null == lastKey) {
                lastKey = this._beginSrcKeyMap.get(sourceInfo.getEventView());
                LOG.info((Object)("No last Src Key available in bootstrap_seeder_state for source (" + sourceInfo + ". Trying beginSrc Key from config :" + lastKey));
            }
            pKey = null == lastKey || lastKey.trim().isEmpty() ? (DbusEventKey.KeyType.LONG == keyType ? new PrimaryKeyTxn(this.executeAndGetLong(minKeySQL)) : new PrimaryKeyTxn(this.executeAndGetString(minKeySQL))) : (DbusEventKey.KeyType.LONG == keyType ? new PrimaryKeyTxn(Long.parseLong(lastKey)) : new PrimaryKeyTxn(lastKey));
            PrimaryKeyTxn lastRoundKeyTxn = new PrimaryKeyTxn(pKey);
            PrimaryKeyTxn lastKeyTxn = new PrimaryKeyTxn(pKey);
            long numUniqueKeysThisRound = 0L;
            boolean first = true;
            this._rate.resume();
            while (!done) {
                LOG.info((Object)("MinKey being used for this round:" + pKey));
                numUniqueKeysThisRound = 0L;
                try {
                    lastRoundKeyTxn.copyFrom(pKey);
                    if (DbusEventKey.KeyType.LONG == keyType) {
                        pstmt.setLong(1, pKey.getKey());
                    } else {
                        String key = pKey.getKeyStr();
                        pstmt.setString(1, key);
                    }
                    pstmt.setLong(2, this._numRowsPerQuery);
                    pstmt.setFetchSize(this._numRowsPrefetch);
                    if (this._oraclePreparedStatementClass.isInstance(pstmt)) {
                        try {
                            this._setLobPrefetchSizeMethod.invoke((Object)pstmt, this._LOBPrefetchSize);
                        }
                        catch (Exception e) {
                            throw new EventCreationException("Unable to set Lob Prefetch size" + e.getMessage());
                        }
                    }
                    LOG.info((Object)("Executing Oracle Query :" + sql + ". Key: " + pKey + ",NumRows: " + this._numRowsPerQuery));
                    queryRate.resume();
                    rs = pstmt.executeQuery();
                    queryRate.suspend();
                    LOG.info((Object)("Total Query Latency :" + queryRate.getDuration() / 1000000000L));
                    long totLatency = 0L;
                    long txnId = 0L;
                    int numRowsThisRound = 0;
                    seedingRate.resume();
                    while (rs.next()) {
                        this._rate.tick();
                        seedingRate.tick();
                        ++currRowId;
                        txnId = rs.getLong(2);
                        if (DbusEventKey.KeyType.LONG == keyType) {
                            pKey.setKeyTxn(rs.getLong(1), txnId);
                        } else {
                            String key = rs.getString(1);
                            pKey.setKeyStrTxn(key, txnId);
                        }
                        pKey.writeTo(keyTxnWriter);
                        long start = System.nanoTime();
                        long eventSize = sourceInfo.getFactory().createAndAppendEvent(maxScn, timestamp, rs, (DbusEventBufferAppendable)this._bootstrapSeedWriter, false, null);
                        long latency = System.nanoTime() - start;
                        totalEventSize += eventSize;
                        totProcessTime += (totLatency += latency) / 1000L * 1000L;
                        ++numRowsFetched;
                        ++numRowsThisRound;
                        if (lastKeyTxn.compareKey(pKey) != 0L) {
                            ++numUniqueKeysThisRound;
                            lastKeyTxn.copyFrom(pKey);
                        }
                        if ((long)numRowsFetched % checkpointInterval == 0L) {
                            this._bootstrapSeedWriter.endEvents(currRowId, timestamp, null);
                            keyTxnWriter.flush();
                            this._bootstrapSeedWriter.startEvents();
                            long procTime = totLatency / 1000000000L;
                            long currTime = System.currentTimeMillis();
                            long diff = (currTime - lastTime) / 1000L;
                            long timeSinceStart = (currTime - timeStart) / 1000L;
                            double currRate = this._rate.getRate();
                            double d = currRate = currRate <= 0.0 ? 1.0 : currRate;
                            if (this._enableNumRowsQuery) {
                                double remTime = (double)(numRows - currRowId) / currRate;
                                LOG.info((Object)("Processed " + checkpointInterval + " rows in " + diff + " seconds, Processing Time (seconds) so far :" + procTime + ",Seconds elapsed since start :" + timeSinceStart + ",Approx Seconds remaining :" + remTime + ",Overall Row Rate:" + this._rate.getRate() + "(" + seedingRate.getRate() + ")" + ",NumRows Fetched so far:" + numRowsFetched + ". TotalEventSize :" + totalEventSize));
                            } else {
                                LOG.info((Object)("Processed " + checkpointInterval + " rows in " + diff + " seconds, Processing Time (seconds) so far :" + procTime + ",Seconds elapsed since start :" + timeSinceStart + ",Overall Row Rate:" + this._rate.getRate() + "(" + seedingRate.getRate() + ")" + ",NumRows Fetched so far:" + numRowsFetched + ". TotalEventSize :" + totalEventSize));
                            }
                            lastTime = currTime;
                        }
                        if (null == endKeyTxn || endKeyTxn.compareKey(lastKeyTxn) >= 0L) continue;
                        LOG.info((Object)("Seeding to be stopped for current source as it has completed seeding upto endSrckey :" + endKeyTxn + ", Current SrcKey :" + lastKeyTxn));
                        break;
                    }
                    seedingRate.suspend();
                    if (numRowsThisRound <= 1 || numRowsThisRound < this._numRowsPerQuery && numUniqueKeysThisRound <= 1L) {
                        LOG.info((Object)("Seeding Done for source :" + sourceInfo.getEventView() + ", numRowsThisRound :" + numRowsThisRound + ", _numRowsPerQuery :" + this._numRowsPerQuery + ", numUniqueKeys :" + numUniqueKeysThisRound));
                        done = true;
                    } else {
                        if (numRowsThisRound == this._numRowsPerQuery && numUniqueKeysThisRound <= 1L) {
                            String msg = "Seeding stuck at infinte loop for source : " + sourceInfo.getEventView() + ", numRowsThisRound :" + numRowsThisRound + ", _numRowsPerQuery :" + this._numRowsPerQuery + ", numUniqueKeys :" + numUniqueKeysThisRound + ", lastChunkKey :" + lastRoundKeyTxn;
                            LOG.error((Object)msg);
                            throw new DatabusException(msg);
                        }
                        if (null != endKeyTxn && endKeyTxn.compareKey(lastKeyTxn) < 0L) {
                            LOG.info((Object)("Seeding stopped for source :" + sourceInfo.getEventView() + ", as it has completed seeding upto the endSrckey :" + endKeyTxn + ", numRowsThisRound :" + numRowsThisRound + ", _numRowsPerQuery :" + this._numRowsPerQuery + ", numUniqueKeys :" + numUniqueKeysThisRound + " , Current SrcKey :" + lastKeyTxn));
                            done = true;
                        }
                    }
                    if (currRowId > 0L && (!first || done)) {
                        --currRowId;
                    }
                    LOG.info((Object)("about to call end events with currRowId = " + currRowId));
                    first = false;
                    this._bootstrapSeedWriter.endEvents(currRowId, timestamp, null);
                    isException = false;
                    DBHelper.close((ResultSet)rs);
                    rs = null;
                }
                catch (SQLException ex) {
                    LOG.error((Object)("Got SQLException for source (" + sourceInfo + ")"), (Throwable)ex);
                    this._bootstrapSeedWriter.rollbackEvents();
                    isException = true;
                    if (++numRetry < retryMax) continue;
                    throw new DatabusException("Error: Reached max retries for reading/processing bootstrap", (Throwable)ex);
                }
                finally {
                    DBHelper.close(rs);
                    rs = null;
                }
            }
        }
        catch (DatabusException ex) {
            try {
                isException = true;
                throw ex;
            }
            catch (Throwable throwable) {
                DBHelper.close(rs, pstmt, (Connection)conn);
                keyTxnWriter.close();
                rs = null;
                this._rate.suspend();
                if (!isException) {
                    this.dedupeKeyTxnFile(this._keyTxnFilesMap.get(srcName), keyType);
                }
                throw throwable;
            }
        }
        DBHelper.close(rs, (Statement)pstmt, (Connection)conn);
        keyTxnWriter.close();
        rs = null;
        this._rate.suspend();
        if (!isException) {
            this.dedupeKeyTxnFile(this._keyTxnFilesMap.get(srcName), keyType);
        }
        long timeEnd = System.currentTimeMillis();
        long elapsedMin = (timeEnd - timeStart) / 60000L;
        LOG.info((Object)("Processed " + numRowsFetched + " rows of Source: " + sourceInfo.getSourceName() + " in " + elapsedMin + " minutes"));
        return new EventReaderSummary(sourceInfo.getSourceId(), sourceInfo.getSourceName(), -1L, numRowsFetched, totalEventSize, timeEnd - timeStart, totProcessTime, 0L, 0L, 0L);
    }

    private long getMaxScn(OracleTriggerMonitoredSourceInfo sourceInfo) throws SQLException {
        String schema = sourceInfo.getEventSchema() == null ? "" : sourceInfo.getEventSchema() + ".";
        String table = schema + "sy$txlog";
        String query = "select max(" + schema + "sync_core.getScn(scn,ora_rowscn)) " + "from " + table + " where " + "scn >= (select max(scn) from " + table + ")";
        long maxScn = this.executeAndGetLong(query);
        return maxScn;
    }

    private long executeAndGetLong(String query) throws SQLException {
        long val = -1L;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = this._dataSource.getConnection();
            pstmt = conn.prepareStatement(query);
            rs = pstmt.executeQuery();
            boolean ret = rs.next();
            assert (ret);
            val = rs.getLong(1);
            LOG.info((Object)("Query:" + query + ",Result is :" + val));
        }
        catch (SQLException sqlEx) {
            try {
                LOG.error((Object)("Got error while executing query:" + query), (Throwable)sqlEx);
                throw sqlEx;
            }
            catch (Throwable throwable) {
                DBHelper.close(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        DBHelper.close((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return val;
    }

    private String executeAndGetString(String query) throws SQLException {
        String val = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = this._dataSource.getConnection();
            pstmt = conn.prepareStatement(query);
            rs = pstmt.executeQuery();
            boolean ret = rs.next();
            assert (ret);
            val = rs.getString(1);
            LOG.info((Object)("Query:" + query + ",Result is :" + val));
        }
        catch (SQLException sqlEx) {
            try {
                LOG.error((Object)("Got error while executing query:" + query), (Throwable)sqlEx);
                throw sqlEx;
            }
            catch (Throwable throwable) {
                DBHelper.close(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        DBHelper.close((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return val;
    }

    public static String getTableName(OracleTriggerMonitoredSourceInfo sourceInfo) {
        String schema = sourceInfo.getEventSchema() == null ? "" : sourceInfo.getEventSchema() + ".";
        String table = schema + "sy$" + sourceInfo.getEventView();
        return table;
    }

    public String getPKIndex(OracleTriggerMonitoredSourceInfo sourceInfo) {
        String index = this._pKeyIndexMap.get(sourceInfo.getEventView());
        if (null == index) {
            index = sourceInfo.getEventView() + "_pk";
        }
        return index;
    }

    public String getQueryHint(OracleTriggerMonitoredSourceInfo sourceInfo) {
        String index = this._queryHintMap.get(sourceInfo.getEventView());
        if (null == index) {
            return null;
        }
        return index;
    }

    public static String generateEventQuery2(OracleTriggerMonitoredSourceInfo sourceInfo, String keyName, DbusEventKey.KeyType keyType, String pkIndex, String queryHint) {
        return BootstrapSrcDBEventReader.generateEventQuery2(BootstrapSrcDBEventReader.getTableName(sourceInfo), keyName, keyType, pkIndex, queryHint);
    }

    public static String generateEventQuery2(String table, String keyName, DbusEventKey.KeyType keyType, String pkIndex, String queryHint) {
        StringBuilder sql = new StringBuilder();
        sql.append("select * from (");
        if (null == queryHint || queryHint.isEmpty()) {
            sql.append("select /*+ INDEX(src ").append(pkIndex).append(") */ ");
        } else {
            sql.append("select /*+ " + queryHint + " */ ");
        }
        sql.append(keyName).append(" keyn,");
        sql.append(" txn txnid, src.*, ROW_NUMBER() OVER(order by src.").append(keyName).append(" asc) as row_counter from ");
        sql.append(table);
        sql.append(" src");
        sql.append(" where src." + keyName + " >= ?");
        sql.append(" ) where row_counter <= ?");
        return sql.toString();
    }

    public static String generateEventQueryAudit(String table, String keyName, DbusEventKey.KeyType keyType, String pkIndex, String queryHint) {
        StringBuilder sql = new StringBuilder();
        sql.append("select * from (");
        if (null == queryHint || queryHint.isEmpty()) {
            sql.append("select /*+ INDEX(src ").append(pkIndex).append(") */ ");
        } else {
            sql.append("select /*+ " + queryHint + " */ ");
        }
        sql.append(keyName).append(" keyn,");
        sql.append(" txn txnid, src.*, ROW_NUMBER() OVER(order by src.").append(keyName).append(" asc) as row_counter from ");
        sql.append(table);
        sql.append(" src");
        sql.append(" where src." + keyName + " > ?");
        sql.append(" ) where row_counter <= ?");
        return sql.toString();
    }

    public static String generateMinKeyQuery(OracleTriggerMonitoredSourceInfo sourceInfo, String keyName) {
        return BootstrapSrcDBEventReader.generateMinKeyQuery(BootstrapSrcDBEventReader.getTableName(sourceInfo), keyName);
    }

    public static String generateMinKeyQuery(String table, String keyName) {
        StringBuilder sql = new StringBuilder();
        sql.append("select min(" + keyName + ") ");
        sql.append("from " + table);
        return sql.toString();
    }

    private static String generateCountQuery(String table) {
        StringBuilder sql = new StringBuilder();
        sql.append("select count(*) from ");
        sql.append(table);
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dedupe(String file, String tmpFile, DbusEventKey.KeyType type) throws Exception {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        PrimaryKeyTxn keyTxn = null;
        PrimaryKeyTxn oldKeyTxn = null;
        try {
            String line;
            reader = new BufferedReader(StringUtils.createFileReader((String)file));
            writer = new BufferedWriter(StringUtils.createFileWriter((String)tmpFile));
            keyTxn = new PrimaryKeyTxn(Long.MIN_VALUE);
            oldKeyTxn = new PrimaryKeyTxn(Long.MIN_VALUE);
            keyTxn.setType(type);
            oldKeyTxn.setType(type);
            boolean first = true;
            while (null != (line = reader.readLine())) {
                keyTxn.readFrom(line);
                long cmp = keyTxn.compareKey(oldKeyTxn);
                if (cmp != 0L) {
                    if (!first) {
                        oldKeyTxn.writeTo(writer);
                    }
                    oldKeyTxn.copyFrom(keyTxn);
                }
                first = false;
            }
            oldKeyTxn.writeTo(writer);
        }
        catch (Exception ex) {
            LOG.error((Object)"Got exception while deduping key_txns", (Throwable)ex);
        }
        finally {
            if (null != reader) {
                reader.close();
            }
            if (null != writer) {
                writer.close();
            }
        }
    }

    private void dedupeKeyTxnFile(File keyTxnFile, DbusEventKey.KeyType keyType) {
        boolean numericKey = keyType == DbusEventKey.KeyType.LONG;
        StringBuilder cmd = new StringBuilder();
        String tmpFile = keyTxnFile.getAbsolutePath() + ".tmp";
        String backupFile = keyTxnFile.getAbsolutePath() + ".pre";
        LOG.info((Object)("Post Processing the KeyTXN File :" + keyTxnFile.toString()));
        cmd.append("sort -t ");
        cmd.append("@");
        cmd.append(" -k 1");
        if (numericKey) {
            cmd.append("n");
        }
        cmd.append(" -k 2nr ");
        cmd.append(keyTxnFile.getAbsolutePath());
        cmd.append(" -o ").append(tmpFile);
        String cmd1 = "cp " + keyTxnFile.getAbsolutePath() + " " + backupFile;
        String cmd2 = cmd.toString();
        String cmd3 = "rm " + tmpFile + " ";
        try {
            Runtime rt = Runtime.getRuntime();
            LOG.info((Object)("Executing command :" + cmd1));
            Process pr1 = rt.exec(cmd1);
            int res = pr1.waitFor();
            if (res != 0) {
                LOG.error((Object)"**********************");
                LOG.error((Object)("Error Executing CMD (" + cmd1 + "), Error: (STDOUT=" + this.getStream(pr1.getInputStream()) + ") (STDERR=" + this.getStream(pr1.getErrorStream()) + "). Result was :" + res));
                LOG.error((Object)"**********************");
            }
            LOG.info((Object)("Executing command :" + cmd2));
            Process pr2 = rt.exec(cmd2);
            res = pr2.waitFor();
            if (res != 0) {
                LOG.error((Object)"**********************");
                LOG.error((Object)("Error Executing CMD (" + cmd2 + "), Error: (STDOUT=" + this.getStream(pr2.getInputStream()) + ") (STDERR=" + this.getStream(pr2.getErrorStream()) + "). Result was :" + res));
                LOG.error((Object)"**********************");
            }
            LOG.info((Object)"Removing duplicate Entries from the sorted list");
            this.dedupe(tmpFile, keyTxnFile.getAbsolutePath(), keyType);
            LOG.info((Object)("Executing command :" + cmd3));
            Process pr3 = rt.exec(cmd3);
            res = pr3.waitFor();
            if (res != 0) {
                LOG.error((Object)"**********************");
                LOG.error((Object)("Error Executing CMD (" + cmd3 + "), Error: (STDOUT=" + this.getStream(pr3.getInputStream()) + ") (STDERR=" + this.getStream(pr3.getErrorStream()) + "). Result was :" + res));
                LOG.error((Object)"**********************");
            }
            LOG.info((Object)("Post Processing the KeyTXN File done successfully :" + keyTxnFile.toString()));
        }
        catch (Exception io) {
            LOG.error((Object)("Postprocessing the KeyTXNFile :" + keyTxnFile + " failed !!"), (Throwable)io);
            LOG.info((Object)("CMD1 :" + cmd1));
            LOG.info((Object)("CMD2 :" + cmd2));
            LOG.info((Object)("CMD3 :" + cmd3));
        }
    }

    private String getStream(InputStream stream) throws IOException {
        String s;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StringUtils.DEFAULT_CHARSET));
        StringBuilder str = new StringBuilder();
        while (null != (s = reader.readLine())) {
            str.append(s);
        }
        return str.toString();
    }

    public List<OracleTriggerMonitoredSourceInfo> getSources() {
        return this._sources;
    }

    public static class PrimaryKeyTxn {
        private long key;
        private String keyStr;
        private DbusEventKey.KeyType keyType;
        private long txn;
        public static final String DELIMITER = "@";

        public String toString() {
            return "PrimaryKeyTxn [key=" + this.key + ", keyStr=" + this.keyStr + ", keyType=" + this.keyType + ", txn=" + this.txn + "]";
        }

        public long getKey() {
            return this.key;
        }

        public long getTxn() {
            return this.txn;
        }

        public void setType(DbusEventKey.KeyType t) {
            this.keyType = t;
        }

        public void setKeyTxn(long key, long txn) {
            this.keyType = DbusEventKey.KeyType.LONG;
            this.txn = txn;
            this.key = key;
        }

        public String getKeyStr() {
            return this.keyStr;
        }

        public void setKeyStrTxn(String keyStr, long txn) {
            this.keyType = DbusEventKey.KeyType.STRING;
            this.txn = txn;
            this.keyStr = keyStr;
        }

        public DbusEventKey.KeyType getKeyType() {
            return this.keyType;
        }

        public PrimaryKeyTxn(PrimaryKeyTxn keyTxn) {
            this.copyFrom(keyTxn);
        }

        public PrimaryKeyTxn(long key) {
            this.key = key;
            this.keyStr = null;
            this.keyType = DbusEventKey.KeyType.LONG;
            this.txn = -1L;
        }

        public PrimaryKeyTxn(String key) {
            this.keyStr = key;
            this.keyType = DbusEventKey.KeyType.STRING;
            this.key = -1L;
            this.txn = -1L;
        }

        public void writeTo(BufferedWriter writer) throws IOException {
            StringBuffer buffer = new StringBuffer();
            if (DbusEventKey.KeyType.LONG == this.keyType) {
                buffer.append(this.key).append(DELIMITER);
            } else {
                buffer.append(this.keyStr).append(DELIMITER);
            }
            buffer.append(this.txn).append("\n");
            writer.write(buffer.toString());
        }

        public void readFrom(String line) throws IOException {
            String[] toks = line.split(DELIMITER);
            if (DbusEventKey.KeyType.LONG == this.keyType) {
                this.key = Long.parseLong(toks[0]);
            } else {
                this.keyStr = toks[0];
            }
            this.txn = Long.parseLong(toks[1]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrom(ResultSet rs, String keyName, DbusEventKey.KeyType keyType) throws SQLException {
            this.keyType = keyType;
            if (DbusEventKey.KeyType.LONG == keyType) {
                this.key = rs.getLong(keyName);
            } else {
                this.keyStr = rs.getString(keyName);
            }
        }

        public long compareKey(PrimaryKeyTxn key2) {
            if (this.keyType == DbusEventKey.KeyType.LONG) {
                return this.key - key2.getKey();
            }
            return this.keyStr.compareTo(key2.getKeyStr());
        }

        public void copyFrom(PrimaryKeyTxn entry) {
            this.keyType = entry.getKeyType();
            this.key = entry.getKey();
            this.keyStr = entry.getKeyStr();
            this.txn = entry.getTxn();
        }

        public long compareTxn(PrimaryKeyTxn txn) {
            return this.txn - txn.getTxn();
        }
    }

    public static class Config
    implements ConfigBuilder<StaticConfig> {
        private static final boolean DEFAULT_ENABLE_NUM_ROWS_QUERY = false;
        private static final int DEFAULT_NUM_ROWS_PREFETCH = 10;
        private static final int DEFAULT_LOB_PREFETCH_SIZE = 4000;
        private static final int DEFAULT_COMMIT_INTERVAL = 10000;
        private static final int DEFAULT_NUM_ROWS_PER_QUERY = 100000;
        private static final int DEFAULT_NUM_RETRIES = 2;
        private static final String DEFAULT_KEYTXN_MAP_FILES = "keyTxnMapFile.txt";
        private static final Integer DEFAULT_BUFFER_SIZE = 0;
        private static final String DEFAULT_PKEY_NAME = "key";
        private static final String DEFAULT_PKEY_TYPE = "LONG";
        private static final String DEFAULT_QUERY_HINT = "";
        private static final String DEFAULT_BEGINSRC_KEY = "";
        private static final String DEFAULT_ENDSRC_KEY = "";
        private boolean _enableNumRowsQuery = false;
        private int _numRowsPrefetch = 10;
        private int _LOBPrefetchSize = 4000;
        private int _commitInterval = 10000;
        private int _numRetries = 2;
        private int _numRowsPerQuery = 100000;
        private final Map<String, String> _keyTxnFilesMap = new HashMap<String, String>();
        private final Map<String, Integer> _keyTxnBufferSizeMap = new HashMap<String, Integer>();
        private final Map<String, String> _pKeyNameMap = new HashMap<String, String>();
        private final Map<String, String> _pKeyTypeMap = new HashMap<String, String>();
        private final Map<String, String> _pKeyIndexMap = new HashMap<String, String>();
        private final Map<String, String> _queryHintMap = new HashMap<String, String>();
        private final Map<String, String> _eventQueryMap = new HashMap<String, String>();
        private final Map<String, String> _beginSrcKeyMap = new HashMap<String, String>();
        private final Map<String, String> _endSrcKeyMap = new HashMap<String, String>();

        public StaticConfig build() throws InvalidConfigException {
            LOG.info((Object)("enableNumRowsQuery:" + this._enableNumRowsQuery));
            LOG.info((Object)("NumRowsPrefetch:" + this._numRowsPrefetch));
            LOG.info((Object)("_LOBPrefetchSize:" + this._LOBPrefetchSize));
            LOG.info((Object)("Commit Interval:" + this._commitInterval));
            LOG.info((Object)("Num Retries:" + this._numRetries));
            LOG.info((Object)("_numRowsPerQuery:" + this._numRowsPerQuery));
            LOG.info((Object)("_keyTxnFilesMap:" + this._keyTxnFilesMap));
            LOG.info((Object)("_keyTxnBufferSizeMap:" + this._keyTxnBufferSizeMap));
            LOG.info((Object)("_pKeyNameMap:" + this._pKeyNameMap));
            LOG.info((Object)("_pKeyTypeMap:" + this._pKeyTypeMap));
            LOG.info((Object)("_pKeyIndexMap:" + this._pKeyIndexMap));
            LOG.info((Object)("_queryHintMap:" + this._queryHintMap));
            LOG.info((Object)("_beginSrcKeyMap:" + this._beginSrcKeyMap));
            LOG.info((Object)("_endSrcKeyMap:" + this._endSrcKeyMap));
            HashMap<String, DbusEventKey.KeyType> pKeyTypeMap = new HashMap<String, DbusEventKey.KeyType>();
            for (Map.Entry<String, String> entry : this._pKeyTypeMap.entrySet()) {
                DbusEventKey.KeyType kType = DbusEventKey.KeyType.valueOf((String)entry.getValue());
                pKeyTypeMap.put(entry.getKey(), kType);
            }
            return new StaticConfig(this._enableNumRowsQuery, this._numRowsPrefetch, this._LOBPrefetchSize, this._commitInterval, this._numRetries, this._numRowsPerQuery, this._keyTxnFilesMap, this._keyTxnBufferSizeMap, this._pKeyNameMap, pKeyTypeMap, this._pKeyIndexMap, this._queryHintMap, this._eventQueryMap, this._beginSrcKeyMap, this._endSrcKeyMap);
        }

        public int getNumRowsPrefetch() {
            return this._numRowsPrefetch;
        }

        public void setNumRowsPrefetch(int numRowsPrefetch) {
            this._numRowsPrefetch = numRowsPrefetch;
        }

        public int getLOBPrefetchSize() {
            return this._LOBPrefetchSize;
        }

        public void setLOBPrefetchSize(int lOBPrefetchSize) {
            this._LOBPrefetchSize = lOBPrefetchSize;
        }

        public int getCommitInterval() {
            return this._commitInterval;
        }

        public void setCommitInterval(int commitInterval) {
            this._commitInterval = commitInterval;
        }

        public int getNumRetries() {
            return this._numRetries;
        }

        public void setNumRetries(int numRetries) {
            this._numRetries = numRetries;
        }

        public String getKeyTxnMapFile(String sourceName) {
            String file = this._keyTxnFilesMap.get(sourceName);
            if (null == file) {
                this._keyTxnFilesMap.put(sourceName, DEFAULT_KEYTXN_MAP_FILES);
                return DEFAULT_KEYTXN_MAP_FILES;
            }
            return file;
        }

        public void setKeyTxnMapFile(String sourceName, String file) {
            this._keyTxnFilesMap.put(sourceName, file);
        }

        public String getPKeyName(String srcName) {
            String key = this._pKeyNameMap.get(srcName);
            if (null == key) {
                this._pKeyNameMap.put(srcName, DEFAULT_PKEY_NAME);
                return DEFAULT_PKEY_NAME;
            }
            return key;
        }

        public void setBeginSrcKey(String srcName, String key) {
            this._beginSrcKeyMap.put(srcName, key);
        }

        public String getBeginSrcKey(String srcName) {
            String key = this._beginSrcKeyMap.get(srcName);
            if (null == key) {
                key = "";
                this._beginSrcKeyMap.put(srcName, key);
            }
            return key;
        }

        public void setEndSrcKey(String srcName, String key) {
            this._endSrcKeyMap.put(srcName, key);
        }

        public String getEndSrcKey(String srcName) {
            String key = this._endSrcKeyMap.get(srcName);
            if (null == key) {
                key = "";
                this._endSrcKeyMap.put(srcName, key);
            }
            return key;
        }

        public void setQueryHint(String srcName, String key) {
            this._queryHintMap.put(srcName, key);
        }

        public String getQueryHint(String srcName) {
            String key = this._queryHintMap.get(srcName);
            if (null == key) {
                this._queryHintMap.put(srcName, "");
                return "";
            }
            return key;
        }

        public void setPKeyName(String srcName, String key) {
            this._pKeyNameMap.put(srcName, key);
        }

        public String getPKeyType(String srcName) {
            String type = this._pKeyTypeMap.get(srcName);
            if (null == type) {
                this._pKeyTypeMap.put(srcName, DEFAULT_PKEY_NAME);
                return DEFAULT_PKEY_TYPE;
            }
            return type;
        }

        public void setPKeyType(String srcName, String type) {
            this._pKeyTypeMap.put(srcName, type);
        }

        public String getPKeyIndex(String srcName) {
            String index = this._pKeyIndexMap.get(srcName);
            if (null == index) {
                String index2 = srcName + "_pk";
                this._pKeyIndexMap.put(srcName, index2);
                return index2;
            }
            return index;
        }

        public void setPKeyIndex(String srcName, String index) {
            this._pKeyIndexMap.put(srcName, index);
        }

        public Integer getKeyTxnFileBufferSize(String sourceName) {
            Integer size = this._keyTxnBufferSizeMap.get(sourceName);
            if (null == size) {
                this._keyTxnBufferSizeMap.put(sourceName, DEFAULT_BUFFER_SIZE);
                return DEFAULT_BUFFER_SIZE;
            }
            return size;
        }

        public void setKeyTxnFileBufferSize(String sourceName, Integer size) {
            this._keyTxnBufferSizeMap.put(sourceName, size);
        }

        public int getNumRowsPerQuery() {
            return this._numRowsPerQuery;
        }

        public void setNumRowsPerQuery(int numRowsPerQuery) {
            this._numRowsPerQuery = numRowsPerQuery;
        }

        public boolean isEnableNumRowsQuery() {
            return this._enableNumRowsQuery;
        }

        public void setEnableNumRowsQuery(boolean enableNumRowsQuery) {
            this._enableNumRowsQuery = enableNumRowsQuery;
        }

        public void setEventQuery(String name, String value) {
            this._eventQueryMap.put(name, value);
        }

        public String getEventQuery(String src) {
            return this._eventQueryMap.get(src);
        }
    }

    public static class StaticConfig {
        private final boolean _enableNumRowsQuery;
        private final int _numRowsPrefetch;
        private final int _LOBPrefetchSize;
        private final int _commitInterval;
        private final int _numRetries;
        private final int _numRowsPerQuery;
        private final Map<String, String> _keyTxnFilesMap;
        private final Map<String, Integer> _keyTxnBufferSizeMap;
        private final Map<String, String> _pKeyNameMap;
        private final Map<String, DbusEventKey.KeyType> _pKeyTypeMap;
        private final Map<String, String> _pKeyIndexMap;
        private final Map<String, String> _queryHintMap;
        private final Map<String, String> _eventQueryMap;
        private final Map<String, String> _beginSrcKeyMap;
        private final Map<String, String> _endSrcKeyMap;

        public int getNumRowsPrefetch() {
            return this._numRowsPrefetch;
        }

        public Map<String, String> getEventQueryMap() {
            return this._eventQueryMap;
        }

        public int getLOBPrefetchSize() {
            return this._LOBPrefetchSize;
        }

        public int getCommitInterval() {
            return this._commitInterval;
        }

        public int getNumRetries() {
            return this._numRetries;
        }

        public Map<String, String> getKeyTxnFilesMap() {
            return this._keyTxnFilesMap;
        }

        public Map<String, Integer> getKeyTxnBufferSizeMap() {
            return this._keyTxnBufferSizeMap;
        }

        public Map<String, String> getPKeyNameMap() {
            return this._pKeyNameMap;
        }

        public Map<String, String> getQueryHintMap() {
            return this._queryHintMap;
        }

        public Map<String, DbusEventKey.KeyType> getPKeyTypeMap() {
            return this._pKeyTypeMap;
        }

        public Map<String, String> getPKeyIndexMap() {
            return this._pKeyIndexMap;
        }

        public int getNumRowsPerQuery() {
            return this._numRowsPerQuery;
        }

        public boolean isEnableNumRowsQuery() {
            return this._enableNumRowsQuery;
        }

        public Map<String, String> getBeginSrcKeyMap() {
            return this._beginSrcKeyMap;
        }

        public Map<String, String> getEndSrcKeyMap() {
            return this._endSrcKeyMap;
        }

        public StaticConfig(boolean enableNumRowsQuery, int numRowsPrefetch, int LOBPrefetchSize, int commitInterval, int numRetries, int numRowsPerQuery, Map<String, String> keyTxnFilesMap, Map<String, Integer> keyTxnBufferSizeMap, Map<String, String> pKeyNameMap, Map<String, DbusEventKey.KeyType> pKeyTypeMap, Map<String, String> pKeyIndexMap, Map<String, String> queryHintMap, Map<String, String> eventQueryMap, Map<String, String> beginSrcKeyMap, Map<String, String> endSrcKeyMap) {
            this._enableNumRowsQuery = enableNumRowsQuery;
            this._numRowsPrefetch = numRowsPrefetch;
            this._LOBPrefetchSize = LOBPrefetchSize;
            this._commitInterval = commitInterval;
            this._numRetries = numRetries;
            this._numRowsPerQuery = numRowsPerQuery;
            this._keyTxnFilesMap = keyTxnFilesMap;
            this._keyTxnBufferSizeMap = keyTxnBufferSizeMap;
            this._pKeyNameMap = pKeyNameMap;
            this._pKeyTypeMap = pKeyTypeMap;
            this._pKeyIndexMap = pKeyIndexMap;
            this._queryHintMap = queryHintMap;
            this._eventQueryMap = eventQueryMap;
            this._beginSrcKeyMap = beginSrcKeyMap;
            this._endSrcKeyMap = endSrcKeyMap;
        }
    }
}

