/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.utils;

import com.linkedin.databus.core.util.RateMonitor;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class DbusSeederBaseThread
extends Thread {
    private static final Logger LOG = Logger.getLogger(DbusSeederBaseThread.class);
    protected final AtomicBoolean _stop = new AtomicBoolean(false);
    protected final CountDownLatch _stopped = new CountDownLatch(1);
    protected final RateMonitor _rate;
    protected volatile Exception _exception;
    protected volatile boolean _isError;
    protected volatile boolean _started;

    public DbusSeederBaseThread(String name) {
        super(name);
        this._rate = new RateMonitor(name);
        this._isError = false;
    }

    public boolean done() {
        return this._started && !this.isAlive();
    }

    public void stop(boolean waitTillStop) {
        this._stop.set(true);
        this.interrupt();
        while (waitTillStop) {
            try {
                this._stopped.await();
                return;
            }
            catch (InterruptedException ie) {
                LOG.error((Object)("Got interrupted while waiting for SeederBase thread to stop. Thread Name is :" + this.getName()), (Throwable)ie);
            }
        }
    }

    public boolean isError() {
        return this._isError;
    }

    public Exception getException() {
        return this._exception;
    }

    public double getRate() {
        return this._rate.getRate();
    }
}

