/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.pub;

import com.linkedin.databus.client.pub.CheckpointPersistenceProvider;
import com.linkedin.databus.client.pub.RegistrationId;
import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.data_model.DatabusSubscription;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class CheckpointPersistenceProviderAbstract
implements CheckpointPersistenceProvider {
    protected final int _protocolVersion;
    private static final int DEFAULT_PROTOCOL_VERSION = 2;

    public CheckpointPersistenceProviderAbstract() {
        this(2);
    }

    public CheckpointPersistenceProviderAbstract(int protocolVersion) {
        this._protocolVersion = protocolVersion;
    }

    protected List<String> convertSubsToListOfStrings(List<DatabusSubscription> subs) {
        ArrayList<String> subsSrcStringList = new ArrayList<String>(subs.size());
        for (DatabusSubscription sub : subs) {
            if (this._protocolVersion >= 3) {
                subsSrcStringList.add(sub.uniqString());
                continue;
            }
            subsSrcStringList.add(sub.getLogicalSource().getName());
        }
        return subsSrcStringList;
    }

    @Override
    public void storeCheckpoint(List<String> sourceNames, Checkpoint checkpoint) throws IOException {
    }

    @Override
    public Checkpoint loadCheckpoint(List<String> sourceNames) {
        return null;
    }

    @Override
    public void removeCheckpoint(List<String> sourceNames) {
    }

    @Override
    public void storeCheckpointV3(List<DatabusSubscription> subs, Checkpoint checkpoint, RegistrationId registrationId) throws IOException {
        this.storeCheckpoint(this.convertSubsToListOfStrings(subs), checkpoint);
    }

    @Override
    public Checkpoint loadCheckpointV3(List<DatabusSubscription> subs, RegistrationId registrationId) {
        return this.loadCheckpoint(this.convertSubsToListOfStrings(subs));
    }

    @Override
    public void removeCheckpointV3(List<DatabusSubscription> subs, RegistrationId registrationId) {
        this.removeCheckpoint(this.convertSubsToListOfStrings(subs));
    }
}

