/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.pub;

import com.linkedin.databus.groupleader.impl.zkclient.GroupLeadershipConnectionZkClientImpl;
import com.linkedin.databus.groupleader.pub.AcceptLeadershipCallback;
import com.linkedin.databus.groupleader.pub.GroupLeadershipConnection;
import com.linkedin.databus.groupleader.pub.GroupLeadershipInfo;
import com.linkedin.databus.groupleader.pub.GroupLeadershipSession;
import java.util.List;
import org.apache.log4j.Logger;

public class DatabusClientGroupMember {
    private final GroupLeadershipConnection _groupConnection;
    private final AcceptLeadershipCallback _callback;
    private GroupLeadershipSession _groupSession;
    private final String _groupName;
    private final String _domainName;
    private final String _nodeName;
    private final boolean _requiresMastership;
    private final Logger _log = Logger.getLogger(this.getClass());
    private String _sharedDataPath = "shareddata";

    public DatabusClientGroupMember(String domainName, String groupName, String nodeName, String sharedDataPath, GroupLeadershipConnection connection, AcceptLeadershipCallback callback, boolean requiresMastership) {
        this._domainName = domainName;
        this._groupName = groupName;
        this._nodeName = nodeName;
        this._callback = callback;
        this._groupConnection = connection;
        this._groupSession = null;
        this._sharedDataPath = sharedDataPath;
        this._requiresMastership = requiresMastership;
    }

    public synchronized boolean joinWithoutLeadershipDuties() {
        if (null != this._groupConnection) {
            this._groupSession = this._groupConnection.joinGroupWithoutLeadershipDuties(this.getDomainName(), this.getGroupName(), this.getName());
            if (this._sharedDataPath != null && !this._sharedDataPath.isEmpty()) {
                this._groupSession.setSharedDataPath(this._sharedDataPath);
            }
        }
        return this._groupSession != null;
    }

    public DatabusClientGroupMember(String domainName, String groupName, String nodeName, String sharedDataPath, GroupLeadershipConnection connection, AcceptLeadershipCallback callback) {
        this(domainName, groupName, nodeName, sharedDataPath, connection, callback, true);
    }

    public DatabusClientGroupMember(String domainName, String groupName, String nodeName, GroupLeadershipConnection connection) {
        this(domainName, groupName, nodeName, null, connection, null, true);
    }

    public DatabusClientGroupMember(String domainName, String groupName, String nodeName, GroupLeadershipConnection connection, AcceptLeadershipCallback callback) {
        this(domainName, groupName, nodeName, null, connection, callback, true);
    }

    public DatabusClientGroupMember(String domainName, String groupName, String nodeName, String sharedDataPath, GroupLeadershipConnection connection) {
        this(domainName, groupName, nodeName, sharedDataPath, connection, null, true);
    }

    public synchronized boolean join() {
        if (null != this._groupConnection) {
            AcceptLeadershipCallback leaderCallback = this._callback != null ? this._callback : new DefaultLeaderCallBack();
            this._groupSession = this._groupConnection.joinGroup(this.getDomainName(), this.getGroupName(), this.getName(), leaderCallback);
            if (this._sharedDataPath != null && !this._sharedDataPath.isEmpty()) {
                this._groupSession.setSharedDataPath(this._sharedDataPath);
            }
        }
        return this._groupSession != null;
    }

    public synchronized boolean leave() {
        if (this._groupSession != null) {
            this._groupSession.leaveGroup();
            this._groupSession = null;
            this.notifyAll();
            return true;
        }
        return false;
    }

    public boolean waitForLeaderShip() {
        return this.waitForLeaderShip(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForLeaderShip(int timeOutInMs) {
        try {
            if (this._callback != null) {
                return true;
            }
            DatabusClientGroupMember databusClientGroupMember = this;
            synchronized (databusClientGroupMember) {
                if (this._groupSession != null && this._groupSession.isLeader()) {
                    return true;
                }
                if (timeOutInMs < 0) {
                    timeOutInMs = 0;
                }
                long remainingTime = timeOutInMs;
                long start = System.currentTimeMillis();
                while (!(this._groupSession == null || this._groupSession.isLeader() || timeOutInMs != 0 && remainingTime <= 0L)) {
                    this.wait(remainingTime);
                    this._log.info((Object)("Waiting for leadership on node " + this.toString() + " awoken"));
                    if (timeOutInMs <= 0) continue;
                    remainingTime -= System.currentTimeMillis() - start;
                }
                return this._groupSession == null ? false : this._groupSession.isLeader();
            }
        }
        catch (InterruptedException e) {
            this._log.error((Object)("Waiting for leadership on node" + this.toString() + " interrupted "));
            return false;
        }
    }

    public synchronized boolean removeSharedData(String key) {
        if (this._groupSession != null) {
            if (!this._requiresMastership || this._groupSession.isLeader()) {
                return this._groupSession.removeGroupData(key);
            }
            this._log.error((Object)("Remove failed! Attempted when " + this.toString() + " was not leader!"));
        }
        return false;
    }

    public boolean removeSharedData() {
        return this.removeSharedData(null);
    }

    public Object readSharedData() {
        return this.readSharedData(null);
    }

    public synchronized Object readSharedData(String key) {
        if (this._groupSession != null) {
            return this._groupSession.readGroupData(key);
        }
        return null;
    }

    public synchronized boolean writeSharedData(String key, Object obj) {
        if (this._groupSession != null) {
            if (!this._requiresMastership || this._groupSession.isLeader()) {
                return this._groupSession.writeGroupData(key, obj);
            }
            this._log.error((Object)("Write failed! Attempted when " + this.toString() + " was not leader!"));
        }
        return false;
    }

    public boolean writeSharedData(Object obj) {
        return this.writeSharedData(null, obj);
    }

    public String getName() {
        return this._nodeName;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public String getDomainName() {
        return this._domainName;
    }

    public String toString() {
        return this.getDomainName() + "/" + this.getGroupName() + "/" + this.getName();
    }

    public synchronized boolean isLeader() {
        if (this._groupSession != null) {
            return this._groupSession.isLeader();
        }
        return false;
    }

    public synchronized String getLeader() {
        if (this._groupSession != null) {
            return this._groupSession.getLeaderName();
        }
        return null;
    }

    public synchronized List<String> getMembers() {
        if (this._groupSession != null) {
            GroupLeadershipInfo info = this._groupSession.getGroupLeadershipInfo();
            return info.getMemberNames();
        }
        return null;
    }

    public synchronized List<String> getSharedKeys() {
        if (this._groupSession != null) {
            return this._groupSession.getKeysOfGroupData();
        }
        return null;
    }

    public synchronized boolean createPaths() {
        if (this._groupConnection != null) {
            return ((GroupLeadershipConnectionZkClientImpl)this._groupConnection).createBasePath(this.getDomainName(), this.getGroupName());
        }
        return false;
    }

    protected class DefaultLeaderCallBack
    implements AcceptLeadershipCallback {
        protected DefaultLeaderCallBack() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doAcceptLeadership(GroupLeadershipSession groupLeadershipSession) {
            DatabusClientGroupMember databusClientGroupMember = DatabusClientGroupMember.this;
            synchronized (databusClientGroupMember) {
                DatabusClientGroupMember.this._log.info((Object)("Node acquired leadership: " + DatabusClientGroupMember.this.toString()));
                DatabusClientGroupMember.this.notify();
            }
        }
    }
}

