/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.pub;

import com.linkedin.databus.client.pub.DatabusClientGroupMember;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus.groupleader.impl.zkclient.GroupLeadershipConnectionFactoryZkClientImpl;
import com.linkedin.databus.groupleader.pub.GroupLeadershipConnection;
import java.util.HashMap;
import java.util.Random;
import org.apache.log4j.Logger;

public class DatabusClientNode {
    public static final String MODULE = DatabusClientNode.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private HashMap<String, DatabusClientGroupMember> _members;
    private GroupLeadershipConnection _connection = null;
    private final StaticConfig _config;

    public DatabusClientNode(StaticConfig config) throws InvalidConfigException {
        this._config = config;
        if (config.isEnabled()) {
            if (config.getClusterServerList().isEmpty()) {
                throw new InvalidConfigException("Property val is empty! clusterServerList ");
            }
            this._members = new HashMap();
            this.open();
        }
    }

    void open() {
        if (this.isEnabled()) {
            GroupLeadershipConnectionFactoryZkClientImpl groupLeadershipConnFactory = new GroupLeadershipConnectionFactoryZkClientImpl(this._config.getClusterServerList(), this._config.getSessionTimeoutMillis(), this._config.getConnectionTimeoutMillis());
            this._connection = groupLeadershipConnFactory.getConnection();
            this.addMember(this._config.getDomain(), this._config.getGroup(), this._config.getName(), this._config.getSharedDataPath(), this._config.isMastershipRequiredForWrite());
        }
    }

    public DatabusClientNode(Config config) throws InvalidConfigException {
        this(config.build());
    }

    public boolean isEnabled() {
        return this._config.isEnabled();
    }

    public boolean isConnected() {
        return this._connection != null;
    }

    public StaticConfig getStaticConfig() {
        return this._config;
    }

    public HashMap<String, DatabusClientGroupMember> getMembers() {
        return this._members;
    }

    public DatabusClientGroupMember getMember(String domain, String group, String name) {
        if (this.isConnected()) {
            String key = this.makeKey(domain, group, name);
            return this._members.get(key);
        }
        return null;
    }

    public DatabusClientGroupMember addMember(String domain, String group, String name, String sharedDataPath, boolean requiredMastership) {
        if (this.isConnected()) {
            String key = this.makeKey(domain, group, name);
            if (!this._members.containsKey(key)) {
                DatabusClientGroupMember member = new DatabusClientGroupMember(domain, group, name, sharedDataPath, this._connection, null, requiredMastership);
                this._members.put(key, member);
                return member;
            }
            LOG.info((Object)("Error! Inserting duplicate member with key: " + key));
        }
        return null;
    }

    public boolean removeMember(String domain, String group, String name) {
        if (this.isConnected()) {
            String key = this.makeKey(domain, group, name);
            DatabusClientGroupMember groupMember = this.getMember(domain, group, name);
            if (groupMember != null) {
                groupMember.leave();
                this._members.remove(key);
                return true;
            }
        }
        return false;
    }

    private String makeKey(String domain, String group, String name) {
        return domain + "_" + group + "_" + name;
    }

    public void join() {
        if (this._connection != null) {
            for (DatabusClientGroupMember member : this._members.values()) {
                member.join();
            }
        }
    }

    public void leave() {
        if (this._connection != null) {
            for (DatabusClientGroupMember member : this._members.values()) {
                member.leave();
            }
        }
    }

    public void close() {
        if (this._connection != null) {
            this._members.clear();
            this._connection.close();
        }
    }

    public static class Config
    implements ConfigBuilder<StaticConfig> {
        private String _clusterServerList = "";
        private int _sessionTimeoutMillis = 5000;
        private int _connectionTimeoutMillis = 10000;
        private String _group = "default-databus-group";
        private String _domain = "/Databus-Client-Domain";
        private String _name = "default-name";
        private boolean _enabled = false;
        private boolean _mastershipRequiredForWrite = true;
        private String _sharedDataPath = null;

        public Config() {
            Random r = new Random(System.currentTimeMillis());
            this._name = this._name + r.nextInt();
        }

        public String getClusterServerList() {
            return this._clusterServerList;
        }

        public int getSessionTimeoutMillis() {
            return this._sessionTimeoutMillis;
        }

        public int getConnectionTimeoutMillis() {
            return this._connectionTimeoutMillis;
        }

        public void setClusterServerList(String clusterServerList) {
            this._clusterServerList = clusterServerList;
        }

        public void setSessionTimeoutMillis(int sessionTimeoutMillis) {
            this._sessionTimeoutMillis = sessionTimeoutMillis;
        }

        public void setConnectionTimeoutMillis(int connectionTimeoutMillis) {
            this._connectionTimeoutMillis = connectionTimeoutMillis;
        }

        public StaticConfig build() throws InvalidConfigException {
            return new StaticConfig(this._enabled, this._clusterServerList, this._sessionTimeoutMillis, this._connectionTimeoutMillis, this._domain, this._group, this._name, this._mastershipRequiredForWrite, this._sharedDataPath);
        }

        public String getGroup() {
            return this._group;
        }

        public String getDomain() {
            return this._domain;
        }

        public String getName() {
            return this._name;
        }

        public void setGroup(String group) {
            this._group = group;
        }

        public void setDomain(String domain) {
            this._domain = domain;
        }

        public void setName(String name) {
            this._name = name;
        }

        public boolean isEnabled() {
            return this._enabled;
        }

        public void setEnabled(boolean enabled) {
            this._enabled = enabled;
        }

        public boolean isMastershipRequiredForWrite() {
            return this._mastershipRequiredForWrite;
        }

        public void setMastershipRequiredForWrite(boolean requireMastershipForWrite) {
            this._mastershipRequiredForWrite = requireMastershipForWrite;
        }

        public String getSharedDataPath() {
            return this._sharedDataPath;
        }

        public void setSharedDataPath(String sharedDataPath) {
            this._sharedDataPath = sharedDataPath;
        }
    }

    public static class StaticConfig {
        private final boolean _enabled;
        private final String _clusterServerList;
        private final int _sessionTimeoutMillis;
        private final int _connectionTimeoutMillis;
        private final String _group;
        private final String _domain;
        private final String _name;
        private final boolean _mastershipRequiredForWrite;
        private final String _sharedDataPath;

        public StaticConfig(boolean enabled, String clusterServerList, int sessionTimeoutMillis, int connectionTimeoutMillis, String domain, String group, String name, boolean requiresMastership, String sharedDataPath) {
            this._enabled = enabled;
            this._clusterServerList = clusterServerList;
            this._sessionTimeoutMillis = sessionTimeoutMillis;
            this._connectionTimeoutMillis = connectionTimeoutMillis;
            this._domain = domain;
            this._name = name;
            this._group = group;
            this._mastershipRequiredForWrite = requiresMastership;
            this._sharedDataPath = sharedDataPath;
        }

        public String getSharedDataPath() {
            return this._sharedDataPath;
        }

        public String getClusterServerList() {
            return this._clusterServerList;
        }

        public int getSessionTimeoutMillis() {
            return this._sessionTimeoutMillis;
        }

        public int getConnectionTimeoutMillis() {
            return this._connectionTimeoutMillis;
        }

        public String getGroup() {
            return this._group;
        }

        public String getDomain() {
            return this._domain;
        }

        public String getName() {
            return this._name;
        }

        public boolean isMastershipRequiredForWrite() {
            return this._mastershipRequiredForWrite;
        }

        public boolean isEnabled() {
            return this._enabled;
        }
    }
}

