/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.pub;

import com.linkedin.databus.client.pub.DatabusServerCoordinates;
import com.linkedin.databus.core.data_model.DatabusSubscription;
import com.linkedin.databus.core.data_model.LegacySubscriptionUriCodec;
import com.linkedin.databus.core.data_model.SubscriptionUriCodec;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.core.DatabusException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class ServerInfo
implements Comparable<ServerInfo> {
    public static final String MODULE = ServerInfo.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    protected final DatabusServerCoordinates _serverCoordinates;
    protected final List<String> _sources;
    protected final List<DatabusSubscription> _subs;
    protected String _jsonString;
    private String _PhysicalSourceName = "DefaultPhysicalSource";

    public ServerInfo(String name, String state, InetSocketAddress address, List<String> sources) {
        this._serverCoordinates = new DatabusServerCoordinates(name, address, state);
        this._sources = sources;
        List subsList = null;
        try {
            subsList = DatabusSubscription.createFromUriList(sources);
        }
        catch (DatabusException e) {
            LOG.warn((Object)("unable to parse sources list: " + e.getMessage()), (Throwable)e);
            subsList = Collections.emptyList();
        }
        catch (URISyntaxException e) {
            LOG.warn((Object)("unable to parse sources list: " + e.getMessage()), (Throwable)e);
            subsList = Collections.emptyList();
        }
        this._subs = subsList;
    }

    public ServerInfo(String name, DatabusServerCoordinates.StateId state, InetSocketAddress address, Collection<DatabusSubscription> subs, SubscriptionUriCodec uriCodec) {
        this._serverCoordinates = new DatabusServerCoordinates(name, address, state);
        this._subs = new ArrayList<DatabusSubscription>(subs);
        if (null == uriCodec) {
            this._sources = DatabusSubscription.createUriStringList(this._subs, (SubscriptionUriCodec)LegacySubscriptionUriCodec.getInstance());
        } else {
            this._sources = new ArrayList<String>(subs.size());
            for (DatabusSubscription sub : subs) {
                String uri = uriCodec.encode(sub).toString();
                this._sources.add(uri);
            }
        }
    }

    public ServerInfo(String name, String state, InetSocketAddress address, String ... sources) {
        this(name, state, address, Arrays.asList(sources));
    }

    public String getPhysicalSourceName() {
        return this._PhysicalSourceName;
    }

    public void setPhysicalSourceName(String PhysicalSourceName) {
        this._PhysicalSourceName = PhysicalSourceName;
    }

    public String getName() {
        return this._serverCoordinates.getName();
    }

    public InetSocketAddress getAddress() {
        return this._serverCoordinates.getAddress();
    }

    public List<String> getSources() {
        return this._sources;
    }

    public List<DatabusSubscription> getSubs() {
        return this._subs;
    }

    public String toJsonString() {
        if (null == this._jsonString) {
            StringWriter out = new StringWriter();
            ObjectMapper objMapper = new ObjectMapper();
            try {
                objMapper.writeValue((Writer)out, (Object)this);
                this._jsonString = out.toString();
            }
            catch (Exception e) {
                this._jsonString = "serialiationError";
            }
        }
        return this._jsonString;
    }

    public String toString() {
        return this.toJsonString();
    }

    public StringBuilder toSimpleString(StringBuilder sb) {
        if (null == sb) {
            sb = new StringBuilder(200);
        }
        sb.append("[server=").append(this._serverCoordinates).append(", subs=[");
        boolean notFirst = false;
        for (DatabusSubscription sub : this._subs) {
            if (notFirst) {
                sb.append(",");
            }
            sb.append(sub.toSimpleString());
            notFirst = true;
        }
        sb.append("]]");
        return sb;
    }

    public String toSimpleString() {
        return this.toSimpleString(null).toString();
    }

    public boolean supportsSources(List<String> sources) {
        return ServerInfo.checkSubsequence(sources, this.getSources());
    }

    public static boolean checkSubsequence(List<String> sources, List<String> serverSources) {
        int maxPos = 0;
        for (String source : sources) {
            while (maxPos < serverSources.size() && !serverSources.get(maxPos).equals(source)) {
                ++maxPos;
            }
            if (maxPos != serverSources.size()) continue;
            return false;
        }
        return true;
    }

    public static boolean checkSubsequenceSubsV3(List<DatabusSubscription> subs, List<DatabusSubscription> serverSubs) {
        int maxPos = 0;
        for (DatabusSubscription sub : subs) {
            while (maxPos < serverSubs.size() && !serverSubs.get(maxPos).equals((Object)sub)) {
                ++maxPos;
            }
            if (maxPos != serverSubs.size()) continue;
            return false;
        }
        return true;
    }

    public static ServerInfo buildServerInfoFromHostPort(String serverHostPort, String hostPortDelim) throws Exception {
        ServerInfo serverInfo = null;
        try {
            String[] hostInfo;
            if (null != serverHostPort && (hostInfo = serverHostPort.split(hostPortDelim)).length == 2) {
                InetSocketAddress address = new InetSocketAddress(InetAddress.getByName(hostInfo[0]), Integer.parseInt(hostInfo[1]));
                serverInfo = new ServerInfo(serverHostPort, DatabusServerCoordinates.StateId.ONLINE.toString(), address, new String[0]);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Unable to extract Boostrap Server info from StartSCN response. ServerInfo was :" + serverHostPort), (Throwable)ex);
            throw ex;
        }
        return serverInfo;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof ServerInfo)) {
            return false;
        }
        ServerInfo other = (ServerInfo)obj;
        return this.getAddress().equals(other.getAddress());
    }

    public int hashCode() {
        return this.getAddress().hashCode();
    }

    @Override
    public int compareTo(ServerInfo o) {
        return this._serverCoordinates.compareTo(o._serverCoordinates);
    }

    public static class ServerInfoSetBuilder
    implements ConfigBuilder<List<ServerInfo>> {
        public static final char SERVER_INFO_SEPARATOR = ';';
        private String _servers;

        public List<ServerInfo> build() throws InvalidConfigException {
            if (null == this._servers) {
                return Collections.emptyList();
            }
            String[] serverInfos = this._servers.split("[;]");
            ServerInfoBuilder siBuilder = new ServerInfoBuilder();
            ArrayList<ServerInfo> result = new ArrayList<ServerInfo>(serverInfos.length);
            for (String s : serverInfos) {
                siBuilder.setAddress(s);
                result.add(siBuilder.build());
            }
            return result;
        }

        public String getServers() {
            return this._servers;
        }

        public void setServers(String servers) {
            this._servers = servers;
        }
    }

    public static class ServerInfoBuilder
    implements ConfigBuilder<ServerInfo> {
        public static final char NAME_SEPARATOR = ')';
        public static final char PORT_SEPARATOR = ':';
        public static final char SOURCES_LIST_SEPARATOR = ':';
        public static final char SOURCE_SEPARATOR = ',';
        private String _host = "localhost";
        private int _port = 9000;
        private String _sources = "";
        private String _name = null;
        private String _address = null;
        private String _PhysicalSourceName = "DefaultPhysicalSource";
        private SubscriptionUriCodec _uriCodec = LegacySubscriptionUriCodec.getInstance();
        private final List<DatabusSubscription.Builder> _subs = new ArrayList<DatabusSubscription.Builder>();

        public static String generateServerName(String prefix, int id) {
            StringBuilder resBuilder = new StringBuilder();
            resBuilder.append(prefix);
            resBuilder.append('.');
            resBuilder.append(id);
            return resBuilder.toString();
        }

        public String getPhysicalSourceName() {
            return this._PhysicalSourceName;
        }

        public void setPhysicalSourceName(String PhysicalSourceName) {
            this._PhysicalSourceName = PhysicalSourceName;
        }

        public String getHost() {
            return this._host;
        }

        public void setHost(String host) {
            this._host = host;
        }

        public String getSources() {
            return this._sources;
        }

        public void setSources(String sources) {
            this._sources = sources;
        }

        public int getPort() {
            return this._port;
        }

        public void setPort(int port) {
            this._port = port;
        }

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public String getAddress() {
            return this._address;
        }

        public void setAddress(String address) {
            this._address = address;
        }

        public ServerInfo build() throws InvalidConfigException {
            if (null != this._address) {
                this.parseAddress();
            }
            String[] sources = this.getSources().split("[,]");
            for (int i = 0; i < sources.length; ++i) {
                sources[i] = sources[i].trim();
            }
            InetAddress serverAddr = null;
            try {
                serverAddr = InetAddress.getByName(this.getHost());
            }
            catch (Exception e) {
                throw new InvalidConfigException("Invalid server address", (Throwable)e);
            }
            InetSocketAddress inetAddress = new InetSocketAddress(serverAddr, this.getPort());
            if (null == this._name) {
                StringBuilder serverName = new StringBuilder();
                try {
                    serverName.append(serverAddr.getHostName());
                }
                catch (Exception e) {
                    LOG.warn((Object)("Unable to resolve address:" + serverAddr.toString()));
                    serverName.append("server");
                }
                this._name = serverName.toString();
            }
            LOG.info((Object)("res name: " + this._name));
            ServerInfo serverInfo = new ServerInfo(this._name, DatabusServerCoordinates.StateId.ONLINE.toString(), inetAddress, sources);
            serverInfo.setPhysicalSourceName(this.getPhysicalSourceName());
            return serverInfo;
        }

        public static String generateAddress(String name, String host, int port, String ... sources) {
            StringBuilder res = new StringBuilder((null != name ? name.length() : 0) + host.length() + 8 + sources.length * 50);
            if (null != name && name.length() > 0) {
                res.append(name);
                res.append(')');
            }
            res.append(host);
            res.append(':');
            res.append(port);
            res.append(':');
            boolean first = true;
            for (String s : sources) {
                if (!first) {
                    res.append(',');
                }
                first = false;
                res.append(s);
            }
            return res.toString();
        }

        void parseAddress() throws InvalidConfigException {
            int portIdx;
            int nameIdx = this._address.indexOf(41);
            if (0 < nameIdx) {
                this.setName(this._address.substring(0, nameIdx));
            }
            if (0 > (portIdx = this._address.indexOf(58, nameIdx + 1))) {
                throw new InvalidConfigException("no port specified in address:" + this._address);
            }
            this.setHost(this._address.substring(nameIdx + 1, portIdx));
            int sourceListIdx = this._address.indexOf(58, portIdx + 1);
            if (0 > sourceListIdx) {
                throw new InvalidConfigException("no sources list specified in address:" + this._address);
            }
            this.setPort(Integer.parseInt(this._address.substring(portIdx + 1, sourceListIdx)));
            this.setSources(this._address.substring(sourceListIdx + 1));
        }

        public void uriCodec(SubscriptionUriCodec uriCodec) {
            this._uriCodec = uriCodec;
        }

        public SubscriptionUriCodec uriCodec() {
            return this._uriCodec;
        }

        public DatabusSubscription.Builder getSub(int index) {
            this.ensureSubsListIndex(index);
            return this._subs.get(index);
        }

        private void ensureSubsListIndex(int targetIndex) {
            for (int i = this._subs.size(); i <= targetIndex; ++i) {
                this._subs.add(new DatabusSubscription.Builder());
            }
        }
    }
}

