/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client;

import com.linkedin.databus.client.pub.SCN;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.codehaus.jackson.map.ObjectMapper;

public class SingleSourceSCN
implements SCN {
    private static final long serialVersionUID = 1L;
    private final int _sourceId;
    private final long _sequence;
    private String _jsonString = null;

    public SingleSourceSCN(int sourceId, long sequence) {
        this._sequence = sequence;
        this._sourceId = sourceId;
    }

    public int compareTo(SCN otherSCN) {
        if (null == otherSCN || !this.isComparable(otherSCN)) {
            return -1;
        }
        SingleSourceSCN other = (SingleSourceSCN)otherSCN;
        return (int)(this.getSequence() - other.getSequence());
    }

    public boolean equals(Object o) {
        if (null == o || !(o instanceof SingleSourceSCN)) {
            return false;
        }
        SingleSourceSCN other = (SingleSourceSCN)o;
        return this.getSequence() == other.getSequence();
    }

    public int hashCode() {
        return (int)this.getSequence();
    }

    public boolean isComparable(SCN otherSCN) {
        if (!(otherSCN instanceof SingleSourceSCN)) {
            return false;
        }
        SingleSourceSCN other = (SingleSourceSCN)otherSCN;
        return this.getSourceId() == other.getSourceId();
    }

    public String toJsonString() {
        if (null == this._jsonString) {
            StringWriter jsonBuilder = new StringWriter(1000);
            ObjectMapper mapper = new ObjectMapper();
            try {
                mapper.writeValue((Writer)jsonBuilder, (Object)this);
                this._jsonString = jsonBuilder.toString();
            }
            catch (IOException e) {
                this._jsonString = "Serialization error";
            }
            catch (RuntimeException e) {
                this._jsonString = "Serialization error";
            }
        }
        return this._jsonString;
    }

    public String toString() {
        return this.toJsonString();
    }

    public int getSourceId() {
        return this._sourceId;
    }

    public long getSequence() {
        return this._sequence;
    }
}

