/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.consumer;

import com.linkedin.databus.client.consumer.ConsumerCallable;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import com.linkedin.databus.client.pub.DatabusCombinedConsumer;
import com.linkedin.databus.client.pub.DbusEventDecoder;
import com.linkedin.databus.client.pub.mbean.ConsumerCallbackStats;
import com.linkedin.databus.client.pub.mbean.UnifiedClientStats;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventInternalWritable;

class BootstrapDataEventCallable
extends ConsumerCallable<ConsumerCallbackResult> {
    private final DbusEvent _event;
    private final DbusEventDecoder _eventDecoder;
    private final DatabusCombinedConsumer _consumer;
    private final ConsumerCallbackStats _consumerStats;
    private final UnifiedClientStats _unifiedClientStats;

    public BootstrapDataEventCallable(long currentNanos, DbusEvent e, DbusEventDecoder eventDecoder, DatabusCombinedConsumer consumer) {
        this(currentNanos, e, eventDecoder, consumer, null, null);
    }

    public BootstrapDataEventCallable(long currentNanos, DbusEvent e, DbusEventDecoder eventDecoder, DatabusCombinedConsumer consumer, ConsumerCallbackStats consumerStats, UnifiedClientStats unifiedClientStats) {
        super(currentNanos);
        if (!(e instanceof DbusEventInternalWritable)) {
            throw new UnsupportedClassVersionError("Cannot support cloning on non-DbusEvent");
        }
        this._event = ((DbusEventInternalWritable)e).clone(null);
        this._eventDecoder = eventDecoder;
        this._consumer = consumer;
        this._consumerStats = consumerStats;
        this._unifiedClientStats = unifiedClientStats;
    }

    @Override
    protected ConsumerCallbackResult doCall() throws Exception {
        return this._consumer.onBootstrapEvent(this._event, this._eventDecoder);
    }

    @Override
    protected void doEndCall(ConsumerCallbackResult result) {
        if (result == ConsumerCallbackResult.ERROR || result == ConsumerCallbackResult.ERROR_FATAL) {
            if (this._consumerStats != null) {
                this._consumerStats.registerDataErrorsProcessed();
            }
            if (this._unifiedClientStats != null) {
                this._unifiedClientStats.registerCallbackError();
            }
        } else {
            long nanoRunTime = this.getNanoRunTime();
            if (this._consumerStats != null) {
                long totalTime = (nanoRunTime + this.getNanoTimeInQueue()) / 1000000L;
                this._consumerStats.registerDataEventsProcessed(1, totalTime, this._event);
            }
            if (this._unifiedClientStats != null) {
                this._unifiedClientStats.registerCallbacksProcessed(nanoRunTime);
            }
        }
    }
}

