/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.consumer;

import com.linkedin.databus.client.SingleSourceSCN;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import com.linkedin.databus.client.pub.DatabusCombinedConsumer;
import com.linkedin.databus.client.pub.DbusEventDecoder;
import com.linkedin.databus.client.pub.SCN;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventBufferAppendable;
import com.linkedin.databus.core.DbusEventKey;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.seq.MaxSCNWriter;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.log4j.Logger;

public class DatabusConsumerEventBuffer
implements DatabusCombinedConsumer {
    private final DbusEventBufferAppendable _eventBuffer;
    private final DbusEventsStatisticsCollector _stats;
    private final MaxSCNWriter _scnWriter;
    public static final String MODULE = DatabusConsumerEventBuffer.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);

    public DatabusConsumerEventBuffer(DbusEventBufferAppendable buffer, DbusEventsStatisticsCollector stats, MaxSCNWriter scnWriter) {
        this._eventBuffer = buffer;
        this._stats = stats;
        this._scnWriter = scnWriter;
    }

    public void setStartSCN(long scn) {
        this._eventBuffer.start(scn);
    }

    public long getStartSCN() {
        return this._eventBuffer.getPrevScn();
    }

    public ConsumerCallbackResult onStartConsumption() {
        LOG.info((Object)"Started consumption");
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onStopConsumption() {
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onStartDataEventSequence(SCN startScn) {
        long scn = ((SingleSourceSCN)startScn).getSequence();
        if (this.getStartSCN() <= 0L) {
            this.setStartSCN(scn - 1L);
            LOG.warn((Object)("onStartDataSequence: Eventbuffer start scn = " + this.getStartSCN()));
        }
        this._eventBuffer.startEvents();
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onEndDataEventSequence(SCN endScn) {
        long endSCN = ((SingleSourceSCN)endScn).getSequence();
        this._eventBuffer.endEvents(endSCN, this._stats);
        if (this._scnWriter != null) {
            try {
                this._scnWriter.saveMaxScn(endSCN);
            }
            catch (DatabusException e) {
                LOG.warn((Object)("Unable to save scn=" + endSCN + ": " + (Object)((Object)e)));
                return ConsumerCallbackResult.SUCCESS;
            }
        }
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onRollback(SCN rollbackScn) {
        long endSCN = ((SingleSourceSCN)rollbackScn).getSequence();
        LOG.warn((Object)("Rollback called with SCN=" + endSCN + " lastWrittenScn of buffer= " + this._eventBuffer.lastWrittenScn()));
        this._eventBuffer.rollbackEvents();
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onStartSource(String source, Schema sourceSchema) {
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onEndSource(String source, Schema sourceSchema) {
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onDataEvent(DbusEvent e, DbusEventDecoder eventDecoder) {
        DbusEventKey k = e.isKeyNumber() ? new DbusEventKey(e.key()) : new DbusEventKey(e.keyBytes());
        ByteBuffer payload = e.value();
        byte[] value = new byte[payload.limit()];
        payload.get(value, 0, value.length);
        payload.position(0);
        this._eventBuffer.appendEvent(k, e.physicalPartitionId(), e.logicalPartitionId(), e.timestampInNanos(), e.srcId(), e.schemaId(), value, false, this._stats);
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onCheckpoint(SCN checkpointScn) {
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onError(Throwable err) {
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onStartBootstrap() {
        return this.onStartConsumption();
    }

    public ConsumerCallbackResult onStopBootstrap() {
        return this.onStopConsumption();
    }

    public ConsumerCallbackResult onStartBootstrapSequence(SCN startScn) {
        return this.onStartDataEventSequence(startScn);
    }

    public ConsumerCallbackResult onEndBootstrapSequence(SCN endScn) {
        return this.onEndDataEventSequence(endScn);
    }

    public ConsumerCallbackResult onStartBootstrapSource(String sourceName, Schema sourceSchema) {
        return this.onStartSource(sourceName, sourceSchema);
    }

    public ConsumerCallbackResult onEndBootstrapSource(String name, Schema sourceSchema) {
        return this.onEndSource(name, sourceSchema);
    }

    public ConsumerCallbackResult onBootstrapEvent(DbusEvent e, DbusEventDecoder eventDecoder) {
        return this.onDataEvent(e, eventDecoder);
    }

    public ConsumerCallbackResult onBootstrapRollback(SCN batchCheckpointScn) {
        return this.onRollback(batchCheckpointScn);
    }

    public ConsumerCallbackResult onBootstrapCheckpoint(SCN checkpointScn) {
        return this.onCheckpoint(checkpointScn);
    }

    public ConsumerCallbackResult onBootstrapError(Throwable err) {
        return this.onError(err);
    }

    public boolean canBootstrap() {
        return true;
    }
}

