/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.consumer;

import com.linkedin.databus.client.consumer.CheckpointCallable;
import com.linkedin.databus.client.consumer.ConsumerCallable;
import com.linkedin.databus.client.consumer.ConsumerCallbackFactory;
import com.linkedin.databus.client.consumer.EndDataEventSequenceCallable;
import com.linkedin.databus.client.consumer.EndSourceCallable;
import com.linkedin.databus.client.consumer.OnDataEventCallable;
import com.linkedin.databus.client.consumer.OnErrorCallable;
import com.linkedin.databus.client.consumer.RollbackCallable;
import com.linkedin.databus.client.consumer.StartConsumptionCallable;
import com.linkedin.databus.client.consumer.StartDataEventSequenceCallable;
import com.linkedin.databus.client.consumer.StartSourceCallable;
import com.linkedin.databus.client.consumer.StopConsumptionCallable;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import com.linkedin.databus.client.pub.DatabusCombinedConsumer;
import com.linkedin.databus.client.pub.DbusEventDecoder;
import com.linkedin.databus.client.pub.SCN;
import com.linkedin.databus.client.pub.mbean.ConsumerCallbackStats;
import com.linkedin.databus.client.pub.mbean.UnifiedClientStats;
import com.linkedin.databus.core.DbusEvent;
import org.apache.avro.Schema;

public class StreamConsumerCallbackFactory
implements ConsumerCallbackFactory<DatabusCombinedConsumer> {
    protected final ConsumerCallbackStats _consumerStats;
    protected final UnifiedClientStats _unifiedClientStats;

    public StreamConsumerCallbackFactory(ConsumerCallbackStats consumerStats, UnifiedClientStats unifiedClientStats) {
        this._consumerStats = consumerStats;
        this._unifiedClientStats = unifiedClientStats;
    }

    @Override
    public ConsumerCallable<ConsumerCallbackResult> createCheckpointCallable(long currentNanos, SCN scn, DatabusCombinedConsumer consumer, boolean updateStats) {
        if (updateStats) {
            return new CheckpointCallable(currentNanos, scn, consumer, this._consumerStats, this._unifiedClientStats);
        }
        return new CheckpointCallable(currentNanos, scn, consumer, null, null);
    }

    @Override
    public ConsumerCallable<ConsumerCallbackResult> createDataEventCallable(long currentNanos, DbusEvent e, DbusEventDecoder eventDecoder, DatabusCombinedConsumer consumer, boolean updateStats) {
        if (updateStats) {
            return new OnDataEventCallable(currentNanos, e, eventDecoder, consumer, this._consumerStats, this._unifiedClientStats);
        }
        return new OnDataEventCallable(currentNanos, e, eventDecoder, consumer, null, null);
    }

    @Override
    public ConsumerCallable<ConsumerCallbackResult> createEndConsumptionCallable(long currentNanos, DatabusCombinedConsumer consumer, boolean updateStats) {
        if (updateStats) {
            return new StopConsumptionCallable(currentNanos, consumer, this._consumerStats, this._unifiedClientStats);
        }
        return new StopConsumptionCallable(currentNanos, consumer, null, null);
    }

    @Override
    public ConsumerCallable<ConsumerCallbackResult> createEndDataEventSequenceCallable(long currentNanos, SCN scn, DatabusCombinedConsumer consumer, boolean updateStats) {
        if (updateStats) {
            return new EndDataEventSequenceCallable(currentNanos, scn, consumer, this._consumerStats, this._unifiedClientStats);
        }
        return new EndDataEventSequenceCallable(currentNanos, scn, consumer, null, null);
    }

    @Override
    public ConsumerCallable<ConsumerCallbackResult> createEndSourceCallable(long currentNanos, String source, Schema sourceSchema, DatabusCombinedConsumer consumer, boolean updateStats) {
        if (updateStats) {
            return new EndSourceCallable(currentNanos, source, sourceSchema, consumer, this._consumerStats, this._unifiedClientStats);
        }
        return new EndSourceCallable(currentNanos, source, sourceSchema, consumer, null, null);
    }

    @Override
    public ConsumerCallable<ConsumerCallbackResult> createRollbackCallable(long currentNanos, SCN scn, DatabusCombinedConsumer consumer, boolean updateStats) {
        if (updateStats) {
            return new RollbackCallable(currentNanos, scn, consumer, this._consumerStats, this._unifiedClientStats);
        }
        return new RollbackCallable(currentNanos, scn, consumer, null, null);
    }

    @Override
    public ConsumerCallable<ConsumerCallbackResult> createStartConsumptionCallable(long currentNanos, DatabusCombinedConsumer consumer, boolean updateStats) {
        if (updateStats) {
            return new StartConsumptionCallable(currentNanos, consumer, this._consumerStats, this._unifiedClientStats);
        }
        return new StartConsumptionCallable(currentNanos, consumer, null, null);
    }

    @Override
    public ConsumerCallable<ConsumerCallbackResult> createStartDataEventSequenceCallable(long currentNanos, SCN scn, DatabusCombinedConsumer consumer, boolean updateStats) {
        if (updateStats) {
            return new StartDataEventSequenceCallable(currentNanos, scn, consumer, this._consumerStats, this._unifiedClientStats);
        }
        return new StartDataEventSequenceCallable(currentNanos, scn, consumer, null, null);
    }

    @Override
    public ConsumerCallable<ConsumerCallbackResult> createStartSourceCallable(long currentNanos, String source, Schema sourceSchema, DatabusCombinedConsumer consumer, boolean updateStats) {
        if (updateStats) {
            return new StartSourceCallable(currentNanos, source, sourceSchema, consumer, this._consumerStats, this._unifiedClientStats);
        }
        return new StartSourceCallable(currentNanos, source, sourceSchema, consumer, null, null);
    }

    @Override
    public ConsumerCallable<ConsumerCallbackResult> createOnErrorCallable(long currentNanos, Throwable err, DatabusCombinedConsumer consumer, boolean updateStats) {
        if (updateStats) {
            return new OnErrorCallable(currentNanos, err, consumer, this._consumerStats, this._unifiedClientStats);
        }
        return new OnErrorCallable(currentNanos, err, consumer, null, null);
    }
}

