/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.test;

import com.linkedin.databus2.test.ConditionCheck;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.I0Itec.zkclient.IDefaultNameSpace;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.ZkServer;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.testng.Assert;

public class TestUtil {
    public static final SimpleDateFormat SIMPLE_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmmss");
    public static final String ECLIPSE_TEST_BASE_DIR = "ECLIPSE_TEST_BASE_DIR";

    public static void setupLoggingWithTimestampedFile(boolean logToConsole, String fileNamePrefix, String fileNameSuffix, Level logLevel) {
        String fileName = fileNamePrefix + SIMPLE_TIMESTAMP_FORMAT.format(new Date()) + fileNameSuffix;
        TestUtil.setupLogging(logToConsole, fileName, logLevel);
    }

    public static void setupLogging(Level logLevel) {
        TestUtil.setupLogging(true, "", logLevel);
    }

    public static void setupLogging(boolean logToConsole, String fileLogPath, Level logLevel) {
        PatternLayout defaultLayout = new PatternLayout("%d{ISO8601} [%t] (%p) {%c{1}} %m%n");
        Logger.getRootLogger().removeAllAppenders();
        if (logToConsole) {
            ConsoleAppender defaultAppender = new ConsoleAppender((Layout)defaultLayout);
            Logger.getRootLogger().addAppender((Appender)defaultAppender);
        }
        if (null != fileLogPath && 0 < fileLogPath.length()) {
            File logFile = new File(fileLogPath);
            if (null != logFile.getParentFile() && !logFile.getParentFile().exists() && !logFile.getParentFile().mkdirs()) {
                Logger.getRootLogger().error((Object)("unable to create parent directory for log file: " + logFile));
            }
            FileAppender fileAppender = null;
            try {
                fileAppender = new FileAppender((Layout)defaultLayout, fileLogPath);
            }
            catch (IOException io) {
                Logger.getRootLogger().error((Object)io);
            }
            if (null != fileAppender) {
                Logger.getRootLogger().addAppender((Appender)fileAppender);
            }
        }
        Logger.getRootLogger().setLevel(logLevel);
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean setupEclipsePath() {
        String prop = System.getProperty("java.class.path");
        if (prop != null && prop.contains("eclipse")) {
            System.setProperty(ECLIPSE_TEST_BASE_DIR, "../..");
            return true;
        }
        return false;
    }

    public static void assertWithBackoff(ConditionCheck check, String message, long maxTimeoutMs, Logger log) {
        boolean done = check.check();
        long sleepDuration = 1L;
        while (!done && sleepDuration < maxTimeoutMs) {
            if (null != log) {
                log.info((Object)("sleeping for " + sleepDuration + " ms while waiting for condition: " + message));
            }
            TestUtil.sleep(sleepDuration);
            done = check.check();
            sleepDuration = (long)(1.3 * (double)sleepDuration + 1.0);
        }
        Assert.assertTrue((boolean)check.check(), (String)message);
    }

    public static boolean checkServerRunning(String host, int port, Logger log) {
        return TestUtil.checkServerRunning(host, port, log, true);
    }

    public static boolean checkServerRunning(String host, int port, Logger log, boolean logError) {
        boolean success;
        block7: {
            success = false;
            try {
                Socket socket = new Socket(host, port);
                log.info((Object)("host=" + host + " port=" + port));
                log.info((Object)("Socket Info:" + socket.toString()));
                log.info((Object)("IsConnected=" + socket.isConnected() + " isClosed=" + socket.isClosed() + " isBound=" + socket.isBound()));
                success = socket.isConnected();
                socket.close();
            }
            catch (ConnectException ce) {
                if (null != log) {
                    log.error((Object)("Fail to connect to port:" + port));
                }
                if (logError && null != log) {
                    log.error((Object)"Connect error", (Throwable)ce);
                }
                success = false;
            }
            catch (IOException e) {
                if (logError && null != log) {
                    log.error((Object)"connect error", (Throwable)e);
                }
            }
            catch (RuntimeException e) {
                if (!logError || null == log) break block7;
                log.error((Object)"runtime error", (Throwable)e);
            }
        }
        return success;
    }

    public static List<ZkServer> startLocalZookeeper(List<Integer> localPortsList, String zkTestDataRootDir, int tickTime) throws IOException {
        ArrayList<ZkServer> localZkServers = new ArrayList<ZkServer>();
        int count = 0;
        for (int port : localPortsList) {
            ZkServer zkServer = TestUtil.startZkServer(zkTestDataRootDir, count++, port, tickTime);
            localZkServers.add(zkServer);
        }
        return localZkServers;
    }

    public static ZkServer startZkServer(String zkTestDataRootDir, int machineId, int port, int tickTime) throws IOException {
        File zkTestDataRootDirFile = new File(zkTestDataRootDir);
        zkTestDataRootDirFile.mkdirs();
        String dataPath = zkTestDataRootDir + "/" + machineId + "/" + port + "/data";
        String logPath = zkTestDataRootDir + "/" + machineId + "/" + port + "/log";
        FileUtils.deleteDirectory((File)new File(dataPath));
        FileUtils.deleteDirectory((File)new File(logPath));
        IDefaultNameSpace mockDefaultNameSpace = new IDefaultNameSpace(){

            public void createDefaultNameSpace(ZkClient zkClient) {
            }
        };
        ZkServer zkServer = new ZkServer(dataPath, logPath, mockDefaultNameSpace, port, tickTime);
        zkServer.start();
        return zkServer;
    }

    public static void stopLocalZookeeper(List<ZkServer> localZkServers) {
        for (ZkServer zkServer : localZkServers) {
            zkServer.shutdown();
        }
    }

    public static String join(String[] name, String delim) {
        StringBuilder joined = new StringBuilder();
        if (name.length > 0) {
            joined.append(name[0]);
            for (int i = 1; i < name.length; ++i) {
                joined.append(delim);
                joined.append(name[i]);
            }
        }
        return joined.toString();
    }
}

